/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.runtime.neo4j.domain.RuntimeDuty;
import com.digiwin.athena.athenadeployer.runtime.neo4j.repository.RuntimeDutyRepository;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="DutyCompile")
public class DutyCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DutyCompile.class);
    @Autowired(required=false)
    private RuntimeDutyRepository runtimeDutyRepository;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
        String sourceFolder = Constant.DESIGNER_DATA_PATH + "neo4j/Duty";
        String targetFolder = Constant.ATHENA_DATA_PATH + "neo4j/Duty";
        FileUtils.copyFolder((String)sourceFolder, (String)targetFolder);
    }

    public void doCompile(String applicationCode) {
        String sourceFolder = Constant.DESIGNER_DATA_PATH + applicationCode + "/neo4j/Duty";
        String targetFolder = Constant.ATHENA_DATA_PATH + applicationCode + "/neo4j/Duty";
        FileUtils.copyFolder((String)sourceFolder, (String)targetFolder);
    }

    public void compileAndCompare(String applicationCode) {
        if (!"common".equals(applicationCode.toLowerCase())) {
            return;
        }
        List runtimeEntityList = this.runtimeDutyRepository.findAll();
        List designEntityList = FileUtils.readAllObjectFromFilePath((String)(Constant.DESIGNER_DATA_PATH + applicationCode + "/neo4j/Duty"), JSONObject.class);
        this.saveDiff(this.bean2JSONObject(runtimeEntityList), designEntityList, applicationCode, "duty", "code");
        for (JSONObject designEntity : designEntityList) {
            String code = designEntity.getString("code");
            designEntity.remove((Object)"isMigrate");
            designEntity.remove((Object)"labels");
            designEntity.remove((Object)"graphId");
            RuntimeDuty runtimeEntity = runtimeEntityList.stream().filter(item -> code.equals(item.getCode())).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
                continue;
            }
            runtimeEntity.setActionLabels(null);
            runtimeEntity.setGraphId(null);
            this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)designEntity), "duty", applicationCode, "transferCompare");
        }
        String sourceFolder = Constant.DESIGNER_DATA_PATH + applicationCode + "/neo4j/Duty";
        String targetFolder = Constant.ATHENA_DATA_PATH + applicationCode + "/neo4j/Duty";
        FileUtils.copyFolder((String)sourceFolder, (String)targetFolder);
    }
}

