/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.domain.base.RelationTable;
import com.digiwin.athena.athenadeployer.domain.monitorRule.MonitorRule;
import com.digiwin.athena.athenadeployer.domain.monitorRule.MonitorRuleNeo4j;
import com.digiwin.athena.athenadeployer.enums.SceneCodeEnum;
import com.digiwin.athena.athenadeployer.runtime.neo4j.domain.RuntimeMonitorRule;
import com.digiwin.athena.athenadeployer.runtime.neo4j.repository.RuntimeMonitorRuleRepository;
import com.digiwin.athena.athenadeployer.service.ExtendFieldDataService;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="monitorRuleCompile")
public class MonitorRuleCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorRuleCompile.class);
    @Autowired
    ExtendFieldDataService extendFieldDataService;
    @Autowired(required=false)
    @Qualifier(value="kgsysMongoTemplate")
    private MongoTemplate kgsysMongoTemplate;
    @Autowired
    private JsonDiffService jsonDiffService;
    @Autowired(required=false)
    private RuntimeMonitorRuleRepository runtimeMonitorRuleRepository;

    public void doCompile() {
        List monitorRules = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/", "mongo", "test", "monitorRule"), MonitorRule.class);
        monitorRules.forEach(monitorRule -> {
            RelationTable relationTable = RelationTable.builder().targetId((Object)monitorRule.getTriggerAction()).type("Triggers").targetLabel("Action").build();
            monitorRule.setRelationTable(Arrays.asList(relationTable));
            monitorRule.setActionLabels(Arrays.asList("MonitorRule"));
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/neo4j/%s/%s.json", "MonitorRule", monitorRule.getCode()), (Object)monitorRule);
            List monitorRuleProducts = monitorRule.getProduct();
            monitorRuleProducts.forEach(product -> {
                product.getRule().put("monitorRuleId", monitorRule.getCode());
                product.getRule().put("productName", product.getCode());
                product.getRule().put("application", "applicationCode");
                Object composeData = this.extendFieldDataService.combineWithExtendFieldData(monitorRule.getCode(), product.getCode(), SceneCodeEnum.MONITORRULEPRODUCTCONFIG.getValue(), (Object)product.getRule(), "");
                FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/mongo/%s/%s/%s.json", "knowledgegraphSystem", "monitorRuleProductConfig", monitorRule.getCode() + "__" + product.getCode()), (Object)composeData);
            });
        });
    }

    public void doCompile(String applicationCode) {
        List monitorRules = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "monitorRule"), MonitorRule.class);
        monitorRules.forEach(monitorRule -> {
            MonitorRuleNeo4j monitorRuleNeo4j = new MonitorRuleNeo4j();
            BeanUtils.copyProperties((Object)monitorRule, (Object)monitorRuleNeo4j);
            if ("SCHEDULE".equals(monitorRule.getCategory())) {
                monitorRuleNeo4j.setType(monitorRule.getCategory());
            }
            if (monitorRule.getStandardPollingRule() != null) {
                monitorRuleNeo4j.setStandardPollingRule(JSON.toJSONString((Object)monitorRule.getStandardPollingRule()));
            }
            if (monitorRule.getDynamicParams() != null) {
                monitorRuleNeo4j.setDynamicParams(JSON.toJSONString((Object)monitorRule.getDynamicParams()));
            }
            if (monitorRule.getDynamicCondition() != null) {
                monitorRuleNeo4j.setDynamicCondition(JSON.toJSONString((Object)monitorRule.getDynamicCondition()));
            }
            RelationTable relationTable = RelationTable.builder().targetId((Object)monitorRuleNeo4j.getTriggerAction()).type("Triggers").targetLabel("Action").build();
            monitorRuleNeo4j.setRelationTable(Arrays.asList(relationTable));
            monitorRuleNeo4j.setActionLabels(Arrays.asList("MonitorRule"));
            Object composeDataM = this.extendFieldDataService.combineWithExtendFieldData(monitorRule.getCode(), null, SceneCodeEnum.MONITORRULE.getValue(), (Object)monitorRuleNeo4j, applicationCode);
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + applicationCode + "/neo4j/%s/%s.json", "MonitorRule", monitorRuleNeo4j.getCode()), (Object)composeDataM);
            List monitorRuleProducts = monitorRule.getProduct();
            if (monitorRuleProducts != null) {
                monitorRuleProducts.forEach(product -> {
                    product.getRule().put("monitorRuleId", monitorRule.getCode());
                    product.getRule().put("productName", product.getCode());
                    product.getRule().put("application", "applicationCode");
                    product.getRule().put("tenantId", monitorRule.getTenantId());
                    Object composeData = this.extendFieldDataService.combineWithExtendFieldData(monitorRule.getCode(), product.getCode(), SceneCodeEnum.MONITORRULEPRODUCTCONFIG.getValue(), (Object)product.getRule(), applicationCode);
                    FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + applicationCode + "/mongo/%s/%s/%s.json", "knowledgegraphSystem", "monitorRuleProductConfig", monitorRule.getCode() + "__" + product.getCode()), (Object)composeData);
                });
            }
        });
    }

    public void compileAndCompare(String applicationCode) {
        List runtimeEntityList = this.runtimeMonitorRuleRepository.findByApplication(this.getApplicationByAppCode(applicationCode));
        List monitorRules = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "monitorRule"), MonitorRule.class);
        this.saveDiff(this.bean2JSONObject(runtimeEntityList), this.bean2JSONObject(monitorRules), applicationCode, "monitorRule", "code");
        monitorRules.forEach(monitorRule -> {
            MonitorRuleNeo4j monitorRuleNeo4j = new MonitorRuleNeo4j();
            BeanUtils.copyProperties((Object)monitorRule, (Object)monitorRuleNeo4j);
            if ("SCHEDULE".equals(monitorRule.getCategory())) {
                monitorRuleNeo4j.setType(monitorRule.getCategory());
            }
            if (monitorRule.getStandardPollingRule() != null) {
                monitorRuleNeo4j.setStandardPollingRule(JSON.toJSONString((Object)monitorRule.getStandardPollingRule()));
            }
            if (monitorRule.getDynamicParams() != null) {
                monitorRuleNeo4j.setDynamicParams(JSON.toJSONString((Object)monitorRule.getDynamicParams()));
            }
            if (monitorRule.getDynamicCondition() != null) {
                monitorRuleNeo4j.setDynamicCondition(JSON.toJSONString((Object)monitorRule.getDynamicCondition()));
            }
            RelationTable relationTable = RelationTable.builder().targetId((Object)monitorRuleNeo4j.getTriggerAction()).type("Triggers").targetLabel("Action").build();
            monitorRuleNeo4j.setRelationTable(Arrays.asList(relationTable));
            monitorRuleNeo4j.setActionLabels(Arrays.asList("MonitorRule"));
            monitorRuleNeo4j.setObjectId(null);
            RuntimeMonitorRule runtimeEntity = runtimeEntityList.stream().filter(item -> monitorRule.getCode().equals(item.getCode())).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)monitorRule.getCode());
            } else {
                runtimeEntity.setId(null);
                runtimeEntity.setNeo4jId(null);
                runtimeEntity.setPollingInterval(null);
                runtimeEntity.setVersion(null);
                this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)monitorRuleNeo4j), "monitorRule", applicationCode, "transferCompare");
            }
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + applicationCode + "/neo4j/%s/%s.json", "MonitorRule", monitorRuleNeo4j.getCode()), (Object)monitorRuleNeo4j);
            List monitorRuleProducts = monitorRule.getProduct();
            if (monitorRuleProducts != null) {
                monitorRuleProducts.forEach(product -> {
                    Query query2 = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)this.getApplicationByAppCode(applicationCode)).and("monitorRuleId").is((Object)monitorRule.getCode()).and("productName").is((Object)product.getCode()));
                    List runtimeEntityList2 = this.kgsysMongoTemplate.find(query2, JSONObject.class, "monitorRuleProductConfig");
                    product.getRule().put("monitorRuleId", monitorRule.getCode());
                    product.getRule().put("productName", product.getCode());
                    product.getRule().put("application", "applicationCode");
                    product.getRule().put("tenantId", monitorRule.getTenantId());
                    Object composeData = this.extendFieldDataService.combineWithExtendFieldData(monitorRule.getCode(), product.getCode(), SceneCodeEnum.MONITORRULEPRODUCTCONFIG.getValue(), (Object)product.getRule(), applicationCode);
                    if (!CollectionUtils.isEmpty((Collection)runtimeEntityList2)) {
                        JSONObject runtimeEntity2 = (JSONObject)runtimeEntityList2.get(0);
                        runtimeEntity2.remove((Object)"_id");
                        runtimeEntity2.remove((Object)"version");
                        runtimeEntity2.remove((Object)"athena_namespace");
                        this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity2), JSON.toJSONString((Object)composeData), "monitorRuleProductConfig", applicationCode, "transferCompare");
                    } else {
                        log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)monitorRule.getCode());
                    }
                    FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + applicationCode + "/mongo/%s/%s/%s.json", "knowledgegraphSystem_publish", "monitorRuleProductConfig", monitorRule.getCode() + "__" + product.getCode()), (Object)composeData);
                });
            }
        });
    }
}

