/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.domain.esp.EspResponse;
import com.digiwin.athena.athenadeployer.domain.esp.EspResponseSuccess;
import com.digiwin.athena.athenadeployer.domain.pageView.BackFill;
import com.digiwin.athena.athenadeployer.domain.pageView.ButtonAction;
import com.digiwin.athena.athenadeployer.domain.pageView.Multilingual;
import com.digiwin.athena.athenadeployer.domain.pageView.constants.MetaConstant;
import com.digiwin.athena.athenadeployer.domain.pageView.design.ButtonDesign;
import com.digiwin.athena.athenadeployer.domain.pageView.design.DataFilterDesign;
import com.digiwin.athena.athenadeployer.domain.pageView.design.DataProcessorDesign;
import com.digiwin.athena.athenadeployer.domain.pageView.design.DataSourceDesign;
import com.digiwin.athena.athenadeployer.domain.pageView.design.PageViewDesign;
import com.digiwin.athena.athenadeployer.domain.pageView.design.ProjectDetailDataStateDesign;
import com.digiwin.athena.athenadeployer.domain.pageView.design.ProjectDetailDesign;
import com.digiwin.athena.athenadeployer.domain.pageView.design.ProjectDetailSettingDesign;
import com.digiwin.athena.athenadeployer.domain.pageView.design.TaskDetailDataStateDesign;
import com.digiwin.athena.athenadeployer.domain.pageView.design.TaskDetailDesign;
import com.digiwin.athena.athenadeployer.domain.pageView.design.operation.OpenWindowDesign;
import com.digiwin.athena.athenadeployer.domain.pageView.work.ButtonWork;
import com.digiwin.athena.athenadeployer.domain.pageView.work.DataFilterWork;
import com.digiwin.athena.athenadeployer.domain.pageView.work.DataProcessorWork;
import com.digiwin.athena.athenadeployer.domain.pageView.work.DataSourceWork;
import com.digiwin.athena.athenadeployer.domain.pageView.work.ProjectDetailDataStateWork;
import com.digiwin.athena.athenadeployer.domain.pageView.work.ProjectDetailSettingWork;
import com.digiwin.athena.athenadeployer.domain.pageView.work.ProjectDetailWork;
import com.digiwin.athena.athenadeployer.domain.pageView.work.TaskDetailDataStateWork;
import com.digiwin.athena.athenadeployer.domain.pageView.work.TaskDetailWork;
import com.digiwin.athena.athenadeployer.domain.pageView.work.operation.OpenWindowDefine;
import com.digiwin.athena.athenadeployer.domain.pageView.work.operation.OpenWindowWork;
import com.digiwin.athena.athenadeployer.domain.pageView.work.operation.TaskOperationWork;
import com.digiwin.athena.athenadeployer.domain.pageView.work.option.GroupWork;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.service.impl.ESPServiceImpl;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="pageViewCompile")
public class PageViewCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageViewCompile.class);
    @Autowired
    private ESPServiceImpl espService;
    @Autowired(required=false)
    @Qualifier(value="datamapMongoTemplate")
    private MongoTemplate dataMapMongoTemplate;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
        List pageViewDesignList = FileUtils.readAllObjectFromFilePath((String)"/Users/lyt/Downloads/pageViewJson", PageViewDesign.class);
    }

    public void doCompile(String applicationCode) {
        FileUtils.copyFolder((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "pageView"), (String)String.format(Constant.ATHENA_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "pageView"));
    }

    public void compileAndCompare(String applicationCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)this.getApplicationByAppCode(applicationCode)));
        List runtimeEntityList = this.dataMapMongoTemplate.find(query, JSONObject.class, "pageView");
        List designEntityList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "pageView"), JSONObject.class);
        this.saveDiff(runtimeEntityList, designEntityList, applicationCode, "pageView", "code");
        for (JSONObject designEntity : designEntityList) {
            String code = designEntity.getString("code");
            designEntity.remove((Object)"objectId");
            designEntity.remove((Object)"isMigrate");
            JSONObject runtimeEntity = runtimeEntityList.stream().filter(item -> code.equals(item.getString("code"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
                continue;
            }
            runtimeEntity.remove((Object)"_id");
            runtimeEntity.remove((Object)"milestone");
            runtimeEntity.remove((Object)"lang");
            runtimeEntity.remove((Object)"athena_namespace");
            runtimeEntity.remove((Object)"_class");
            runtimeEntity.remove((Object)"score");
            runtimeEntity.remove((Object)"datamap");
            this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)designEntity), "pageView", applicationCode, "transferCompare");
        }
        FileUtils.copyFolder((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "pageView"), (String)String.format(Constant.ATHENA_DATA_PATH + "/%s/%s/%s/%s/", applicationCode, "mongo", "datamap_publish", "pageView"));
    }

    private ProjectDetailWork transferProjectDetail(ProjectDetailDesign projectDetail) {
        ProjectDetailWork projectDetailWork = new ProjectDetailWork();
        projectDetailWork.setEnableDataState(projectDetail.getEnableDataState());
        List dataStates = projectDetail.getDataStates();
        ArrayList<ProjectDetailDataStateWork> dataStateWorkList = new ArrayList<ProjectDetailDataStateWork>();
        for (ProjectDetailDataStateDesign dataState : dataStates) {
            ProjectDetailSettingDesign setting = dataState.getSettings();
            List options = setting.getOptions();
            ProjectDetailSettingWork settingWork = new ProjectDetailSettingWork();
            settingWork.setDefaultSetting(setting.getDefaultSetting()).setTarget(setting.getTarget());
            ArrayList<GroupWork> optionWorkList = new ArrayList<GroupWork>();
            for (JSONObject option : options) {
                String type;
                switch (type = option.getString("type")) {
                    case "group": {
                        GroupWork groupWork = (GroupWork)JSON.toJavaObject((JSON)option, GroupWork.class);
                        optionWorkList.add(groupWork);
                    }
                }
            }
            settingWork.setOptions(optionWorkList);
            HashMap settingWorkMap = Maps.newHashMap();
            settingWorkMap.put("project-settings", settingWork);
            ProjectDetailDataStateWork dataStateWork = new ProjectDetailDataStateWork();
            dataStateWork.setCode(UUID.randomUUID().toString()).setDataFilterCode(dataState.getDataFilterCode()).setSettings((Map)settingWorkMap);
            dataStateWorkList.add(dataStateWork);
        }
        projectDetailWork.setDataStates(dataStateWorkList);
        return projectDetailWork;
    }

    private TaskDetailWork transferTaskDetailWork(TaskDetailDesign taskDetail) {
        TaskDetailWork taskDetailWork = new TaskDetailWork();
        List dataStates = taskDetail.getDataStates() != null ? taskDetail.getDataStates() : new ArrayList();
        for (TaskDetailDataStateDesign dataState : dataStates) {
            String dataFilterCode = dataState.getDataFilterCode();
            List operations = dataState.getOperations();
            List taskOperationWorks = this.transferOperation(operations);
            List submitActions = dataState.getSubmitActions();
            List submitActionWorkList = this.transferSubmitAction(submitActions);
            if (Strings.isBlank((String)dataFilterCode)) {
                taskDetailWork.setOperations(taskOperationWorks);
                taskDetailWork.setSubmitActions(submitActionWorkList);
                continue;
            }
            TaskDetailDataStateWork taskDetailDataStateWork = new TaskDetailDataStateWork();
            taskDetailDataStateWork.setDataFilterCode(dataState.getDataFilterCode()).setCode(UUID.randomUUID().toString()).setOperations(taskOperationWorks).setSubmitActions(submitActionWorkList);
        }
        return taskDetailWork;
    }

    private List<DataSourceWork> transferSubmitAction(List<DataSourceDesign> submitActions) {
        ArrayList<DataSourceWork> submitActionWorkList = new ArrayList<DataSourceWork>();
        for (DataSourceDesign submitAction : submitActions) {
            Map submitActionWork = this.datasourceDesign2Work(submitAction);
            submitActionWorkList.addAll(submitActionWork.values());
        }
        return submitActionWorkList;
    }

    private List<? extends TaskOperationWork> transferOperation(List<JSONObject> operations) {
        ArrayList<OpenWindowWork> operationWorkList = new ArrayList<OpenWindowWork>();
        for (JSONObject operation : operations) {
            String operate;
            switch (operate = operation.getString("operate")) {
                case "openwindow": {
                    OpenWindowWork openWindowWork = this.setOpenWindow((OpenWindowDesign)JSON.toJavaObject((JSON)operation, OpenWindowDesign.class));
                    operationWorkList.add(openWindowWork);
                }
            }
        }
        return operationWorkList;
    }

    private OpenWindowWork setOpenWindow(OpenWindowDesign operation) {
        OpenWindowWork openWindowWork = new OpenWindowWork();
        OpenWindowDesign openWindowDesign = operation;
        Multilingual title = openWindowDesign.getTitle();
        Multilingual description = openWindowDesign.getDescription();
        HashMap<String, Multilingual> language = new HashMap<String, Multilingual>();
        language.put("title", title);
        language.put("description", description);
        openWindowWork.setTitle(title.getZh_CN()).setDescription(description.getZh_CN()).setOperate(openWindowDesign.getOperate()).setLanguage(language);
        openWindowWork.setTarget(openWindowDesign.getTarget()).setApplyToField(openWindowDesign.getApplyToField()).setModel(openWindowDesign.getModel());
        OpenWindowDefine openWindowDefine = new OpenWindowDefine();
        Multilingual openWindowTitle = openWindowDesign.getOpenWindowTitle();
        HashMap<String, Multilingual> openWindowLanguage = new HashMap<String, Multilingual>();
        openWindowLanguage.put("title", openWindowTitle);
        DataSourceDesign dataSource = openWindowDesign.getDataSource();
        Map dataSourceWork = this.datasourceDesign2Work(dataSource);
        openWindowDefine.setTitle(openWindowTitle.getZh_CN()).setLanguage(openWindowLanguage).setAllAction((DataSourceWork)dataSourceWork.values().stream().findFirst().orElse(null)).setApplyToArray(openWindowDesign.getApplyToArray()).setMultipleSelect(openWindowDesign.getMultipleSelect()).setSelectedFirstRow(openWindowDesign.getSelectedFirstRow());
        List buttons = openWindowDesign.getButtons();
        ArrayList<ButtonWork> buttonWorkList = new ArrayList<ButtonWork>();
        for (ButtonDesign button : buttons) {
            ButtonWork buttonWork = new ButtonWork();
            String type = button.getType();
            Multilingual buttonTitle = button.getTitle();
            if (buttonTitle == null) {
                Map defaultTitleByType = MetaConstant.ButtonType.getDefaultTitleByType();
                buttonTitle = (Multilingual)defaultTitleByType.get(type);
            }
            HashMap<String, Multilingual> buttonLanguage = new HashMap<String, Multilingual>();
            buttonLanguage.put("title", buttonTitle);
            List backFills = button.getBackFills();
            for (BackFill backFill : backFills) {
                switch (type) {
                    case "submit": {
                        String key = backFill.getKey();
                        backFill.setValueScript(String.format("selectedObject['%s']", key));
                        break;
                    }
                    case "reset": {
                        backFill.setType("reset");
                    }
                }
            }
            ButtonAction buttonAction = new ButtonAction();
            buttonAction.setBackFills(backFills);
            buttonWork.setId(button.getType().toLowerCase()).setTitle(buttonTitle.getZh_CN()).setActions((List)Lists.newArrayList((Object[])new ButtonAction[]{buttonAction})).setLanguage(buttonLanguage);
            buttonWorkList.add(buttonWork);
        }
        openWindowDefine.setButtons(buttonWorkList);
        openWindowWork.setOpenWindowDefine(openWindowDefine);
        return openWindowWork;
    }

    public Map<String, DataSourceWork> datasourceDesign2Work(DataSourceDesign dataSourceDesign) {
        DataSourceWork dataSourceWork = new DataSourceWork();
        String actionIdWithPrefix = dataSourceDesign.getActionId();
        String actionId = actionIdWithPrefix.replaceAll("esp_", "");
        List params = dataSourceDesign.getParams();
        EspResponse actionInfo = this.espService.getApiInfoById(actionId);
        EspResponseSuccess espResponseSuccess = actionInfo.getEspResponseSuccess();
        List businessFields = espResponseSuccess.getBusinessFields();
        String datasourceKey = espResponseSuccess.getDatasourceKey();
        List dataKeys = businessFields.stream().filter(field -> field.getIs_datakey()).map(field -> field.getData_name()).collect(Collectors.toList());
        Multilingual description = actionInfo.getDescription();
        HashMap language = Maps.newHashMap();
        language.put("title", description);
        dataSourceWork.setActionId(actionId).setDataKeys(dataKeys).setTitle(description.getZh_CN()).setSequence(Integer.valueOf(0)).setActionParams(params).setServiceName(actionId).setLanguage((Map)language).setType("ESP").setAttachActions(dataSourceDesign.getAttachActions());
        HashMap result = Maps.newHashMap();
        result.put(datasourceKey, dataSourceWork);
        return result;
    }

    public DataProcessorWork dataProcessorDesign2Work(DataProcessorDesign dataProcessorDesign) {
        DataProcessorWork dataProcessorWork = new DataProcessorWork();
        dataProcessorWork.setParams(dataProcessorDesign.getParas()).setType(dataProcessorDesign.getType()).setServiceName(dataProcessorDesign.getServiceName());
        return dataProcessorWork;
    }

    public DataFilterWork dataFilterDesign2Work(DataFilterDesign dataFilterDesign, List<String> dataSourceNames) {
        DataFilterWork dataFilterWork = new DataFilterWork();
        Multilingual title = dataFilterDesign.getTitle();
        Multilingual description = dataFilterDesign.getDescription();
        String type = dataFilterDesign.getType();
        if (!Strings.isBlank((String)type)) {
            Map defaultTitleByType;
            if (title == null) {
                defaultTitleByType = MetaConstant.DataFilterType.getDefaultTitleByType();
                title = (Multilingual)defaultTitleByType.get(type);
            }
            if (description == null) {
                defaultTitleByType = MetaConstant.DataFilterType.getDefaultTitleByType();
                description = (Multilingual)defaultTitleByType.get(type);
            }
        }
        HashMap language = Maps.newHashMap();
        language.put("title", title);
        language.put("description", description);
        dataFilterWork.setCode(UUID.randomUUID().toString()).setApiFilter(dataFilterDesign.getApiFilter()).setDefaultFilter(dataFilterDesign.getDefaultFilter()).setApiCondition(dataFilterDesign.getApiCondition()).setApplyTo(dataFilterDesign.getApplyTo()).setDescription(description.getZh_CN()).setTitle(title.getZh_CN()).setLanguage((Map)language).addDataSourceName(dataFilterDesign.getDataSourceName() == null ? dataSourceNames.get(0) : dataFilterDesign.getDataSourceName()).setRowSizeType(dataFilterDesign.getRowSizeType());
        return dataFilterWork;
    }
}

