/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.enums.SceneCodeEnum;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.BatchFileDataIntegrationUtils;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="projectCompile")
public class ProjectCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectCompile.class);
    @Autowired
    BatchFileDataIntegrationUtils batchFileDataIntegrationUtils;
    @Autowired(required=false)
    @Qualifier(value="datamapMongoTemplate")
    private MongoTemplate dataMapMongoTemplate;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
        this.batchFileDataIntegrationUtils.batchFileDataIntegration(String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/", "mongo", "test", "project"), String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/", "mongo", "datamap", "project"), SceneCodeEnum.DATAMAPPROJECT.getValue(), "");
    }

    public void doCompile(String applicationCode) {
        this.batchFileDataIntegrationUtils.batchFileDataIntegration(String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "project"), String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "project"), SceneCodeEnum.DATAMAPPROJECT.getValue(), applicationCode);
    }

    public void compileAndCompare(String applicationCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)this.getApplicationByAppCode(applicationCode)));
        List runtimeEntityList = this.dataMapMongoTemplate.find(query, JSONObject.class, "project");
        List designEntityList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "project"), JSONObject.class);
        this.saveDiff(runtimeEntityList, designEntityList, applicationCode, "project", "code");
        for (JSONObject designEntity : designEntityList) {
            String code = designEntity.getString("code");
            designEntity.remove((Object)"objectId");
            designEntity.remove((Object)"isMigrate");
            JSONObject runtimeEntity = runtimeEntityList.stream().filter(item -> code.equals(item.getString("code"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
                continue;
            }
            runtimeEntity.remove((Object)"_id");
            runtimeEntity.remove((Object)"score");
            runtimeEntity.remove((Object)"_class");
            runtimeEntity.remove((Object)"athena_namespace");
            runtimeEntity.remove((Object)"version");
            runtimeEntity.remove((Object)"datamap");
            this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)designEntity), "project", applicationCode, "transferCompare");
        }
        this.batchFileDataIntegrationUtils.batchFileDataIntegration(String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "project"), String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap_publish", "project"), SceneCodeEnum.DATAMAPPROJECT.getValue(), applicationCode);
    }
}

