/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.enums.SceneCodeEnum;
import com.digiwin.athena.athenadeployer.service.ExtendFieldDataService;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.BatchFileDataIntegrationUtils;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="ruleCompile")
public class RuleCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleCompile.class);
    @Autowired
    BatchFileDataIntegrationUtils batchFileDataIntegrationUtils;
    @Autowired
    private ExtendFieldDataService extendFieldDataService;
    @Autowired(required=false)
    @Qualifier(value="presetMongoTemplate")
    private MongoTemplate presetMongoTemplate;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
        this.batchFileDataIntegrationUtils.batchFileDataIntegration(String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/", "mongo", "test", "rules"), String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/", "mongo", "preset", "rules"), SceneCodeEnum.BUSINESSRULE.getValue(), "");
    }

    public void doCompile(String applicationCode) {
        List ruleList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "preset", "rules"), JSONObject.class);
        for (JSONObject rule : ruleList) {
            rule.put("domain", (Object)"ACTIVITY");
            rule.remove((Object)"remark");
            Object composeData = this.extendFieldDataService.combineWithExtendFieldData(rule.getString("key"), null, SceneCodeEnum.BUSINESSRULE.getValue(), (Object)rule, applicationCode);
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", applicationCode, "preset", "rules", rule.getString("key")), (Object)composeData);
        }
    }

    public void compileAndCompare(String applicationCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)this.getApplicationByAppCode(applicationCode)));
        List runtimeEntityList = this.presetMongoTemplate.find(query, JSONObject.class, "rules");
        List ruleList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "preset", "rules"), JSONObject.class);
        this.saveDiff(runtimeEntityList, ruleList, applicationCode, "rules", "key");
        for (JSONObject rule : ruleList) {
            rule.put("domain", (Object)"ACTIVITY");
            rule.remove((Object)"objectId");
            rule.remove((Object)"isMigrate");
            if (rule.getString("key") == null) continue;
            Object composeData = this.extendFieldDataService.combineWithExtendFieldData(rule.getString("key"), null, SceneCodeEnum.BUSINESSRULE.getValue(), (Object)rule, applicationCode);
            String code = rule.getString("key");
            JSONObject runtimeEntity = runtimeEntityList.stream().filter(item -> code.equals(item.getString("key"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
            } else {
                runtimeEntity.remove((Object)"_id");
                runtimeEntity.remove((Object)"version");
                runtimeEntity.remove((Object)"_class");
                runtimeEntity.remove((Object)"description");
                runtimeEntity.remove((Object)"athena_namespace");
                JSONObject content = runtimeEntity.getJSONObject("content");
                if (content != null) {
                    content.remove((Object)"validatortype");
                    content.remove((Object)"targetScchema");
                }
                this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)composeData), "rules", applicationCode, "transferCompare");
            }
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", applicationCode, "preset_publish", "rules", rule.getString("key")), (Object)composeData);
        }
    }
}

