/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.digiwin.athena.athenadeployer.compile.Applications;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.domain.base.Language;
import com.digiwin.athena.athenadeployer.domain.base.RelationTable;
import com.digiwin.athena.athenadeployer.domain.tag.ActionBindingTag;
import com.digiwin.athena.athenadeployer.domain.tag.AdTag;
import com.digiwin.athena.athenadeployer.domain.tag.BuiltInData;
import com.digiwin.athena.athenadeployer.domain.tag.Field;
import com.digiwin.athena.athenadeployer.domain.tag.RelatedObject;
import com.digiwin.athena.athenadeployer.domain.tag.Tag;
import com.digiwin.athena.athenadeployer.domain.tag.TaggingData;
import com.digiwin.athena.athenadeployer.domain.tag.TaskAction;
import com.digiwin.athena.athenadeployer.domain.tag.TaskRelation;
import com.digiwin.athena.athenadeployer.enums.RelatedObjectTypeEnum;
import com.digiwin.athena.athenadeployer.enums.TagTypeEnum;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import com.digiwin.athena.athenadeployer.utils.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="TagDataCompile")
public class TagDataCompile
implements DesignerDataCompile {
    @Autowired
    private IdWorker idWorker;
    private static final String SYSTEM = "SYSTEM";

    public void doCompile() {
        Set applicationCodes = Applications.getInstance().getApplicationSet();
        applicationCodes.forEach(arg_0 -> this.createTag(arg_0));
        this.createPublicRole();
        this.createPublicRelatedObjectAndRelations();
        this.createPublicTaggingData();
        applicationCodes.forEach(applicationCode -> {
            List taskRelations = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/", applicationCode, "test", "taskRelation"), TaskRelation.class);
            taskRelations.parallelStream().filter(taskRelation -> !CollectionUtils.isEmpty((Collection)taskRelation.getActions())).forEach(taskRelation -> {
                String taskCode = taskRelation.getTaskCode();
                String taskName = taskRelation.getTaskName();
                List taskActions = taskRelation.getActions();
                taskActions.forEach(action -> {
                    String type;
                    switch (type = action.getType()) {
                        case "general": {
                            int roleType = 3;
                            this.handleTaskAction((long)roleType, action, taskCode, taskName, applicationCode);
                            break;
                        }
                        case "charge": {
                            int roleType = 1;
                            this.handleTaskAction((long)roleType, action, taskCode, taskName, applicationCode);
                            break;
                        }
                        case "performer": {
                            int roleType = 2;
                            this.handleTaskAction((long)roleType, action, taskCode, taskName, applicationCode);
                            break;
                        }
                    }
                });
            });
        });
    }

    public void doCompile(String applicationCode) {
        this.createTag(applicationCode);
        this.createPublicRole();
        this.createPublicRelatedObjectAndRelations();
        this.createPublicTaggingData();
        List taskRelations = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "tagSystem", "taskRelation"), TaskRelation.class);
        taskRelations.parallelStream().filter(taskRelation -> !CollectionUtils.isEmpty((Collection)taskRelation.getActions())).forEach(taskRelation -> {
            String taskCode = taskRelation.getTaskCode();
            String taskName = taskRelation.getTaskName();
            List taskActions = taskRelation.getActions();
            taskActions.forEach(action -> {
                String type;
                switch (type = action.getType()) {
                    case "general": {
                        int roleType = 3;
                        this.handleTaskAction((long)roleType, action, taskCode, taskName, applicationCode);
                        break;
                    }
                    case "charge": {
                        int roleType = 1;
                        this.handleTaskAction((long)roleType, action, taskCode, taskName, applicationCode);
                        break;
                    }
                    case "performer": {
                        int roleType = 2;
                        this.handleTaskAction((long)roleType, action, taskCode, taskName, applicationCode);
                        break;
                    }
                }
            });
        });
    }

    public void compileAndCompare(String applicationCode) {
    }

    private void createTag(String applicationCode) {
        List adTags = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/", applicationCode, "neo4j", "AdTag"), AdTag.class);
        adTags.parallelStream().forEach(adTag -> {
            Tag tag = this.convertAdTagToTag(adTag, applicationCode);
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/neo4j/%s/%s.json", applicationCode, "Tag", tag.getCode()), (Object)tag);
        });
    }

    private Long createLanguage(String locale, String name, String applicationCode) {
        Language language = ((Language.LanguageBuilder)((Language.LanguageBuilder)Language.builder().id(Long.valueOf(this.idWorker.nextId())).locale(locale).name(name).actionLabels(Collections.singletonList("Language"))).relationTable(new ArrayList())).build();
        FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/neo4j/%s/%s.json", applicationCode, "Language", language.getId().toString()), (Object)language);
        return language.getId();
    }

    private String getPrivateCode(AdTag adTag) {
        return switch (adTag.getCategory()) {
            case "ACTIVITY" -> adTag.getOpenWindow() != false ? adTag.getTaskCode() + TagTypeEnum.OPEN_WINDOW.getCode() : adTag.getTaskCode();
            case "ROLE__ACTIVITY" -> {
                Object prefix = adTag.getTaskCode();
                if (RelatedObjectTypeEnum.PERFORMER.getCode().equals(adTag.getType())) {
                    prefix = RelatedObjectTypeEnum.PERFORMER.getCode() + "__" + (String)prefix;
                } else if (RelatedObjectTypeEnum.CHARGE.getCode().equals(adTag.getType())) {
                    prefix = RelatedObjectTypeEnum.CHARGE.getCode() + "__" + (String)prefix;
                }
                if (adTag.getOpenWindow() != null && adTag.getOpenWindow().booleanValue()) {
                    prefix = (String)prefix + TagTypeEnum.OPEN_WINDOW.getCode();
                }
                yield prefix;
            }
            default -> {
                Object prefix = adTag.getTaskCode();
                if (RelatedObjectTypeEnum.PERFORMER.getCode().equals(adTag.getType())) {
                    prefix = RelatedObjectTypeEnum.PERFORMER.getCode() + "__" + (String)prefix;
                } else if (RelatedObjectTypeEnum.CHARGE.getCode().equals(adTag.getType())) {
                    prefix = RelatedObjectTypeEnum.CHARGE.getCode() + "__" + (String)prefix;
                }
                if (adTag.getOpenWindow() != null && adTag.getOpenWindow().booleanValue()) {
                    prefix = (String)prefix + TagTypeEnum.OPEN_WINDOW.getCode();
                }
                yield (String)prefix + "__" + adTag.getCode();
            }
        };
    }

    private void createPublicRole() {
        Tag performer = ((Tag.TagBuilder)((Tag.TagBuilder)Tag.builder().code(RelatedObjectTypeEnum.PERFORMER.getCode()).category(TagTypeEnum.ROLE.getCode()).id(Long.valueOf(500001L)).name(RelatedObjectTypeEnum.PERFORMER.getName()).scope(new String[]{"column"}).status(Integer.valueOf(1)).actionLabels(Collections.singletonList("Tag"))).relationTable(new ArrayList())).tenantId(SYSTEM).build();
        Tag charge = ((Tag.TagBuilder)((Tag.TagBuilder)Tag.builder().code(RelatedObjectTypeEnum.CHARGE.getCode()).category(TagTypeEnum.ROLE.getCode()).id(Long.valueOf(500002L)).name(RelatedObjectTypeEnum.CHARGE.getName()).scope(new String[]{"column"}).status(Integer.valueOf(1)).actionLabels(Collections.singletonList("Tag"))).relationTable(new ArrayList())).tenantId(SYSTEM).build();
        FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/neo4j/%s/%s.json", "common", "Tag", performer.getCode()), (Object)performer);
        FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/neo4j/%s/%s.json", "common", "Tag", charge.getCode()), (Object)charge);
    }

    private void createPublicRelatedObjectAndRelations() {
        this.createRelatedObjectAndRelations("performer", Long.valueOf(500001L), "common", SYSTEM);
        this.createRelatedObjectAndRelations("charge", Long.valueOf(500002L), "common", SYSTEM);
    }

    private void createRelatedObjectAndRelations(String relatedObjectId, Long targetTagId, String applicationCode, String tenantId) {
        RelatedObject relatedObject = ((RelatedObject.RelatedObjectBuilder)((RelatedObject.RelatedObjectBuilder)RelatedObject.builder().id(relatedObjectId).actionLabels(Collections.singletonList("RelatedObject"))).relationTable(new ArrayList())).tenantId(tenantId).build();
        RelationTable relationTable = RelationTable.builder().type("USE").targetLabel("Tag").targetId((Object)targetTagId).build();
        relatedObject.setRelationTable(Collections.singletonList(relationTable));
        FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/neo4j/%s/%s.json", applicationCode, "RelatedObject", relatedObject.getId()), (Object)relatedObject);
    }

    private void createPublicTaggingData() {
        List actionBindingTags = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/mongo/%s/%s/", "common", "tagSystem", "actionBindingTag"), ActionBindingTag.class);
        actionBindingTags.forEach(actionBindingTag -> {
            List response;
            String actionId = actionBindingTag.getActionId();
            List request = actionBindingTag.getRequest();
            if (!CollectionUtils.isEmpty((Collection)request)) {
                request.stream().filter(field -> !CollectionUtils.isEmpty((Collection)field.getTags())).forEach(field -> field.getTags().forEach(tagId -> {
                    TaggingData taggingData = TaggingData.builder().resourceId(actionId).resourceContent(String.format("{'response': '%s.%s.%s'}", actionId, "request", field.getAttr())).tagId(tagId).id(Long.valueOf(this.idWorker.nextId())).tenantId(actionBindingTag.getTenantId()).build();
                    FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", "common", "tagSystem", "taggingData", taggingData.getId().toString()), (Object)taggingData);
                }));
            }
            if (!CollectionUtils.isEmpty((Collection)(response = actionBindingTag.getResponse()))) {
                response.stream().filter(field -> !CollectionUtils.isEmpty((Collection)field.getTags())).forEach(field -> field.getTags().forEach(tagId -> {
                    TaggingData taggingData = TaggingData.builder().resourceId(actionId).resourceContent(String.format("{'response': '%s.%s.%s'}", actionId, "response", field.getAttr())).tagId(tagId).id(Long.valueOf(this.idWorker.nextId())).tenantId(actionBindingTag.getTenantId()).build();
                    FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", "common", "tagSystem", "taggingData", taggingData.getId().toString()), (Object)taggingData);
                }));
            }
        });
    }

    private void handleTaskAction(long roleType, TaskAction action, String taskCode, String taskName, String applicationCode) {
        HashMap<String, Long> bindingInfoMap = new HashMap<String, Long>();
        bindingInfoMap.put("roleType", roleType);
        Long taskTagId = this.getOrCreateActivityTag(taskCode, taskName, action, applicationCode);
        String relatedObjectId = action.getOpenWindow() != false ? taskCode + TagTypeEnum.OPEN_WINDOW.getCode() : taskCode;
        this.createRelatedObjectAndRelations(relatedObjectId, taskTagId, applicationCode, action.getTenantId());
        Long chargeRaTagId = this.getOrCreateRoleActivityTag(RelatedObjectTypeEnum.CHARGE.getCode(), taskCode, action, applicationCode);
        Long performerRaTagId = this.getOrCreateRoleActivityTag(RelatedObjectTypeEnum.PERFORMER.getCode(), taskCode, action, applicationCode);
        this.updateRelatedObjectRelations(RelatedObjectTypeEnum.CHARGE.getCode(), chargeRaTagId);
        this.updateRelatedObjectRelations(RelatedObjectTypeEnum.PERFORMER.getCode(), performerRaTagId);
        bindingInfoMap.put("chargeRaTagId", chargeRaTagId);
        bindingInfoMap.put("performerRaTagId", performerRaTagId);
        Long uneditableTagId = this.getOrCreateUnEditableTag(taskCode, action, applicationCode);
        bindingInfoMap.put("uneditableTagId", uneditableTagId);
        action.getRequest().addAll(0, this.addBuiltInFieldAndCreateTag(action.getRequestBuiltInDatas(), action, taskCode, applicationCode));
        action.getResponse().addAll(0, this.addBuiltInFieldAndCreateTag(action.getResponseBuiltInDatas(), action, taskCode, applicationCode));
        if (!CollectionUtils.isEmpty((Collection)action.getRequest())) {
            this.handlerPrivateFieldBinding((List)action.getRequest(), action, "request", taskCode, applicationCode, bindingInfoMap);
        }
        if (!CollectionUtils.isEmpty((Collection)action.getResponse())) {
            this.handlerPrivateFieldBinding((List)action.getResponse(), action, "response", taskCode, applicationCode, bindingInfoMap);
        }
    }

    private void updateRelatedObjectRelations(String relatedObjectId, Long targetTagId) {
        RelatedObject relatedObject = (RelatedObject)FileUtils.readObjectFromFullFilePath((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/neo4j/%s/%s.json", "common", "RelatedObject", relatedObjectId), RelatedObject.class);
        boolean needAdd = true;
        if (relatedObject == null || CollectionUtils.isEmpty((Collection)relatedObject.getRelationTable())) {
            return;
        }
        for (RelationTable relationTable : relatedObject.getRelationTable()) {
            if (!targetTagId.equals(relationTable.getTargetId())) continue;
            needAdd = false;
            break;
        }
        if (needAdd) {
            RelationTable relationTable = RelationTable.builder().type("USE").targetLabel("Tag").targetId((Object)targetTagId).build();
            relatedObject.getRelationTable().add(relationTable);
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/neo4j/%s/%s.json", "common", "RelatedObject", relatedObjectId), (Object)relatedObject);
        }
    }

    private List<Field> addBuiltInFieldAndCreateTag(List<BuiltInData> builtInDatas, TaskAction action, String taskCode, String applicationCode) {
        ArrayList<Field> result = new ArrayList<Field>();
        if (CollectionUtils.isEmpty(builtInDatas)) {
            return result;
        }
        builtInDatas.forEach(data -> {
            AdTag adTag = null;
            Long tagId = null;
            if (!StringUtils.isEmpty((Object)data.getCode())) {
                adTag = AdTag.builder().id(Long.valueOf(this.idWorker.nextId())).code(data.getCode()).category(data.getCategory()).name(data.getAttrName()).applicationCode(applicationCode).taskCode(taskCode).type(action.getType()).openWindow(action.getOpenWindow()).common(Boolean.valueOf(false)).tenantId(action.getTenantId()).build();
                tagId = this.getOrCreateTag(adTag, applicationCode);
            }
            Field field = Field.builder().attr(data.getAttr()).visible(Boolean.valueOf(true)).editable(Boolean.valueOf(false)).custom(Boolean.valueOf(true)).tags(new HashSet()).builtData(Boolean.valueOf(true)).build();
            if (adTag != null) {
                field.getTags().add(tagId);
            }
            result.add(field);
        });
        return result;
    }

    private void handlerPrivateFieldBinding(List<Field> fieldList, TaskAction action, String attrType, String taskCode, String applicationCode, Map<String, Long> bindingInfoMap) {
        String actionId = action.getActionId();
        if (!CollectionUtils.isEmpty(fieldList)) {
            fieldList = fieldList.stream().filter(field -> field.getVisible()).collect(Collectors.toList());
            for (int i = 0; i < fieldList.size(); ++i) {
                boolean builtData;
                Field field2 = (Field)fieldList.get(i);
                Long roleType = bindingInfoMap.get("roleType");
                if ((roleType & 1L) == 1L) {
                    TaggingData rcTaggingData = this.createTaggingData(actionId, attrType, field2.getAttr(), bindingInfoMap.get("chargeRaTagId"), action.getTenantId());
                    FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", applicationCode, "tagSystem", "taggingData", rcTaggingData.getId().toString()), (Object)rcTaggingData);
                }
                boolean bl = builtData = field2.getBuiltData() != null ? field2.getBuiltData() : false;
                if ((roleType & 2L) == 2L && !builtData) {
                    TaggingData rpTaggingData = this.createTaggingData(actionId, attrType, field2.getAttr(), bindingInfoMap.get("performerRaTagId"), action.getTenantId());
                    FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", applicationCode, "tagSystem", "taggingData", rpTaggingData.getId().toString()), (Object)rpTaggingData);
                }
                int order = (i + 1) * 10;
                Long orderTagId = this.getOrCreateOrderTag(taskCode, action, order, applicationCode);
                TaggingData oTaggingData = this.createTaggingData(actionId, attrType, field2.getAttr(), orderTagId, action.getTenantId());
                FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", applicationCode, "tagSystem", "taggingData", oTaggingData.getId().toString()), (Object)oTaggingData);
                if (!field2.getEditable().booleanValue()) {
                    TaggingData eTaggingData = this.createTaggingData(actionId, attrType, field2.getAttr(), bindingInfoMap.get("uneditableTagId"), action.getTenantId());
                    FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", applicationCode, "tagSystem", "taggingData", eTaggingData.getId().toString()), (Object)eTaggingData);
                }
                field2.getTags().forEach(tagId -> {
                    TaggingData taggingData = this.createTaggingData(actionId, attrType, field2.getAttr(), tagId, action.getTenantId());
                    FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", applicationCode, "tagSystem", "taggingData", taggingData.getId().toString()), (Object)taggingData);
                });
            }
        }
    }

    private Long getOrCreateActivityTag(String taskCode, String taskName, TaskAction action, String applicationCode) {
        AdTag adTag = AdTag.builder().id(Long.valueOf(this.idWorker.nextId())).code(taskCode).name(taskName).taskCode(taskCode).category("ACTIVITY").applicationCode(applicationCode).openWindow(action.getOpenWindow()).type(action.getType()).common(Boolean.valueOf(false)).tenantId(action.getTenantId()).build();
        return this.getOrCreateTag(adTag, applicationCode);
    }

    private Long getOrCreateOrderTag(String taskCode, TaskAction action, int order, String applicationCode) {
        String code = "ORDER_" + order;
        String name = "\u987a\u5e8f" + order;
        AdTag adTag = AdTag.builder().id(Long.valueOf(this.idWorker.nextId())).code(code).name(name).taskCode(taskCode).category("ORDER").applicationCode(applicationCode).openWindow(action.getOpenWindow()).type(action.getType()).common(Boolean.valueOf(false)).build();
        return this.getOrCreateTag(adTag, applicationCode);
    }

    private Long getOrCreateRoleActivityTag(String role, String taskCode, TaskAction action, String applicationCode) {
        String code = role + "__" + taskCode;
        AdTag adTag = AdTag.builder().id(Long.valueOf(this.idWorker.nextId())).code(code).name("XXXX").taskCode(taskCode).category("ROLE__ACTIVITY").applicationCode(applicationCode).openWindow(action.getOpenWindow()).type(role).common(Boolean.valueOf(false)).build();
        return this.getOrCreateTag(adTag, applicationCode);
    }

    private Long getOrCreateUnEditableTag(String taskCode, TaskAction action, String applicationCode) {
        AdTag adTag = AdTag.builder().id(Long.valueOf(this.idWorker.nextId())).code("UNEDITABLE").name("\u4e0d\u53ef\u7f16\u8f91").taskCode(taskCode).category("DISPLAY").applicationCode(applicationCode).openWindow(action.getOpenWindow()).type(action.getType()).common(Boolean.valueOf(false)).tenantId(action.getTenantId()).build();
        return this.getOrCreateTag(adTag, applicationCode);
    }

    private Long getOrCreateTag(AdTag adTag, String applicationCode) {
        Tag tag = this.convertAdTagToTag(adTag, applicationCode);
        Tag getTag = (Tag)FileUtils.readObjectFromFullFilePath((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/neo4j/%s/%s.json", applicationCode, "Tag", tag.getCode()), Tag.class);
        if (null != getTag) {
            return getTag.getId();
        }
        FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/neo4j/%s/%s.json", applicationCode, "Tag", tag.getCode()), (Object)tag);
        return tag.getId();
    }

    private Tag convertAdTagToTag(AdTag adTag, String applicationCode) {
        RelationTable relationTable;
        Long laId;
        Tag tag = Tag.builder().build();
        BeanUtils.copyProperties((Object)adTag, (Object)tag);
        tag.setActionLabels(Collections.singletonList("Tag"));
        tag.setRelationTable(new ArrayList());
        tag.setScope(new String[]{"column"});
        tag.setStatus(Integer.valueOf(1));
        if (!adTag.getCommon().booleanValue()) {
            tag.setCode(this.getPrivateCode(adTag));
        }
        if (tag.getLang() == null || !tag.getLang().containsKey("name")) {
            return tag;
        }
        Map map = (Map)tag.getLang().get("name");
        if (map.containsKey("zh_TW") && !StringUtils.isEmpty(map.get("zh_TW"))) {
            laId = this.createLanguage("zh_TW", (String)map.get("zh_TW"), applicationCode);
            relationTable = RelationTable.builder().type("TRANSLATION").targetLabel("Language").targetId((Object)laId).build();
            tag.getRelationTable().add(relationTable);
        }
        if (map.containsKey("en_US") && !StringUtils.isEmpty(map.get("en_US"))) {
            laId = this.createLanguage("en_US", (String)map.get("en_US"), applicationCode);
            relationTable = RelationTable.builder().type("TRANSLATION").targetLabel("Language").targetId((Object)laId).build();
            tag.getRelationTable().add(relationTable);
        }
        return tag;
    }

    private TaggingData createTaggingData(String actionId, String attrType, String attr, Long tagId, String tenantId) {
        String resourceContent = String.format("{'response': '%s.%s.%s'}", actionId, attrType, attr);
        Long id = this.idWorker.nextId();
        return TaggingData.builder().resourceId(actionId).resourceContent(resourceContent).tagId(tagId).id(id).tenantId(tenantId).build();
    }
}

