/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.domain.action.MultiLanguageDTO;
import com.digiwin.athena.athenadeployer.domain.base.RelationTable;
import com.digiwin.athena.athenadeployer.domain.task.AtmcData;
import com.digiwin.athena.athenadeployer.domain.task.ExceptionResolvePlan;
import com.digiwin.athena.athenadeployer.domain.task.SolvePlan;
import com.digiwin.athena.athenadeployer.domain.task.TaskProblematicData;
import com.digiwin.athena.athenadeployer.enums.SceneCodeEnum;
import com.digiwin.athena.athenadeployer.service.ExtendFieldDataService;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.BatchFileDataIntegrationUtils;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import com.digiwin.athena.athenadeployer.utils.GenerateUUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component(value="taskCompile")
public class TaskCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskCompile.class);
    @Autowired
    BatchFileDataIntegrationUtils batchFileDataIntegrationUtils;
    @Autowired(required=false)
    @Qualifier(value="datamapMongoTemplate")
    private MongoTemplate dataMapMongoTemplate;
    @Autowired
    private ExtendFieldDataService extendFieldDataService;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
        this.batchFileDataIntegrationUtils.batchFileDataIntegration(String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/", "mongo", "test", "task"), String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/", "mongo", "datamap", "task"), SceneCodeEnum.DATAMAPTASK.getValue(), "");
    }

    public void doCompile(String applicationCode) {
        String path = String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "task");
        List taskList = FileUtils.readAllObjectFromFilePath((String)String.format(path, new Object[0]), JSONObject.class);
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            return;
        }
        for (JSONObject task : taskList) {
            String type;
            String code = String.valueOf(task.get((Object)"code"));
            Object subApproveConditionDropDown = task.get((Object)"subApproveConditionDropDown");
            if (!ObjectUtils.isEmpty((Object)subApproveConditionDropDown)) {
                FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", applicationCode, "knowledgegraphSystem", "subApproveConditionDropDown", code), (Object)subApproveConditionDropDown);
            }
            if ((type = String.valueOf(task.get((Object)"type"))).equals("solve") || type.equals("business")) {
                Object resolvePlans;
                List resolvePlanList;
                String taskProblematicDataId = "";
                if (!ObjectUtils.isEmpty((Object)task.get((Object)"atmcDatas"))) {
                    List atmcDataList = JSONArray.parseArray((String)JSON.toJSONString((Object)task.get((Object)"atmcDatas")), AtmcData.class);
                    List adList = atmcDataList.stream().filter(atmcData -> atmcData.getProVarKey().equals("taskProblematicData")).collect(Collectors.toList());
                    Object name = code + "_problematicData";
                    if (!CollectionUtils.isEmpty(adList)) {
                        name = ((AtmcData)adList.get(0)).getAthenaKey();
                    }
                    taskProblematicDataId = GenerateUUID.generatorUUID();
                    TaskProblematicData tpd = new TaskProblematicData();
                    tpd.setId(taskProblematicDataId);
                    tpd.setName((String)name);
                    tpd.setActionLabels(Arrays.asList("DataEntity", "TaskProblematicData"));
                    FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/neo4j/%s/%s.json", applicationCode, "TaskProblematicData", taskProblematicDataId), (Object)tpd);
                }
                List list = resolvePlanList = ObjectUtils.isEmpty((Object)(resolvePlans = task.get((Object)"resolvePlans"))) ? new ArrayList() : JSONArray.parseArray((String)JSON.toJSONString((Object)resolvePlans), ExceptionResolvePlan.class);
                if (!CollectionUtils.isEmpty(resolvePlanList)) {
                    for (ExceptionResolvePlan resolvePlan : resolvePlanList) {
                        String unqid = taskProblematicDataId + "_" + resolvePlan.getPlanId();
                        SolvePlan solvePlan = new SolvePlan();
                        solvePlan.setId(unqid);
                        solvePlan.setPlanId(resolvePlan.getPlanId());
                        solvePlan.setProjectCode(resolvePlan.getProjectCode());
                        solvePlan.setName(resolvePlan.getPlanName());
                        MultiLanguageDTO nameLang = new MultiLanguageDTO();
                        if (resolvePlan.getLang() != null) {
                            nameLang = (MultiLanguageDTO)resolvePlan.getLang().get("planName");
                        }
                        MultiLanguageDTO langNew = new MultiLanguageDTO();
                        if (!StringUtils.isEmpty((Object)nameLang.getEn_US())) {
                            langNew.setEn_US(nameLang.getEn_US());
                        }
                        if (!StringUtils.isEmpty((Object)nameLang.getZh_CN())) {
                            langNew.setZh_CN(nameLang.getZh_CN());
                        }
                        if (!StringUtils.isEmpty((Object)nameLang.getZh_TW())) {
                            langNew.setZh_TW(nameLang.getZh_TW());
                        }
                        HashMap<String, MultiLanguageDTO> lang = new HashMap<String, MultiLanguageDTO>();
                        lang.put("name", langNew);
                        solvePlan.setLang(lang);
                        RelationTable relationTable = RelationTable.builder().targetId((Object)taskProblematicDataId).type("TroubleShoot").targetLabel("TaskProblematicData").build();
                        solvePlan.setRelationTable(Arrays.asList(relationTable));
                        solvePlan.setActionLabels(Arrays.asList("SolvePlan"));
                        FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/neo4j/%s/%s.json", applicationCode, "SolvePlan", resolvePlan.getPlanId()), (Object)solvePlan);
                    }
                }
            }
            task.remove((Object)"subApproveConditionDropDown");
            task.remove((Object)"businessExecutor");
            if (type.equals("business")) {
                task.remove((Object)"resolvePlans");
            }
            Object composeData = this.extendFieldDataService.combineWithExtendFieldData(code, null, SceneCodeEnum.DATAMAPTASK.getValue(), (Object)task, applicationCode);
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "/%s/mongo/%s/%s/%s.json", applicationCode, "datamap", "task", code), (Object)composeData);
        }
    }

    public void compileAndCompare(String applicationCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)this.getApplicationByAppCode(applicationCode)));
        List runtimeEntityList = this.dataMapMongoTemplate.find(query, JSONObject.class);
        List designEntityList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "task"), JSONObject.class);
        this.saveDiff(runtimeEntityList, designEntityList, applicationCode, "task", "code");
        for (JSONObject designEntity : designEntityList) {
            String code = designEntity.getString("code");
            designEntity.remove((Object)"objectId");
            designEntity.remove((Object)"isMigrate");
            JSONObject runtimeEntity = runtimeEntityList.stream().filter(item -> code.equals(item.getString("code"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
                continue;
            }
            runtimeEntity.remove((Object)"_id");
            runtimeEntity.remove((Object)"athena_namespace");
            this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)designEntity), "task", applicationCode, "transferCompare");
        }
        this.batchFileDataIntegrationUtils.batchFileDataIntegration(String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap", "task"), String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "datamap_publish", "task"), SceneCodeEnum.DATAMAPTASK.getValue(), applicationCode);
    }
}

