/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.enums.SceneCodeEnum;
import com.digiwin.athena.athenadeployer.service.ExtendFieldDataService;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.BatchFileDataIntegrationUtils;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component(value="variableDefinitionCompile")
public class VariableDefinitionCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VariableDefinitionCompile.class);
    @Autowired
    BatchFileDataIntegrationUtils batchFileDataIntegrationUtils;
    @Autowired
    private ExtendFieldDataService extendFieldDataService;
    @Autowired(required=false)
    @Qualifier(value="kgsysMongoTemplate")
    private MongoTemplate kgsysMongoTemplate;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
        this.batchFileDataIntegrationUtils.batchFileDataIntegration(String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/", "mongo", "test", "variableDefinition"), String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/", "mongo", "knowledgegraphSystem", "variableDefinition"), SceneCodeEnum.VARIABLEDEFINITION.getValue(), "");
    }

    public void doCompile(String applicationCode) {
        this.batchFileDataIntegrationUtils.batchFileDataIntegration(String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "variableDefinition"), String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "variableDefinition"), SceneCodeEnum.VARIABLEDEFINITION.getValue(), applicationCode);
    }

    public void compileAndCompare(String applicationCode) {
        Object paramDescription;
        ArrayList variableDecriptionList = new ArrayList();
        Criteria cr1 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"code").is((Object)this.getApplicationByAppCode(applicationCode)), Criteria.where((String)"application").is((Object)applicationCode)});
        Query query = Query.query((CriteriaDefinition)cr1);
        JSONObject appJson = (JSONObject)this.kgsysMongoTemplate.findOne(query, JSONObject.class, "application");
        if (!ObjectUtils.isEmpty((Object)appJson) && !ObjectUtils.isEmpty((Object)(paramDescription = JSONPath.eval((Object)appJson, (String)"paramDescription")))) {
            List paramDescriptionList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)paramDescription), JSONObject.class);
            if (!CollectionUtils.isEmpty((Collection)paramDescriptionList)) {
                paramDescriptionList.forEach(pd -> {
                    pd.put("code", (Object)pd.getString("key"));
                    pd.remove((Object)"key");
                });
            }
            variableDecriptionList.addAll(paramDescriptionList);
        }
        query = Query.query((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)applicationCode).and("type").is((Object)"variable"));
        query.fields().include("code");
        List vdCodeList = this.kgsysMongoTemplate.find(query, String.class, "applicationRelation");
        if (!CollectionUtils.isEmpty((Collection)vdCodeList)) {
            vdCodeList.forEach(vdCode -> {
                Query query2 = Query.query((CriteriaDefinition)Criteria.where((String)"code").is(vdCode));
                JSONObject vd = (JSONObject)this.kgsysMongoTemplate.findOne(query2, JSONObject.class, "variableDefinition");
                if (!ObjectUtils.isEmpty((Object)vd)) {
                    variableDecriptionList.add(vd);
                }
            });
        }
        List vdDesignerList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + "%s/%s/%s/%s/", applicationCode, "mongo", "knowledgegraphSystem", "variableDefinition"), JSONObject.class);
        this.saveDiff(variableDecriptionList, vdDesignerList, applicationCode, "variableDefinition", "code");
        for (JSONObject vdDesigner : vdDesignerList) {
            vdDesigner.remove((Object)"objectId");
            vdDesigner.remove((Object)"isMigrate");
            String code = vdDesigner.getString("code");
            JSONObject runtimeEntity = variableDecriptionList.stream().filter(item -> code.equals(item.getString("code"))).findFirst().orElse(null);
            Object composeData = this.extendFieldDataService.combineWithExtendFieldData(code, null, SceneCodeEnum.VARIABLEDEFINITION.getValue(), (Object)vdDesigner, applicationCode);
            if (runtimeEntity != null) {
                runtimeEntity.remove((Object)"_id");
                runtimeEntity.remove((Object)"colspan");
                runtimeEntity.remove((Object)"athena_namespace");
                this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)composeData), "variableDefinition", applicationCode, "transferCompare");
            } else {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)code);
            }
            FileUtils.writeObjectToJson((String)String.format(Constant.ATHENA_DATA_PATH + "%s/%s/%s/%s/%s.json", applicationCode, "mongo", "knowledgegraphSystem_publish", "variableDefinition", vdDesigner.getString("code")), (Object)composeData);
        }
    }
}

