/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl.action;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.compile.impl.action.strategy.ActionCompileStrategy;
import com.digiwin.athena.athenadeployer.compile.impl.action.strategy.ActionStrategyContext;
import com.digiwin.athena.athenadeployer.compile.impl.action.strategy.CommonActionCompile;
import com.digiwin.athena.athenadeployer.compile.impl.action.strategy.GetMechanismVariableActionCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.domain.action.Action;
import com.digiwin.athena.athenadeployer.domain.action.ActionFieldRelation;
import com.digiwin.athena.athenadeployer.domain.base.RelationTable;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="actionCompile")
public class ActionCompile
implements DesignerDataCompile {
    @Autowired
    private GetMechanismVariableActionCompile getMechanismVariableActionCompile;
    @Autowired
    private CommonActionCompile commonActionCompile;

    public void doCompile() {
    }

    public void doCompile(String applicationCode) {
        List actions = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + applicationCode + "/%s/%s/%s/", "mongo", "athenadesigner", "actionMetadata"), Action.class);
        actions.parallelStream().forEach(action -> {
            String name = action.getName() != null ? action.getName() : action.getActionName();
            action.setSubject(name);
            action.setRelationTable(new ArrayList());
            ActionStrategyContext actionStrategyContext = new ActionStrategyContext(action, applicationCode);
            if (StringUtils.equals((CharSequence)"GetMechanismVariableAction", (CharSequence)action.getLabel())) {
                actionStrategyContext.compile((ActionCompileStrategy)new GetMechanismVariableActionCompile());
            } else {
                actionStrategyContext.compile((ActionCompileStrategy)new CommonActionCompile());
            }
        });
    }

    public static Map<String, List<RelationTable>> getActionRelations(String applicationCode) {
        HashMap<String, List<RelationTable>> actionRelations = new HashMap<String, List<RelationTable>>();
        List actionFieldRelations = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + applicationCode + "/%s/%s/%s/", "mongo", "athenadesigner", "actionFieldRelation"), ActionFieldRelation.class);
        actionFieldRelations.forEach(actionFieldRelation -> {
            String id = actionFieldRelation.getStartActionId() + "__" + actionFieldRelation.getStartFieldFullPath();
            RelationTable relationTable = RelationTable.builder().targetLabel("DataField").targetId((Object)(actionFieldRelation.getEndActionId() + "__" + actionFieldRelation.getEndFieldFullPath())).type(actionFieldRelation.getRelationType()).build();
            if (actionRelations.get(id) != null) {
                ((List)actionRelations.get(id)).add(relationTable);
            } else {
                actionRelations.put(id, CollUtil.toList((Object[])new RelationTable[]{relationTable}));
            }
        });
        return actionRelations;
    }

    public void compileAndCompare(String applicationCode) {
        List actions = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + applicationCode + "/%s/%s/%s/", "mongo", "athenadesigner", "actionMetadata"), Action.class);
        if (!CollectionUtils.isEmpty((Collection)actions)) {
            actions.forEach(action -> {
                String name = action.getName() != null ? action.getName() : action.getActionName();
                action.setSubject(name);
                action.setRelationTable(new ArrayList());
                if (StringUtils.equals((CharSequence)"GetMechanismVariableAction", (CharSequence)action.getLabel())) {
                    this.getMechanismVariableActionCompile.compare(action, applicationCode);
                } else {
                    this.commonActionCompile.compare(action, applicationCode);
                }
            });
        }
    }
}

