/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.compile.impl.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.compile.AbstractDataCompile;
import com.digiwin.athena.athenadeployer.compile.Applications;
import com.digiwin.athena.athenadeployer.compile.DesignerDataCompile;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.service.JsonDiffService;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="transformActionRuleCompile")
public class TransformActionRuleCompile
extends AbstractDataCompile
implements DesignerDataCompile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransformActionRuleCompile.class);
    @Autowired(required=false)
    @Qualifier(value="kgsysMongoTemplate")
    private MongoTemplate kgMongoTemplate;
    @Autowired
    private JsonDiffService jsonDiffService;

    public void doCompile() {
        Set applicationCodes = Applications.getInstance().getApplicationSet();
        applicationCodes.forEach(applicationCode -> FileUtils.copyFolder((String)String.format(Constant.DESIGNER_DATA_PATH + "/%s/%s/%s/", applicationCode, "test", "transformActionRule"), (String)String.format(Constant.ATHENA_DATA_PATH + "/%s/%s/%s/", applicationCode, "knowledgegraphSystem", "transformActionRule")));
    }

    public void doCompile(String applicationCode) {
        FileUtils.copyFolder((String)String.format(Constant.DESIGNER_DATA_PATH + applicationCode + "/%s/%s/%s/", "mongo", "knowledgegraphSystem", "transformActionRule"), (String)String.format(Constant.ATHENA_DATA_PATH + applicationCode + "/%s/%s/%s/", "mongo", "knowledgegraphSystem", "transformActionRule"));
    }

    public void compileAndCompare(String applicationCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)this.getApplicationByAppCode(applicationCode)));
        List runtimeEntityList = this.kgMongoTemplate.find(query, JSONObject.class, "transformActionRule");
        List designEntityList = FileUtils.readAllObjectFromFilePath((String)String.format(Constant.DESIGNER_DATA_PATH + applicationCode + "/%s/%s/%s/", "mongo", "knowledgegraphSystem", "transformActionRule"), JSONObject.class);
        for (JSONObject designEntity : designEntityList) {
            String ruleId = designEntity.getString("ruleId");
            designEntity.remove((Object)"objectId");
            designEntity.remove((Object)"isMigrate");
            JSONObject runtimeEntity = runtimeEntityList.stream().filter(item -> ruleId.equals(item.getString("ruleId"))).findFirst().orElse(null);
            if (runtimeEntity == null) {
                log.info("\u5728\u8fd0\u884c\u6001\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53:{}", (Object)ruleId);
                continue;
            }
            runtimeEntity.remove((Object)"_id");
            runtimeEntity.remove((Object)"athena_namespace");
            this.jsonDiffService.compare(JSON.toJSONString((Object)runtimeEntity), JSON.toJSONString((Object)designEntity), "transformActionRule", applicationCode, "transferCompare");
        }
        FileUtils.copyFolder((String)String.format(Constant.DESIGNER_DATA_PATH + applicationCode + "/%s/%s/%s/", "mongo", "knowledgegraphSystem", "transformActionRule"), (String)String.format(Constant.ATHENA_DATA_PATH + applicationCode + "/%s/%s/%s/", "mongo", "knowledgegraphSystem_publish", "transformActionRule"));
    }
}

