/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config;

import com.digiwin.athena.athenadeployer.config.AsyncPoolConfig;
import com.digiwin.athena.athenadeployer.config.BlockingRejectedExecutionHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
public class AsyncPoolConfig
implements AsyncConfigurer {
    @Bean(value={"asyncExecutor"})
    public Executor getAsyncExecutor() {
        return new ThreadPoolExecutor(5, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), (ThreadFactory)new CustomDefaultThreadFactory("Async-Executor"), new ThreadPoolExecutor.DiscardPolicy());
    }

    @Bean
    public ThreadPoolExecutor publishAppPool() {
        return new ThreadPoolExecutor(10, 20, 5000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new CustomDefaultThreadFactory("Publish-App-Pool"), (RejectedExecutionHandler)new BlockingRejectedExecutionHandler());
    }

    @Bean
    public ThreadPoolExecutor switchAppPool() {
        return new ThreadPoolExecutor(10, 20, 5000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new CustomDefaultThreadFactory("Switch-App-Pool"), (RejectedExecutionHandler)new BlockingRejectedExecutionHandler());
    }
}

