/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config;

import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Path;
import jakarta.validation.ValidationException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Component
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    ResultBean handleControllerException(Throwable ex) {
        log.error("RestControllerExceptionHandler " + ex.getMessage(), ex);
        return ResultBean.fail((Integer)-1, (String)ex.getMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    ResultBean handleNullPointerException(NullPointerException ex) {
        log.error("NullPointerException ", (Throwable)ex);
        return ResultBean.fail((Integer)-1, (String)"NullPointerException");
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResultBean handle(ValidationException exception) {
        String message = "";
        String msgFormat = "parameter {%s}%s";
        if (exception instanceof ConstraintViolationException) {
            ConstraintViolationException exs = (ConstraintViolationException)exception;
            Set violations = exs.getConstraintViolations();
            for (ConstraintViolation item : violations) {
                Path pathImpl = item.getPropertyPath();
                String paramName = pathImpl.toString();
                message = String.format(msgFormat, paramName, item.getMessage());
                log.error("{} {} {}", new Object[]{item.getRootBeanClass().getName(), pathImpl, message});
            }
        } else {
            log.error(exception.getMessage());
            message = exception.getMessage();
        }
        return ResultBean.fail((Integer)-1, (String)message);
    }

    @ExceptionHandler(value={IncorrectResultSizeDataAccessException.class})
    public ResultBean handleUniqueExp(IncorrectResultSizeDataAccessException exception) {
        return ResultBean.fail((Integer)-1, (String)exception.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultBean<String> handle(MethodArgumentNotValidException e) {
        List fieldErrors = e.getBindingResult().getFieldErrors();
        String message = fieldErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(","));
        return ResultBean.fail((Integer)-1, (String)message);
    }

    @ExceptionHandler(value={BindException.class})
    public ResultBean<String> handle(BindException e) {
        List fieldErrors = e.getBindingResult().getFieldErrors();
        String message = fieldErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(","));
        return ResultBean.fail((Integer)-1, (String)message);
    }
}

