/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class StaticResourceFilter
implements Filter {
    private static final String BASIC_PATH = "/athenadeployer/static";

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        String path = httpRequest.getRequestURI();
        if (path.startsWith(BASIC_PATH)) {
            String file = path.replace(BASIC_PATH, "");
            httpRequest.getRequestDispatcher(file).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        super.destroy();
    }
}

