/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config;

import com.digiwin.athena.athenadeployer.config.ModuleConfig;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.filter.OncePerRequestFilter;

@Service
public class TenantTokenFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantTokenFilter.class);
    @Value(value="${appToken}")
    private String appToken;
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private RestTemplateBuilder restTemplateBuilder;
    private final String TOKEN_VERIFY_URL = "/api/iam/v2/identity/token/analyze";
    private final String IAM_USER_TOKEN = "digi-middleware-auth-user";
    private final String IAM_APP_TOKEN = "digi-middleware-auth-app";
    private static final Set<String> excludeUrls = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String requestURI = request.getRequestURI();
        String method = request.getMethod();
        try {
            if (!(excludeUrls.contains(requestURI) || requestURI.contains("healthcheck") || requestURI.contains("prometheus") || HttpMethod.OPTIONS.matches(method) || null != AthenaUserLocal.getUser())) {
                String token = request.getHeader("token");
                if (StringUtils.isEmpty((CharSequence)token)) {
                    throw new BusinessException("Missing token in message header");
                }
                String locale = request.getHeader("locale");
                if (StringUtils.isEmpty((CharSequence)locale)) {
                    locale = "zh_CN";
                }
                try {
                    HttpHeaders headers = new HttpHeaders();
                    headers.setContentType(MediaType.APPLICATION_JSON);
                    headers.add("digi-middleware-auth-user", token);
                    headers.add("digi-middleware-auth-app", this.appToken);
                    HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
                    ResponseEntity result = this.restTemplateBuilder.build().postForEntity(this.moduleConfig.getIam().getDomain() + "/api/iam/v2/identity/token/analyze", (Object)httpEntity, AthenaUser.class, new Object[0]);
                    AthenaUser athenaUser = (AthenaUser)result.getBody();
                    athenaUser.setToken(token);
                    athenaUser.setLocale(locale);
                    AthenaUserLocal.setUser((AthenaUser)((AthenaUser)result.getBody()));
                }
                catch (Exception e) {
                    throw new BusinessException("Failed to parse token", (Throwable)e);
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            AthenaUserLocal.removeUser();
        }
    }

    static {
        excludeUrls.add("/athenadeployer/tenant/getIamIntegrationToken");
        excludeUrls.add("/athenadeployer/deploy/v3/privateQueryDeployLog");
        excludeUrls.add("/athenadeployer/deploy/v3/privateDeployDetailByApplication");
        excludeUrls.add("/athenadeployer/deploy/v3/privateEnv");
    }
}

