/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config.http;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpInterceptor;
import cn.hutool.http.HttpRequest;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.StringUtils;

public class HutoolRouterKeyInterceptor
implements HttpInterceptor<HttpRequest> {
    private String appToken;

    public HutoolRouterKeyInterceptor(String appToken) {
        this.appToken = appToken;
    }

    public void process(HttpRequest request) {
        if (StrUtil.isBlank((CharSequence)request.header("locale"))) {
            request.header("locale", LocaleContextHolder.getLocale().toString());
        }
        if (StrUtil.isBlank((CharSequence)request.header("digi-middleware-auth-app"))) {
            request.header("digi-middleware-auth-app", this.appToken);
        }
        if (StringUtils.isEmpty((Object)request.header("routerKey")) && null != AthenaUserLocal.getUser()) {
            String tenantId = AthenaUserLocal.getUser().getTenantId();
            if (!StringUtils.isEmpty((Object)tenantId)) {
                request.header("routerKey", tenantId);
            } else {
                request.header("routerKey", "noRouterKey");
            }
        }
    }
}

