/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config.http;

import com.digiwin.athena.athenadeployer.config.http.RestTemplateAddHeadersInterceptor;
import com.digiwin.athena.athenadeployer.config.http.RestTemplateLogInterceptor;
import java.nio.charset.Charset;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfig {
    @Bean(name={"dmcRestTemplate"})
    public RestTemplate dmcRestTemplate(RestTemplateBuilder builder, RestTemplateAddHeadersInterceptor restTemplateAddHeadersInterceptor) {
        RestTemplate restTemplate = builder.build();
        restTemplate.getInterceptors().add(restTemplateAddHeadersInterceptor);
        return restTemplate;
    }

    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder, RestTemplateAddHeadersInterceptor restTemplateAddHeadersInterceptor) {
        RestTemplate restTemplate = restTemplateBuilder.build();
        restTemplate.getInterceptors().add(restTemplateAddHeadersInterceptor);
        restTemplate.getInterceptors().add(new RestTemplateLogInterceptor());
        return restTemplate;
    }

    @Bean(name={"httpRestTemplate"})
    public RestTemplate httpRestTemplate(RestTemplateAddHeadersInterceptor restTemplateAddHeadersInterceptor) {
        OkHttp3ClientHttpRequestFactory okHttp3ClientHttpRequestFactory = new OkHttp3ClientHttpRequestFactory();
        okHttp3ClientHttpRequestFactory.setConnectTimeout(180000);
        okHttp3ClientHttpRequestFactory.setReadTimeout(180000);
        okHttp3ClientHttpRequestFactory.setWriteTimeout(180000);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)okHttp3ClientHttpRequestFactory);
        restTemplate.getMessageConverters().stream().forEach(httpMessageConverter -> {
            if (httpMessageConverter instanceof StringHttpMessageConverter) {
                ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(Charset.forName("UTF-8"));
            }
        });
        restTemplate.getInterceptors().add(new RestTemplateLogInterceptor());
        restTemplate.getInterceptors().add(restTemplateAddHeadersInterceptor);
        return restTemplate;
    }
}

