/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config.mongo;

import com.digiwin.athena.athenadeployer.config.mongo.MultipleMongoProperties;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;

@Configuration
public class MultipleMongoConfig {
    @Autowired
    private MultipleMongoProperties mongoProperties;

    @Bean(value={"itdaMongoTemplate"})
    public MongoTemplate ITDAMongoTemplate() {
        return new MongoTemplate(this.ITDAMongoDbFactory());
    }

    public MongoDatabaseFactory ITDAMongoDbFactory() {
        return new SimpleMongoClientDatabaseFactory(this.ITDAMmongoClient(), this.getITDAMDatabaseName());
    }

    public MongoClient ITDAMmongoClient() {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.mongoProperties.getItda().getUri())).applyToConnectionPoolSettings(builder -> builder.maxSize(30).minSize(10).maxConnectionIdleTime(10L, TimeUnit.MINUTES).maxConnectionLifeTime(10L, TimeUnit.MINUTES).maxWaitTime(15L, TimeUnit.MINUTES)).build();
        return MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    protected String getITDAMDatabaseName() {
        return this.mongoProperties.getItda().getDatabase();
    }

    @Bean(value={"deployerMongoTemplate"})
    public MongoTemplate deployerMongoTemplate() {
        return new MongoTemplate(this.deployerMongoDbFactory());
    }

    public MongoDatabaseFactory deployerMongoDbFactory() {
        return new SimpleMongoClientDatabaseFactory(this.deployerMmongoClient(), this.getdeployerMDatabaseName());
    }

    public MongoClient deployerMmongoClient() {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.mongoProperties.getDeployer().getUri())).applyToConnectionPoolSettings(builder -> builder.maxSize(30).minSize(10).maxConnectionIdleTime(10L, TimeUnit.MINUTES).maxConnectionLifeTime(10L, TimeUnit.MINUTES).maxWaitTime(15L, TimeUnit.MINUTES)).build();
        return MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    protected String getdeployerMDatabaseName() {
        return this.mongoProperties.getDeployer().getDatabase();
    }
}

