/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config.mongo.runtime;

import com.digiwin.athena.athenadeployer.config.mongo.ExtendSimpleMongoRepository;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"com.digiwin.athena.mongodb.preset.repository"}, repositoryBaseClass=ExtendSimpleMongoRepository.class)
@ConfigurationProperties(prefix="spring.data.runtime.mongo-preset")
@ConditionalOnProperty(prefix="spring.data.runtime.mongo-preset", name={"uri"})
public class PresetMongodbConfig
extends MongoConfigurationSupport {
    public static final String BASE_PACKAGE = "com.digiwin.athena.mongodb.preset.repository";
    public static final String MONGO_TEMPLATE_REF = "mongoPresetTemplate";
    private String uri;
    private String database;

    @Bean(value={"presetMongoClient"})
    public MongoClient mongoClient() {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.uri)).applyToConnectionPoolSettings(builder -> builder.maxSize(30).minSize(10).maxConnectionIdleTime(10L, TimeUnit.MINUTES).maxConnectionLifeTime(10L, TimeUnit.MINUTES).maxWaitTime(15L, TimeUnit.MINUTES)).build();
        return MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    @Bean(value={"presetMongoMappingContext"})
    public MongoMappingContext mongoMappingContext() {
        MongoMappingContext mappingContext = new MongoMappingContext();
        return mappingContext;
    }

    @Bean(value={"presetMongoDbFactory"})
    public MongoDatabaseFactory mongoDbFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.getDatabaseName());
    }

    @Bean(value={"presetMongoTemplate"})
    public MongoTemplate mongoTemplate(@Qualifier(value="presetMongoDbFactory") MongoDatabaseFactory mongoDbFactory, @Qualifier(value="presetMongoMappingContext") MongoMappingContext mongoMappingContext) {
        return new MongoTemplate(this.mongoDbFactory(), (MongoConverter)this.mappingMongoConverter(mongoDbFactory, mongoMappingContext));
    }

    @Bean(value={"presetMappingMongoConverter"})
    public MappingMongoConverter mappingMongoConverter(@Qualifier(value="presetMongoDbFactory") MongoDatabaseFactory mongoDbFactory, @Qualifier(value="presetMongoMappingContext") MongoMappingContext mongoMappingContext) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(this.mongoDbFactory());
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)this.mongoMappingContext());
        converter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        converter.setCustomConversions((CustomConversions)this.customConversions());
        return converter;
    }

    protected String getDatabaseName() {
        return this.database;
    }

    @Generated
    public PresetMongodbConfig() {
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public void setDatabase(String database) {
        this.database = database;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresetMongodbConfig)) {
            return false;
        }
        PresetMongodbConfig other = (PresetMongodbConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        return !(this$database == null ? other$database != null : !this$database.equals(other$database));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PresetMongodbConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PresetMongodbConfig(uri=" + this.getUri() + ", database=" + this.getDatabase() + ")";
    }
}

