/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config.neo4j;

import java.net.URI;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.neo4j.Neo4jProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableNeo4jRepositories(basePackages={"com.digiwin.athena.athenadeployer.migrate.neo4j"}, transactionManagerRef="migrateTransactionManager")
@ConditionalOnProperty(prefix="spring.data.migrate.neo4j", name={"url"})
public class MigrateNeo4jConfig {
    public static final String SESSION_FACTORY = "migrateSessionFactory";
    public static final String TRANSACTION_MANAGER = "migrateTransactionManager";
    public static final String Neo4j_SESSION = "migrateSession";
    public static final String NEO4J_DRIVER_SESSION = "migrateDriverSession";
    static final String BASE_PACKAGE = "com.digiwin.athena.athenadeployer.migrate.neo4j";

    @Bean(name={"migrateNeo4jProperties"})
    @ConfigurationProperties(value="spring.data.migrate.neo4j")
    public Neo4jProperties neo4jProperties() {
        return new Neo4jProperties();
    }

    @Bean(name={"migrateNeo4jDriver"})
    public Driver neo4jDriver() {
        return GraphDatabase.driver((URI)this.neo4jProperties().getUri(), (AuthToken)AuthTokens.basic((String)this.neo4jProperties().getAuthentication().getUsername(), (String)this.neo4jProperties().getAuthentication().getPassword()));
    }

    @Bean(name={"migrateNeo4jClient"})
    public Neo4jClient neo4jClient(Driver driver) {
        return Neo4jClient.create((Driver)driver);
    }

    @Bean(name={"migrateNeo4jTemplate"})
    public Neo4jTemplate neo4jTemplate(@Qualifier(value="migrateNeo4jClient") Neo4jClient client) {
        return new Neo4jTemplate(client);
    }

    @Bean(name={"migrateDriverSession"})
    public Session neo4jSession(Driver driver) {
        return driver.session();
    }

    @Bean(name={"migrateTransactionManager"})
    public Neo4jTransactionManager neo4jTransactionManager(Driver driver) {
        return new Neo4jTransactionManager(driver);
    }
}

