/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config.neo4j;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.neo4j.Neo4jProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableNeo4jRepositories(basePackages={"com.digiwin.athena.athenadeployer.neo4j"}, transactionManagerRef="transactionManager")
public class Neo4jConfig {
    public static final String SESSION_FACTORY = "sessionFactory";
    public static final String TRANSACTION_MANAGER = "transactionManager";
    public static final String Neo4j_SESSION = "session";
    public static final String NEO4J_DRIVER_SESSION = "driverSession";
    public static final String NEO4J_DRIVER = "driver";
    public static final String NEO4J_CLIENT = "neo4jClient";
    public static final String NEO4J_TEMPLATE = "neo4jTemplate";
    static final String BASE_PACKAGE = "com.digiwin.athena.athenadeployer.neo4j";

    @Primary
    @Bean(name={"neo4jProperties"})
    @ConfigurationProperties(value="spring.neo4j")
    public Neo4jProperties neo4jProperties() {
        return new Neo4jProperties();
    }

    @Primary
    @Bean(name={"driver"})
    public Driver driver() {
        Config config = Config.builder().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(50).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).build();
        return GraphDatabase.driver((URI)this.neo4jProperties().getUri(), (AuthToken)AuthTokens.basic((String)this.neo4jProperties().getAuthentication().getUsername(), (String)this.neo4jProperties().getAuthentication().getPassword()), (Config)config);
    }

    @Primary
    @Bean(name={"neo4jClient"})
    public Neo4jClient neo4jClient(@Qualifier(value="driver") Driver driver) {
        return Neo4jClient.create((Driver)driver);
    }

    @Primary
    @Bean(name={"neo4jTemplate"})
    public Neo4jTemplate neo4jTemplate(@Qualifier(value="neo4jClient") Neo4jClient neo4jClient, @Qualifier(value="transactionManager") Neo4jTransactionManager transactionManager) {
        Neo4jTemplate template = new Neo4jTemplate(neo4jClient);
        template.setTransactionManager((PlatformTransactionManager)transactionManager);
        return template;
    }

    @Primary
    @Bean(name={"driverSession"})
    public Session neo4jSession(@Qualifier(value="driver") Driver driver) {
        return driver.session();
    }

    @Primary
    @Bean(name={"transactionManager"})
    public Neo4jTransactionManager neo4jTransactionManager(@Qualifier(value="driver") Driver driver) {
        return new Neo4jTransactionManager(driver);
    }
}

