/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config.neo4j;

import com.digiwin.athena.athenadeployer.domain.Cql;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.util.Pair;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Neo4jManager
implements InitializingBean {
    @Generated
    private static final Logger log = LogManager.getLogger(Neo4jManager.class);
    private static Neo4jManager neo4jManager = null;
    @Autowired
    private Driver driver;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver domain2Driver;

    public void afterPropertiesSet() {
        neo4jManager = this;
    }

    public static Neo4jManager getNeo4jManager() {
        return neo4jManager;
    }

    public void ExecuteNoQuery(String statement) {
        block12: {
            try (Session session = this.driver.session();){
                session.run(statement);
                if (this.domain2Driver == null) break block12;
                try (Session domain2Session = this.domain2Driver.session();){
                    domain2Session.run(statement);
                }
            }
        }
    }

    public void ExecuteNoQuery(String statement, Map<String, Object> params) {
        block12: {
            try (Session session = this.driver.session();){
                session.run(statement, params);
                if (this.domain2Driver == null) break block12;
                try (Session domain2Session = this.domain2Driver.session();){
                    domain2Session.run(statement, params);
                }
            }
        }
    }

    public void ExecuteTransactionNoQuery(List<Cql> statementsAndParams) {
        try (Session session = this.driver.session();
             Transaction tx = session.beginTransaction();){
            for (Cql cql : statementsAndParams) {
                if (Objects.isNull(cql.getParams())) {
                    tx.run(cql.getCql());
                    continue;
                }
                tx.run(cql.getCql(), cql.getParams());
            }
            if (this.domain2Driver != null) {
                try (Session domain2Session = this.domain2Driver.session();
                     Transaction tx2 = domain2Session.beginTransaction();){
                    for (Cql cql : statementsAndParams) {
                        if (Objects.isNull(cql.getParams())) {
                            tx2.run(cql.getCql());
                            continue;
                        }
                        tx2.run(cql.getCql(), cql.getParams());
                    }
                    tx2.commit();
                }
            }
            tx.commit();
        }
    }

    public List<Map<String, Object>> ExecuteQuery(String statement) {
        ArrayList<Map<String, Object>> arrayList;
        block10: {
            Session session = this.driver.session();
            try {
                Result result = session.run(statement);
                ArrayList<Map<String, Object>> mapObjects = new ArrayList<Map<String, Object>>();
                while (result.hasNext()) {
                    Record record = result.next();
                    List fields = record.fields();
                    HashMap<String, Object> recordAsMap = new HashMap<String, Object>();
                    for (Pair field : fields) {
                        recordAsMap.put((String)field.key(), Neo4jManager.ParseNode((Object)field.value()));
                    }
                    mapObjects.add(recordAsMap);
                }
                arrayList = mapObjects;
                if (session == null) break block10;
            }
            catch (Throwable throwable) {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            session.close();
        }
        return arrayList;
    }

    public List<Map<String, Object>> ExecuteQuery(String statement, Map<String, Object> params) {
        ArrayList<Map<String, Object>> arrayList;
        block10: {
            Session session = this.driver.session();
            try {
                Result result = session.run(statement, params);
                ArrayList<Map<String, Object>> mapObjects = new ArrayList<Map<String, Object>>();
                while (result.hasNext()) {
                    Record record = result.next();
                    List fields = record.fields();
                    HashMap<String, Object> recordAsMap = new HashMap<String, Object>();
                    for (Pair field : fields) {
                        recordAsMap.put((String)field.key(), Neo4jManager.ParseNode((Object)field.value()));
                    }
                    mapObjects.add(recordAsMap);
                }
                arrayList = mapObjects;
                if (session == null) break block10;
            }
            catch (Throwable throwable) {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            session.close();
        }
        return arrayList;
    }

    private static Object ParseNode(Object value) {
        if (value instanceof NodeValue) {
            return ((Value)value).asMap();
        }
        if (value instanceof StringValue) {
            return ((Value)value).asString();
        }
        if (value instanceof BooleanValue) {
            return ((Value)value).asBoolean();
        }
        if (value instanceof IntegerValue) {
            long val = ((IntegerValue)value).asLong();
            if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                return val;
            }
            return ((Value)value).asInt();
        }
        if (value instanceof FloatValue) {
            return Float.valueOf(((Value)value).asFloat());
        }
        if (value instanceof ListValue) {
            ArrayList<Object> parsedValue = new ArrayList<Object>();
            List valueAsList = ((Value)value).asList();
            for (Object element : valueAsList) {
                parsedValue.add(Neo4jManager.ParseNode(element));
            }
            return parsedValue;
        }
        return value;
    }
}

