/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.config.neo4j;

import java.net.URI;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.neo4j.Neo4jProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableNeo4jRepositories(basePackages={"com.digiwin.athena.athenadeployer.tenantdesigner.neo4j"}, transactionManagerRef="tenantDesignerTransactionManager")
@ConditionalOnProperty(prefix="spring.data.tenant-designer.neo4j", name={"url"})
public class TenantDesignerNeo4jConfig {
    public static final String SESSION_FACTORY = "tenantDesignerSessionFactory";
    public static final String TRANSACTION_MANAGER = "tenantDesignerTransactionManager";
    public static final String Neo4j_SESSION = "tenantDesignerSession";
    public static final String NEO4J_DRIVER_SESSION = "tenantDesignerDriverSession";
    static final String BASE_PACKAGE = "com.digiwin.athena.athenadeployer.tenantdesigner.neo4j";

    @Bean(name={"tenantDesignerNeo4jProperties"})
    @ConfigurationProperties(value="spring.data.tenant-designer.neo4j")
    public Neo4jProperties neo4jProperties() {
        return new Neo4jProperties();
    }

    @Bean(name={"tenantDesignerNeo4jDriver"})
    public Driver neo4jDriver() {
        return GraphDatabase.driver((URI)this.neo4jProperties().getUri(), (AuthToken)AuthTokens.basic((String)this.neo4jProperties().getAuthentication().getUsername(), (String)this.neo4jProperties().getAuthentication().getPassword()));
    }

    @Bean(name={"tenantDesignerNeo4jClient"})
    public Neo4jClient neo4jClient(Driver driver) {
        return Neo4jClient.create((Driver)driver);
    }

    @Bean(name={"tenantDesignerNeo4jTemplate"})
    public Neo4jTemplate neo4jTemplate(@Qualifier(value="tenantDesignerNeo4jClient") Neo4jClient client, @Qualifier(value="tenantDesignerTransactionManager") Neo4jTransactionManager transactionManager) {
        Neo4jTemplate template = new Neo4jTemplate(client);
        template.setTransactionManager((PlatformTransactionManager)transactionManager);
        return template;
    }

    @Bean(name={"tenantDesignerDriverSession"})
    public Session neo4jSession(Driver driver) {
        return driver.session();
    }

    @Bean(name={"tenantDesignerTransactionManager"})
    public Neo4jTransactionManager neo4jTransactionManager(Driver driver) {
        return new Neo4jTransactionManager(driver);
    }
}

