/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.consumer;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.service.DeployServiceV3;
import com.digiwin.athena.athenadeployer.service.DeployServiceV4;
import com.digiwin.athena.athenadeployer.service.impl.DeployServiceImplV3;
import com.digiwin.athena.athenadeployer.utils.CurThreadInfoUtils;
import com.digiwin.athena.athenadeployer.utils.RedisCache;
import jakarta.annotation.Resource;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class DeployConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployConsumer.class);
    @Resource
    private DeployServiceV3 deployServiceV3;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private RedissonClient redissonClient;
    @Resource
    private DeployServiceV4 deployServiceV4;
    private String mode;
    public static final String LOCK_KEY = "athena_deployer_deploy_lock__";
    @Resource
    private ThreadPoolExecutor publishAppPool;

    @Scheduled(cron="${jobCron.DeployConsumer}")
    public void run() {
        log.info("start DeployConsumer");
        Object task = this.redisCache.lpop(DeployServiceImplV3.DEPLOY_LIST_KEY);
        if (ObjectUtils.isEmpty((Object)task)) {
            return;
        }
        DeployParamV3 appDeployParam = (DeployParamV3)JSON.parseObject((String)JSON.toJSONString((Object)task), DeployParamV3.class);
        String appCode = ((ApplicationData)appDeployParam.getApplicationDataList().get(0)).getApplication();
        log.info("\u53d1\u7248\u5f53\u524d\u961f\u5217\u4e2d\u53d6\u5230\u7684\u5e94\u7528code:" + appCode + ", deployNo:" + appDeployParam.getId());
        try {
            this.publishAppPool.execute(() -> {
                block10: {
                    try {
                        RLock rLock = this.redissonClient.getLock(LOCK_KEY + appDeployParam.getEnv() + "__" + appCode);
                        boolean isLock = rLock.tryLock();
                        if (isLock) {
                            try {
                                log.info("\u53d1\u7248\uff1a\u5373\u5c06\u8fdb\u884c\u53d1\u7248\u7684\u5e94\u7528\u5165\u53c2\u662f\uff1a" + String.valueOf(appDeployParam));
                                AthenaUserLocal.setUser((AthenaUser)appDeployParam.getCurrentUser());
                                if (!"new".equals(appDeployParam.getPublishMode())) {
                                    this.deployServiceV3.asyncDeployV2(appDeployParam);
                                } else {
                                    this.deployServiceV4.asyncDeployV4(appDeployParam);
                                }
                                break block10;
                            }
                            catch (Exception e) {
                                log.error("DeployConsumer \u5931\u8d25:" + JSON.toJSONString((Object)appDeployParam), (Throwable)e);
                                break block10;
                            }
                            finally {
                                CurThreadInfoUtils.removeDeployTaskInfo();
                                rLock.unlock();
                            }
                        }
                        log.warn("\u5df2\u5b58\u5728\u6b63\u5728\u53d1\u7248\u7684\u5e94\u7528:" + appCode);
                    }
                    catch (Exception e) {
                        log.error(appCode + "\u5e94\u7528\u53d1\u5e03\u5931\u8d25:" + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u53d1\u7248\u62a5\u9519:" + e.getMessage(), (Throwable)e);
        }
    }
}

