/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.service.DeployServiceV3;
import com.digiwin.athena.athenadeployer.service.DeployServiceV4;
import com.digiwin.athena.athenadeployer.service.impl.DeployServiceImplV3;
import com.digiwin.athena.athenadeployer.utils.CurThreadInfoUtils;
import com.digiwin.athena.athenadeployer.utils.RedisCache;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class SwitchConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchConsumer.class);
    @Resource
    private DeployServiceV3 deployServiceV3;
    @Resource
    private RedisCache redisCache;
    @Resource
    private RedissonClient redissonClient;
    @Resource
    private DeployServiceV4 deployServiceV4;
    @Resource
    private ThreadPoolExecutor switchAppPool;
    @Value(value="${privateEnv}")
    private Boolean privateEnv;
    public static final String LOCK_KEY = "athena_deployer_switch_lock__";

    @Scheduled(cron="${jobCron.SwitchConsumer}")
    public void run() {
        log.info("start SwitchConsumer");
        Object lpop = this.redisCache.lpop(DeployServiceImplV3.SWITCH_LIST_KEY);
        if (ObjectUtils.isEmpty((Object)lpop)) {
            return;
        }
        String paramJsonString = JSON.toJSONString((Object)lpop);
        DeployParamV3 appSwitchParam = (DeployParamV3)JSON.parseObject((String)paramJsonString, DeployParamV3.class);
        String appCode = ((ApplicationData)appSwitchParam.getApplicationDataList().get(0)).getApplication();
        log.info("\u5207\u7248\u5f53\u524d\u961f\u5217\u4e2d\u53d6\u5230\u7684\u5e94\u7528code:" + appCode + ", deployNo:" + appSwitchParam.getId());
        try {
            this.switchAppPool.execute(() -> {
                block14: {
                    try {
                        RLock rLock = this.redissonClient.getLock(LOCK_KEY + appSwitchParam.getEnv() + "__" + appCode);
                        boolean isLock = rLock.tryLock();
                        if (isLock) {
                            try {
                                int appType;
                                log.info("\u8fdb\u884c\u5207\u7248\u7684\u5e94\u7528\u5165\u53c2\u662f\uff1a" + paramJsonString);
                                AthenaUserLocal.setUser((AthenaUser)appSwitchParam.getCurrentUser());
                                if (this.privateEnv.booleanValue()) {
                                    appType = ((ApplicationData)appSwitchParam.getApplicationDataList().get(0)).getApplicationInfoDto().getAppType();
                                } else {
                                    List compiledDataList = this.deployServiceV3.queryDeployData(appCode, AthenaUserLocal.getUser().getToken());
                                    appType = ((JSONObject)compiledDataList.get(0)).getIntValue("appType");
                                }
                                if (7 == appType) {
                                    this.deployServiceV3.switchAsaApplicationVersion(appSwitchParam);
                                } else if (!"new".equals(appSwitchParam.getPublishMode())) {
                                    this.deployServiceV3.switch2Prod(appSwitchParam);
                                } else {
                                    this.deployServiceV4.switch2ProdV4(appSwitchParam);
                                }
                                break block14;
                            }
                            catch (Exception e) {
                                log.error("\u5931\u8d25:" + JSON.toJSONString((Object)appSwitchParam), (Throwable)e);
                                break block14;
                            }
                            finally {
                                CurThreadInfoUtils.removeDeployTaskInfo();
                                rLock.unlock();
                            }
                        }
                        log.warn("\u5df2\u5b58\u5728\u6b63\u5728\u5207\u7248\u7684\u5e94\u7528:" + appCode);
                    }
                    catch (Exception e) {
                        log.error(appCode + "\u5207\u677f\u5931\u8d25:" + JSON.toJSONString((Object)appSwitchParam), (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u5207\u7248\u62a5\u9519" + e.getMessage(), (Throwable)e);
        }
    }
}

