/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.async.DeployFinishedTask;
import com.digiwin.athena.athenadeployer.async.DeployTask;
import com.digiwin.athena.athenadeployer.domain.Application;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.MyDesignerData;
import com.digiwin.athena.athenadeployer.domain.application.ApplicationCustomPublishDto;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.compile.CompileData;
import com.digiwin.athena.athenadeployer.domain.compile.CompileVersion;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployContent;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetail;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParam;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployProcess;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployVersion;
import com.digiwin.athena.athenadeployer.domain.deploy.FileNum;
import com.digiwin.athena.athenadeployer.domain.deploy.SwitchVersionParam;
import com.digiwin.athena.athenadeployer.dto.deployer.Pagination;
import com.digiwin.athena.athenadeployer.dto.tenant.TenantDTO;
import com.digiwin.athena.athenadeployer.enums.DeployerProgressEnum;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.http.deployService.DeployServiceApiHelper;
import com.digiwin.athena.athenadeployer.http.deployService.dto.EspActionIdSwitchResDto;
import com.digiwin.athena.athenadeployer.service.ApplicationService;
import com.digiwin.athena.athenadeployer.service.AthenaDataService;
import com.digiwin.athena.athenadeployer.service.CompileService;
import com.digiwin.athena.athenadeployer.service.DataVersionService;
import com.digiwin.athena.athenadeployer.service.DeployServiceV2;
import com.digiwin.athena.athenadeployer.service.DeployerProgressService;
import com.digiwin.athena.athenadeployer.service.DeployerService;
import com.digiwin.athena.athenadeployer.service.IAMService;
import com.digiwin.athena.athenadeployer.service.InitService;
import com.digiwin.athena.athenadeployer.service.PublishAfterService;
import com.digiwin.athena.athenadeployer.service.TenantService;
import com.digiwin.athena.athenadeployer.utils.FileUtils;
import com.digiwin.athena.athenadeployer.utils.RedisCache;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/application"})
@CrossOrigin
public class ApplicationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationController.class);
    @Autowired
    private DataVersionService dataVersionService;
    @Autowired
    private AthenaDataService athenaDataService;
    @Autowired
    private DeployerProgressService deployerProgressService;
    @Autowired
    private InitService initService;
    @Autowired
    private ApplicationService applicationService;
    @Value(value="${environment}")
    private String environment;
    @Autowired
    private DeployerService deployerService;
    @Autowired
    private CompileService compileService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private IAMService iamService;
    @Autowired
    private PublishAfterService publishAfterService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private BackendApiHelper backendApiHelper;
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    private DeployServiceV2 deployServiceV2;
    @Autowired
    private DeployServiceApiHelper deployServiceApiHelper;

    @PostMapping(value={"multiImport"})
    public ResultBean<?> multiImport(MultipartFile designerData, MultipartFile tagData, @Validated Application application) throws IOException, InterruptedException {
        MyDesignerData myDesignerData = (MyDesignerData)FileUtils.readObjectFromInputStream((InputStream)designerData.getInputStream(), MyDesignerData.class);
        MyDesignerData myTagData = null;
        if (null != tagData) {
            myTagData = (MyDesignerData)FileUtils.readObjectFromInputStream((InputStream)tagData.getInputStream(), MyDesignerData.class);
        }
        application.getVersion();
        this.deployerProgressService.addPublishEvent(application);
        if (!"DEV".equals(this.environment)) {
            this.athenaDataService.checkDemoDesignerData(myDesignerData, application);
        }
        this.deployerProgressService.updatePublishEvent(application, DeployerProgressEnum.CHECK_DESIGNER_DATA);
        if (null != tagData) {
            if (!"DEV".equals(this.environment)) {
                this.athenaDataService.checkTagData(myTagData, application);
            }
            this.deployerProgressService.updatePublishEvent(application, DeployerProgressEnum.CHECK_TAG_DATA);
        }
        this.athenaDataService.addApplicationVersion(application.getVersion());
        this.deployerProgressService.updatePublishEvent(application, DeployerProgressEnum.COPY_DATA);
        this.athenaDataService.runDemoDesignerData(myDesignerData, application);
        this.deployerProgressService.updatePublishEvent(application, DeployerProgressEnum.UPDATE_DESIGNER_DATA);
        if (null != tagData) {
            this.athenaDataService.runDemoTagData(myTagData, application);
            this.deployerProgressService.updatePublishEvent(application, DeployerProgressEnum.UPDATE_TAG_DATA);
        }
        if (!"DEV".equals(this.environment)) {
            this.dataVersionService.updateTenantVersion(application);
            this.deployerProgressService.updatePublishEvent(application, DeployerProgressEnum.UPDATECOMPLETE);
        } else {
            this.dataVersionService.switchProdDataVersion(application);
            this.deployerProgressService.updatePublishEvent(application, DeployerProgressEnum.UPDATECOMPLETE);
            this.deployerProgressService.updateProdVersion(application);
        }
        if ("DEV".equals(this.environment)) {
            this.initService.resetData();
        }
        return ResultBean.success();
    }

    @PostMapping(value={"switchProd"})
    public ResultBean<?> switchProd(@RequestBody @Validated Application application) {
        this.dataVersionService.switchProdDataVersion(application);
        this.deployerProgressService.updateProdVersion(application);
        JSONArray bpmErrorList = new JSONArray();
        return ResultBean.success((Object)bpmErrorList);
    }

    @PostMapping(value={"initData"})
    public ResultBean<?> initData() {
        int count = this.deployerProgressService.gePublishVersionCount();
        if (count < 1) {
            this.initService.initData();
            return ResultBean.success();
        }
        return ResultBean.fail((Integer)100, (String)"Duplicate initialization is not allowed");
    }

    @GetMapping(value={"/get"})
    public ResultBean<List> getApplications(@RequestParam(required=false) String condition) {
        return ResultBean.success((Object)this.applicationService.getApplications(condition));
    }

    @PostMapping(value={"/queryApplicationLatestVersion"})
    public ResultBean<List> queryApplicationLatestVersion(@RequestBody List<String> applicationCodeList) {
        return ResultBean.success((Object)this.applicationService.queryApplicationLatestVersion(applicationCodeList));
    }

    @GetMapping(value={"/queryVersion"})
    public ResultBean<?> queryVersion() {
        DeployVersion deployVersion = this.deployerService.queryLatestVersion();
        String version = deployVersion.getVersion();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("currentVersion", (Object)version);
        List versionList = this.deployerService.queryVersionList();
        jsonObject.put("versionList", (Object)versionList);
        return ResultBean.success((Object)jsonObject);
    }

    @PostMapping(value={"deployContentDiff"})
    public ResultBean<?> deployContent(@RequestBody DeployParamV2 deployParam) {
        List applicationDataList = deployParam.getApplicationDataList();
        ArrayList<CompileData> compileDataList = new ArrayList<CompileData>();
        try {
            for (ApplicationData applicationData : applicationDataList) {
                JSONObject jsonObject = this.designerApiHelper.queryCompiledDataByCode(applicationData.getCompileDataCode(), AthenaUserLocal.getUser().getToken());
                if (!MapUtil.isNotEmpty((Map)jsonObject)) continue;
                CompileData compileData = (CompileData)jsonObject.toJavaObject(CompileData.class);
                compileDataList.add(compileData);
            }
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        DeployContent deployContent = new DeployContent();
        ArrayList<DeployDetail> deployDetailList = new ArrayList<DeployDetail>();
        for (CompileData compileData : compileDataList) {
            List fileNumList = compileData.getFileNumList();
            for (FileNum fileNum : fileNumList) {
                String parentLabel = fileNum.getLabel();
                List children = fileNum.getChildren();
                for (FileNum child : children) {
                    String label = child.getLabel();
                    Integer num = child.getNum();
                    DeployDetail deployDetail = new DeployDetail();
                    deployDetail.setType(parentLabel + "." + label).setTotalNum(num).setApplication(compileData.getApplication());
                    deployDetailList.add(deployDetail);
                }
            }
        }
        deployContent.setDeployDetailList(deployDetailList);
        return ResultBean.success((Object)deployContent);
    }

    @PostMapping(value={"deploy2"})
    public ResultBean<?> deploy(@RequestBody DeployParam deployParam) {
        AthenaUser currentUser = AthenaUserLocal.getUser();
        ThreadUtil.execute(() -> {
            Integer majorVersionNum;
            List applicationList = deployParam.getApplicationList();
            List tenantIdList = deployParam.getTenantIdList();
            DeployVersion deployVersionObj = this.deployerService.queryLatestVersion();
            String currentVersion = deployVersionObj.getVersion();
            Integer n = majorVersionNum = deployVersionObj.getMajorVersionNum();
            majorVersionNum = majorVersionNum + 1;
            String deployVersion = majorVersionNum + "." + deployVersionObj.getMinorVersion();
            HashMap<String, CallSite> applicationCompileVersionMap = new HashMap<String, CallSite>();
            Iterator iterator = applicationList.iterator();
            while (iterator.hasNext()) {
                String appVersion;
                String application = (String)iterator.next();
                CompileVersion compileVersionObj = this.compileService.queryLatestVersion(application);
                DecimalFormat decimalFormat = new DecimalFormat("0000");
                String compileVersion = compileVersionObj.getMinorVersion() + "." + decimalFormat.format(compileVersionObj.getMajorVersion());
                JSONObject jsonObject = this.deployerService.queryGlobalVersion(currentVersion);
                JSONObject appCompileVersionMap = jsonObject.getJSONObject("applicationCompileVersionMap");
                if (MapUtil.isNotEmpty((Map)appCompileVersionMap) && StrUtil.isNotBlank((CharSequence)(appVersion = appCompileVersionMap.getString(application))) && appVersion.equals(compileVersion)) {
                    log.info("{}\u7248\u672c\u7684{}\u5df2\u90e8\u7f72\u8fc7\uff0c\u65e0\u9700\u91cd\u590d\u90e8\u7f72", (Object)compileVersion, (Object)application);
                    iterator.remove();
                    continue;
                }
                Boolean copyOtherApplication = deployParam.getCopyOtherApplication();
                this.deployerService.deploy(application, compileVersion, currentVersion, deployVersion, copyOtherApplication, currentUser);
                applicationCompileVersionMap.put(application, (CallSite)((Object)compileVersion));
            }
            this.deployerService.versionIncrease(deployVersionObj, applicationCompileVersionMap);
            for (String application : applicationList) {
                if (CollUtil.isEmpty((Collection)tenantIdList)) {
                    tenantIdList = this.tenantService.queryAllApplicationTenantId(application);
                }
                DeployLog deployLog = new DeployLog();
                deployLog.setApplication(application).setVersion(deployVersion).setTenantIdList(tenantIdList).setUser(AthenaUserLocal.getUser());
                this.deployerService.addDeployLog(deployLog);
            }
            if (!"DEV".equals(this.environment)) {
                this.deployerService.switchVersion(tenantIdList, deployVersion);
                this.publishAfterService.cacheReset();
            }
        });
        return ResultBean.success();
    }

    @PostMapping(value={"/deploy"})
    public ResultBean<?> deploy2(@RequestBody DeployParam deployParam) {
        Integer majorVersionNum;
        List applicationList = deployParam.getApplicationList();
        List tenantIdList = deployParam.getTenantIdList();
        Boolean copyOtherApplication = deployParam.getCopyOtherApplication();
        DeployVersion deployVersionObj = this.deployerService.queryLatestVersion();
        String currentVersion = deployVersionObj.getVersion();
        Integer n = majorVersionNum = deployVersionObj.getMajorVersionNum();
        majorVersionNum = majorVersionNum + 1;
        String deployVersion = majorVersionNum + "." + deployVersionObj.getMinorVersion();
        AthenaUser currentUser = AthenaUserLocal.getUser();
        DeployTask deployTask = new DeployTask(applicationList, currentVersion, deployVersion, copyOtherApplication, currentUser);
        deployTask.setBackendApiHelper(this.backendApiHelper).setDesignerApiHelper(this.designerApiHelper).setDeployerService(this.deployerService).setDeployerProgressService(this.deployerProgressService).setRedisCache(this.redisCache);
        Thread deployThread = new Thread((Runnable)deployTask);
        ThreadUtil.execute((Runnable)deployThread);
        try {
            deployThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("thread error", (Throwable)e);
        }
        DeployFinishedTask deployFinishedTask = new DeployFinishedTask(applicationList, tenantIdList, deployVersionObj, this.environment, deployTask.getApplicationCompileVersionMap());
        deployFinishedTask.setDeployerService(this.deployerService).setTenantService(this.tenantService).setPublishAfterService(this.publishAfterService);
        Thread deployFinishedThread = new Thread((Runnable)deployFinishedTask);
        ThreadUtil.execute((Runnable)deployFinishedThread);
        return ResultBean.success();
    }

    @PostMapping(value={"/deployTest"})
    public ResultBean<?> deployTest(@RequestBody DeployParamV2 deployParam) {
        this.deployServiceV2.deployTest(deployParam);
        return ResultBean.success();
    }

    @PostMapping(value={"/deployProd"})
    public ResultBean<?> deployProd(@RequestBody DeployParamV2 deployParam) {
        this.deployServiceV2.deployProd(deployParam);
        return ResultBean.success();
    }

    @PostMapping(value={"/tenant/deploy"})
    public ResultBean<?> tenantDeploy(@RequestBody DeployParam deployParam) {
        List applicationList = deployParam.getApplicationList();
        List tenantIdList = deployParam.getTenantIdList();
        for (String application : applicationList) {
            this.deployerService.tenantDeploy(application, tenantIdList);
            for (String tenantId : tenantIdList) {
                this.tenantService.addTenantApplication(tenantId, application);
            }
        }
        return ResultBean.success();
    }

    @PostMapping(value={"/deploy/process"})
    public ResultBean<?> deployProcess(@RequestBody DeployParam deployParam) {
        List applicationList = deployParam.getApplicationList();
        Integer total = 0;
        Integer deployedNum = 0;
        String type = null;
        for (String application : applicationList) {
            DeployProcess deployProcess = (DeployProcess)this.redisCache.get("DEPLOY_PROCESS", application, DeployProcess.class);
            if (deployProcess == null || null == deployProcess.getDeployedNum()) continue;
            total = total + deployProcess.getTotal();
            deployedNum = deployedNum + deployProcess.getDeployedNum();
            type = deployProcess.getType();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("totalNumber", (Object)total);
        jsonObject.put("deployedNumber", (Object)deployedNum);
        jsonObject.put("type", type);
        return ResultBean.success((Object)jsonObject);
    }

    @PostMapping(value={"/switchVersion"})
    public ResultBean<?> switchVersion(@RequestBody SwitchVersionParam switchVersionParam) {
        String version = switchVersionParam.getVersion();
        List applicationList = switchVersionParam.getApplicationList();
        HashSet tenantIdSet = new HashSet();
        for (Application application : applicationList) {
            List tenantId = application.getTenantId();
            tenantIdSet.addAll(tenantId);
        }
        this.deployerService.switchVersion(new ArrayList(tenantIdSet), version);
        this.publishAfterService.cacheReset();
        return ResultBean.success();
    }

    @GetMapping(value={"/deployLog"})
    public ResultBean<?> deployLog() {
        List deployLogs = this.deployerService.queryDeployLogs();
        return ResultBean.success((Object)deployLogs);
    }

    @PostMapping(value={"/queryAllowCustomPublishApplication"})
    public ResultBean<?> queryAllowCustomPublishApplication(@RequestBody ApplicationCustomPublishDto applicationCustomPublishDto) {
        Map result = this.deployerService.queryAllowCustomPublishApplication(applicationCustomPublishDto);
        return ResultBean.success((Object)result);
    }

    @PostMapping(value={"/queryPublishApplication"})
    public ResultBean<?> queryPublishApplication(@RequestBody ApplicationCustomPublishDto applicationCustomPublishDto) {
        return ResultBean.success((Object)this.deployerService.queryPublishApplication(applicationCustomPublishDto));
    }

    @PostMapping(value={"/queryCustomPublishApplication"})
    public ResultBean<?> queryCustomPublishApplication(@RequestBody ApplicationCustomPublishDto applicationCustomPublishDto) {
        Map result = this.deployerService.queryCustomPublishApplication(applicationCustomPublishDto);
        return ResultBean.success((Object)result);
    }

    @GetMapping(value={"/switchLog"})
    public ResultBean<?> switchLog() {
        List switchLogs = this.deployerService.querySwitchLogs();
        return ResultBean.success((Object)switchLogs);
    }

    @GetMapping(value={"/revert"})
    public ResultBean<?> revert(@RequestParam(value="version") String version) {
        this.deployerService.revert(version);
        return ResultBean.success();
    }

    @GetMapping(value={"/getTenant"})
    public ResultBean<?> getITDATenant(HttpServletRequest request, String application) {
        String token = request.getHeader("token");
        List tenants = this.iamService.tenantsByCustomer(token);
        List<TenantDTO> enterpriseTenants = tenants.stream().filter(tenant -> tenant.getEnterpriseType() != 2 && tenant.getEnterpriseType() != 3 && tenant.getEnterpriseType() != 4).collect(Collectors.toList());
        List tenantApplicationList = this.tenantService.queryByApplication(application);
        List tenantList = tenantApplicationList.stream().map(tenantApplication -> tenantApplication.getTenantId()).collect(Collectors.toList());
        enterpriseTenants.forEach(enterpriseTenant -> {
            if (tenantList.contains(enterpriseTenant.getId())) {
                enterpriseTenant.setPublished(true);
            }
        });
        return ResultBean.success(enterpriseTenants);
    }

    @GetMapping(value={"/queryCompiledDataList"})
    public ResultBean<?> queryCompiledDataList(HttpServletRequest request, String application) {
        List jsonObjectList = this.designerApiHelper.queryCompiledDataList(application, AthenaUserLocal.getUser().getToken());
        return ResultBean.success((Object)jsonObjectList);
    }

    @GetMapping(value={"/operateLog"})
    public ResultBean<?> operateLog(@RequestParam(required=false) String appCode, @RequestParam(required=false) String env, @RequestParam String type, @RequestParam Integer pageNum, @RequestParam(defaultValue="10") Integer pageSize) {
        Pagination pagination = this.deployerService.queryOperateLogs(appCode, env, type, pageNum, pageSize);
        return ResultBean.success((Object)pagination);
    }

    @GetMapping(value={"/getSomeValue"})
    public ResultBean<?> getSomeValue(@RequestParam String type, @RequestParam String key, @RequestParam String application) {
        String value = this.deployerService.getSomeValue(type, key, application);
        return ResultBean.success((Object)value);
    }

    @GetMapping(value={"/incrementSyncEspAction/{env}"})
    public ResultBean<List<EspActionIdSwitchResDto>> incrementSyncEspAction(@PathVariable String env, String actionIds, @RequestHeader(value="token") String token) {
        AthenaUser user;
        try {
            user = AthenaUserLocal.getUser();
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + String.valueOf(e));
        }
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)actionIds), (String)"actionId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSS");
        String formattedDateTime = now.format(formatter);
        ResultBean success = ResultBean.success(new ArrayList());
        if ("all".equalsIgnoreCase(actionIds)) {
            List result = this.deployServiceApiHelper.kmAssignSwitchEspAction(env, token, formattedDateTime + "_" + user.getUserId(), actionIds);
            ((List)success.getData()).add(new EspActionIdSwitchResDto("\u66f4\u65b0\u6210\u529f", "all"));
        } else {
            String[] actionIdArr = actionIds.split(",");
            CharSequence[] newActionIdList = (String[])Arrays.stream(actionIdArr).map(s -> "esp_" + s).toArray(String[]::new);
            String newActionIds = String.join((CharSequence)",", newActionIdList);
            List result = this.deployServiceApiHelper.kmAssignSwitchEspAction(env, token, formattedDateTime + "_" + user.getUserId(), newActionIds);
            ((List)success.getData()).addAll(result);
        }
        return success;
    }
}

