/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.controller;

import com.digiwin.athena.athenadeployer.config.GitLabConfig;
import com.digiwin.athena.athenadeployer.config.redis.RedisLock;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.domain.ApplicationV2;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.service.AthenaDataService;
import com.digiwin.athena.athenadeployer.service.CompareService;
import com.digiwin.athena.athenadeployer.service.DesignerDataService;
import com.digiwin.athena.athenadeployer.service.JGitService;
import com.digiwin.athena.athenadeployer.service.PublishAfterService;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/compare"})
public class CompareController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompareController.class);
    @Autowired
    private GitLabConfig gitLabConfig;
    @Autowired
    private JGitService jGitService;
    @Autowired
    private DesignerDataService designerDataService;
    @Autowired
    private AthenaDataService athenaDataService;
    @Autowired
    private RedisLock redisLock;
    @Autowired
    private PublishAfterService publishAfterService;
    @Autowired
    private CompareService compareService;
    @Autowired
    private BackendApiHelper backendApiHelper;
    private static final List<String> noNeedApp = Arrays.asList("snm", "ApplicationEnhance1_test", "dtddemo3", "athena_task_MO", "DCP1");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"compileAppForTransferData"})
    public ResultBean<?> compileAppForTransferData(@RequestBody ApplicationV2 application) {
        String updateApplication = null;
        if (noNeedApp.contains(application.getApplication())) {
            log.info("----------------------------------\u8df3\u8fc7\u5e94\u7528:{}--------------------------------", (Object)application.getApplication());
            return ResultBean.success((Object)"Skip application!");
        }
        try {
            updateApplication = this.redisLock.tryLock("updateApplication" + application.getApplication(), 300000L);
            if (updateApplication != null) {
                log.info("=======\u62ff\u5230\u521d\u59cb\u5316\u79df\u6237\u7684\u9501updateApplication:{}=======", (Object)updateApplication);
                this.designerDataService.deleteDesignerData();
                String applicationUrl = (String)this.gitLabConfig.getApplication().get(application.getApplication());
                try {
                    this.jGitService.cloneRemoteRepository(this.gitLabConfig.getUrl() + "/" + applicationUrl, application.getBranch(), Constant.DESIGNER_DATA_PATH + File.separator + application.getApplication());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    ResultBean resultBean = ResultBean.fail((Integer)-1, (String)e.getMessage());
                    if (updateApplication != null) {
                        log.info("\u91ca\u653e\u9501updateApplication\uff1a{}", (Object)updateApplication);
                        this.redisLock.unlock("updateApplication" + application.getApplication(), updateApplication);
                    }
                    return resultBean;
                }
                this.athenaDataService.deleteTempAthenaData();
                this.designerDataService.compileDesignerData(application.getApplication());
                this.athenaDataService.publishTransferDataToRuntimeDb(application.getApplication(), application.getVersion());
                this.athenaDataService.modifyDifferenceData(application.getApplication(), application.getVersion());
                log.info("=======" + application.getApplication() + "\u66f4\u65b0\u5b8c\u6210\u5f00\u59cb\u540e\u7eed\u52a8\u4f5c=======");
                this.publishAfterService.createTenantEntityDependency(application.getApplication());
                this.publishAfterService.cacheReset();
                this.publishAfterService.dataMapGraphRebuild();
                ResultBean resultBean = ResultBean.success();
                return resultBean;
            }
            log.info("=======\u6ca1\u6709\u62ff\u5230\u53d1\u5e03\u7684\u9501updateApplication" + application.getApplication() + "\uff0c\u5e94\u7528\u7684\u5176\u4ed6\u5b9e\u4f8b\u6b63\u5728\u521d\u59cb\u5316=======");
            ResultBean applicationUrl = ResultBean.fail((Integer)-1, (String)"The current application is being compiled, please wait!");
            return applicationUrl;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ResultBean resultBean = ResultBean.fail((Integer)-1, (String)"Compilation and comparison of application data are abnormal, please check!");
            return resultBean;
        }
        finally {
            if (updateApplication != null) {
                log.info("\u91ca\u653e\u9501updateApplication\uff1a{}", (Object)updateApplication);
                this.redisLock.unlock("updateApplication" + application.getApplication(), updateApplication);
            }
        }
    }

    @GetMapping(value={"testKgRouterKey"})
    public ResultBean<?> testKgRouterKey(@RequestParam String env, String routerKey) {
        try {
            this.backendApiHelper.testKgRouterKey(env, routerKey);
            return ResultBean.success((Object)"\u63a5\u53e3\u901a\u8fc7");
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }
}

