/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.controller;

import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.DeployLogParam;
import com.digiwin.athena.athenadeployer.dto.deployer.DeleteModelDto;
import com.digiwin.athena.athenadeployer.service.DeleteApplicationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/delete/app"})
public class DeleteAppController {
    @Autowired
    private DeleteApplicationService deleteAppService;

    @PostMapping(value={"/queryDeployLogByAppDeleteKm"})
    public ResultBean<?> queryDeployLogByAppDeleteKm(@RequestBody DeployLogParam deployLogParam) {
        try {
            this.deleteAppService.queryDeployLogByAppDeleteKm(deployLogParam);
            return ResultBean.success();
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/queryDeployEnvByApp"})
    public ResultBean<List<String>> queryDeployEnvByApp(@RequestBody DeployLogParam deployLogParam) {
        try {
            List envs = this.deleteAppService.queryDeployEnvByApp(deployLogParam);
            return ResultBean.success((Object)envs);
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteModel"})
    public ResultBean<?> deleteModel(@RequestBody DeleteModelDto deleteModelDto) {
        try {
            this.deleteAppService.deleteModelByEnvAndApp(deleteModelDto);
            return ResultBean.success();
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/queryFormalZoneList"})
    public ResultBean<List<String>> queryFormalZoneList(@RequestParam(value="application") String application) {
        try {
            List envs = this.deleteAppService.queryFormalZoneList(application);
            return ResultBean.success((Object)envs);
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/deleteDeployLogByApplication"})
    public ResultBean<Void> deleteDeployLogByApplication(@RequestParam(value="application") String application) {
        try {
            this.deleteAppService.deleteDeployLogByApplication(application);
            return ResultBean.success();
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }
}

