/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.Env;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.QueryDeployLogParam;
import com.digiwin.athena.athenadeployer.domain.deploy.QueryDeployLogResult;
import com.digiwin.athena.athenadeployer.dto.deployer.AddPlanResp;
import com.digiwin.athena.athenadeployer.dto.deployer.ChangeDataPublishStatusReqDto;
import com.digiwin.athena.athenadeployer.dto.deployer.DeployTaskInfoResDto;
import com.digiwin.athena.athenadeployer.dto.deployer.RecordAdTemplateTenantDto;
import com.digiwin.athena.athenadeployer.service.CustomPublishService;
import com.digiwin.athena.athenadeployer.service.DeployServiceV3;
import com.digiwin.athena.athenadeployer.service.DeployServiceV4;
import com.digiwin.athena.athenadeployer.service.ReleasePipeLineService;
import com.digiwin.athena.athenadeployer.service.impl.DeployServiceImplV3;
import com.digiwin.athena.athenadeployer.utils.RedisCache;
import com.digiwin.athena.auth.annotation.DataAuth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/deploy/v3"})
@Tag(name="\u53d1\u7248\u5207\u677f", description="12f8276f-7259-483a-9c49-ed742adb3691")
public class DeployControllerV3 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployControllerV3.class);
    @Autowired
    private DeployServiceV3 deployService;
    @Autowired
    private CustomPublishService customPublishService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private ReleasePipeLineService releasePipeLineService;
    @Autowired
    private DeployServiceV4 deployServiceV4;
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${privateEnv}")
    private Boolean privateEnv;

    @PostMapping(value={"/publish"})
    public ResultBean<?> publish(@RequestBody DeployParamV3 deployParam) {
        try {
            List applicationDataList = deployParam.getApplicationDataList();
            List customPublishApplications = applicationDataList.stream().filter(applicationData -> CollUtil.isNotEmpty((Collection)applicationData.getPublishEntityList())).collect(Collectors.toList());
            List customPublishApplicationCodes = customPublishApplications.stream().map(customPublishApplication -> customPublishApplication.getApplication()).collect(Collectors.toList());
            applicationDataList.removeIf(applicationData -> customPublishApplicationCodes.contains(applicationData.getApplication()));
            if (CollUtil.isNotEmpty((Collection)applicationDataList)) {
                this.deployService.deploy(deployParam);
            }
            if (CollUtil.isNotEmpty(customPublishApplications)) {
                for (ApplicationData customPublishApplication2 : customPublishApplications) {
                    CustomPublishParam customPublishParam = new CustomPublishParam();
                    customPublishParam.setTenantUsers(deployParam.getTenantUsers()).setEnv(deployParam.getEnv()).setCurrentUser(AthenaUserLocal.getUser()).setApplication(customPublishApplication2.getApplication()).setPublishEntityList(customPublishApplication2.getPublishEntityList()).setCompileDataCode(customPublishApplication2.getCompileDataCode());
                    this.customPublishService.publish(customPublishParam);
                }
            }
        }
        catch (BusinessException e) {
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success((Object)"Successfully released the app!");
    }

    @GetMapping(value={"/queryApplicationLatestInfo"})
    public ResultBean<?> queryApplicationLatestInfo(@RequestParam(value="application") String application) {
        JSONObject jsonObject = this.deployService.queryLatestApplicationInfo(application);
        return ResultBean.success((Object)jsonObject);
    }

    @PostMapping(value={"/customPublish"})
    public ResultBean<?> customPublish(@RequestBody CustomPublishParam customPublishParam) {
        JSONObject jsonObject = this.deployService.queryLatestApplicationInfo(customPublishParam.getApplication());
        return ResultBean.success((Object)jsonObject);
    }

    @PostMapping(value={"/saveDeployLog"})
    public ResultBean saveDeployLog(@RequestBody DeployLog deployLog) {
        this.deployService.saveDeployLog(deployLog.getTenantIdList(), deployLog.getApplication(), deployLog.getAllowCustomPublish());
        return ResultBean.success();
    }

    @PostMapping(value={"/addDeployPlan"})
    @DataAuth(resourceType="env", pkValue="Json:0#$.env", resourceId="Json:0#$.applicationDataList[*].application||$tenantId", throwException=true)
    @Operation(summary="\u6dfb\u52a0\u53d1\u7248\u4efb\u52a1")
    public ResultBean<?> addDeployPlan(@RequestBody DeployParamV3 deployParam) {
        deployParam.setCurrentUser(AthenaUserLocal.getUser());
        try {
            this.releasePipeLineService.verifyCompileData(deployParam);
            String deployNo = this.deployService.addDeployPlan(deployParam);
            return ResultBean.success((Object)deployNo);
        }
        catch (Exception e) {
            log.error("addDeployPlan error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/addDeployPlan4Agile"})
    public ResultBean<?> addDeployPlanForAgile(@RequestBody DeployParamV3 deployParam) {
        try {
            AthenaUserLocal.setUser((AthenaUser)deployParam.getCurrentUser());
            String deployNo = this.deployService.addDeployPlan(deployParam);
            return ResultBean.success((Object)deployNo);
        }
        catch (Exception e) {
            log.error("addDeployPlan error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/queryDeployLog"})
    public ResultBean<?> queryDeployLog(@RequestBody QueryDeployLogParam queryDeployLogParam) {
        QueryDeployLogResult result = this.deployService.queryDeployLog(queryDeployLogParam);
        return ResultBean.success((Object)result);
    }

    @GetMapping(value={"/startDeployConsumer"})
    public ResultBean<?> startDeployConsumer() {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Boolean deployConsumerAlive = false;
        for (Thread thread : threadSet) {
            if (!"DeployConsumerThread".equals(thread.getName())) continue;
            deployConsumerAlive = true;
        }
        if (!deployConsumerAlive.booleanValue()) {
            // empty if block
        }
        return ResultBean.success();
    }

    @GetMapping(value={"/queryDeployDetail"})
    public ResultBean<?> queryDeployDetail(@RequestParam(value="deployNo") String deployNo) {
        List deployDetailV2s = this.deployService.queryDeployDetails(deployNo);
        return ResultBean.success((Object)deployDetailV2s);
    }

    @GetMapping(value={"/popDeployNo"})
    public ResultBean<?> popDeployNo(@RequestParam(value="key") String key) {
        Object obj = this.redisCache.lpop(key);
        return ResultBean.success((Object)obj);
    }

    @GetMapping(value={"/deleteCache"})
    public ResultBean<?> deleteCache(@RequestParam(value="key") String key) {
        this.redisCache.delete(key);
        return ResultBean.success();
    }

    @GetMapping(value={"/deleteListElem"})
    public ResultBean<?> deleteListElem(@RequestParam(value="key") String key, @RequestParam(value="count") long count, @RequestParam(value="value") String value) {
        this.redisCache.deleteListElem(key, count, (Object)value);
        return ResultBean.success();
    }

    @GetMapping(value={"/getCache"})
    public ResultBean<?> getCache(@RequestParam(value="key") String key) {
        Object obj = this.redisCache.get(key);
        return ResultBean.success((Object)obj);
    }

    @GetMapping(value={"/getHashCache"})
    public ResultBean<?> getHashCache(@RequestParam(value="key") String key) {
        Object obj = this.redisCache.getHashEntries(key);
        return ResultBean.success((Object)obj);
    }

    @GetMapping(value={"/queryDeployProcess"})
    public ResultBean<?> queryDeployProcess(@RequestParam(value="deployNo") String deployNo, @RequestParam(value="application") String application) {
        DeployLog deployLog = this.deployServiceV4.getDeployLog(application, deployNo);
        if ("new".equals(deployLog.getDeployParam().getPublishMode())) {
            return this.queryProcess(deployNo, application);
        }
        Object process = this.redisCache.get(DeployServiceImplV3.DEPLOY_PROCESS_KEY + application + deployNo);
        if (process == null) {
            process = BigDecimal.ZERO;
        }
        return ResultBean.success((Object)Double.valueOf(process.toString()));
    }

    @GetMapping(value={"/queryDeployProcess4Agile"})
    public ResultBean<?> queryDeployProcess4Agile(@RequestParam(value="deployNo") String deployNo, @RequestParam(value="application") String application) {
        DeployLog deployLog = this.deployServiceV4.getDeployLog(application, deployNo);
        if ("new".equals(deployLog.getDeployParam().getPublishMode())) {
            return this.queryProcess4Agile(deployNo, application);
        }
        Object process = this.redisCache.get(DeployServiceImplV3.DEPLOY_PROCESS_KEY + application + deployNo);
        if (process == null) {
            process = BigDecimal.ZERO;
        }
        return ResultBean.success((Object)Double.valueOf(process.toString()));
    }

    @GetMapping(value={"/deployIsEnd"})
    public ResultBean deployIsEnd(@RequestParam(value="deployNo") String deployNo, @RequestParam(value="allApplication") String allApplication) {
        String[] applicationArray = allApplication.split(",");
        String status = "success";
        for (String app : applicationArray) {
            Object process = this.redisCache.get(DeployServiceImplV3.DEPLOY_PROCESS_KEY + app + deployNo);
            if (process == null) {
                status = "executing";
                break;
            }
            BigDecimal progressNum = new BigDecimal(Convert.toStr((Object)process));
            if (progressNum.compareTo(new BigDecimal(-1)) == 0) {
                status = "fail";
                break;
            }
            if (progressNum.compareTo(BigDecimal.ONE) >= 0) continue;
            status = "executing";
            break;
        }
        return ResultBean.success((Object)status);
    }

    @GetMapping(value={"/queryDeployDetailByApplication"})
    public ResultBean<?> queryDeployDetail(@RequestParam(value="deployNo") String deployNo, @RequestParam(value="application") String application) {
        List deployDetailV2s = this.deployService.queryDeployDetailByApplication(deployNo, application);
        return ResultBean.success((Object)deployDetailV2s);
    }

    @GetMapping(value={"/queryDeployDetailV2"})
    public ResultBean<List<DeployTaskInfoResDto>> queryDeployDetailV2(@RequestParam(value="deployNo") String deployNo, @RequestParam(value="application") String application) {
        List deployDetailV2s = this.deployService.queryDeployDetail(deployNo, application);
        return ResultBean.success((Object)deployDetailV2s);
    }

    @PostMapping(value={"/recordAdTemplateTenantDeployInfo"})
    public ResultBean<?> recordAdTemplateTenantDeployInfo(@RequestBody RecordAdTemplateTenantDto recordAdTemplateTenantDto) {
        this.deployService.recordAdTemplateTenantDeployInfo(recordAdTemplateTenantDto.getApplication(), recordAdTemplateTenantDto.getTenantUsers(), recordAdTemplateTenantDto.getEnv(), recordAdTemplateTenantDto.getAdTemplateList(), recordAdTemplateTenantDto.getUcAdTemplateList());
        return ResultBean.success((Object)"\u8bb0\u5f55\u6210\u529f\uff01");
    }

    @PostMapping(value={"/addSwitchPlan"})
    @DataAuth(resourceType="env", pkValue="Json:0#$.env", resourceId="Json:0#$.applicationDataList[*].application||$tenantId", throwException=true)
    @Operation(summary="\u6dfb\u52a0\u5207\u677f\u4efb\u52a1")
    public ResultBean<?> addSwitchPlan(@RequestBody DeployParamV3 deployParam) {
        deployParam.setCurrentUser(AthenaUserLocal.getUser());
        try {
            this.releasePipeLineService.verifyPublishLog(deployParam);
            AddPlanResp addPlanResp = this.deployService.addSwitchPlan(deployParam);
            return ResultBean.success((Object)addPlanResp);
        }
        catch (Exception e) {
            log.error("addSwitchPlan error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/addSwitchPlan4Agile"})
    public ResultBean<?> addSwitchPlan4Agile(@RequestBody DeployParamV3 deployParam) {
        try {
            AthenaUserLocal.setUser((AthenaUser)deployParam.getCurrentUser());
            AddPlanResp addPlanResp = this.deployService.addSwitchPlan(deployParam);
            return ResultBean.success((Object)addPlanResp);
        }
        catch (Exception e) {
            log.error("addSwitchPlan error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/processIsEnd"})
    public ResultBean processIsEnd(@RequestParam(value="deployNo") String deployNo, @RequestParam(value="allApplication") String allApplication) {
        String[] applicationArray = allApplication.split(",");
        String status = "success";
        for (String app : applicationArray) {
            BigDecimal process = this.deployService.getApplicationProcess(app, deployNo);
            if (process == null) {
                status = "executing";
                break;
            }
            if (process.compareTo(new BigDecimal(-1)) == 0) {
                status = "fail";
                break;
            }
            if (process.compareTo(BigDecimal.ONE) >= 0) continue;
            status = "executing";
            break;
        }
        return ResultBean.success((Object)status);
    }

    @GetMapping(value={"/queryProcess"})
    public ResultBean<?> queryProcess(@RequestParam(value="deployNo") String deployNo, @RequestParam(value="application") String application) {
        BigDecimal process = this.deployService.getApplicationProcess(application, deployNo);
        if (process == null) {
            process = BigDecimal.ZERO;
        }
        return ResultBean.success((Object)process);
    }

    @GetMapping(value={"/queryProcess4Agile"})
    public ResultBean<?> queryProcess4Agile(@RequestParam(value="deployNo") String deployNo, @RequestParam(value="application") String application) {
        BigDecimal process = this.deployService.getApplicationProcess4Agile(application, deployNo);
        if (process == null) {
            process = BigDecimal.ZERO;
        }
        return ResultBean.success((Object)process);
    }

    @DeleteMapping(value={"/deleteRuntimeAppData"})
    public ResultBean<?> deleteRuntimeAppData(@RequestParam String appCode, @RequestParam String env, @RequestParam String version, @RequestHeader(value="token") String token) {
        this.deployService.deleteRuntimeAppData(appCode, env, version);
        return ResultBean.success((Object)"\u5e94\u7528\u8fd0\u884c\u6001\u6570\u636e\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/changeKmDataPublishStatus"})
    public ResultBean changeKmDataPublishStatus(@RequestBody ChangeDataPublishStatusReqDto changeDataPublishStatusReqDto) {
        try {
            this.deployServiceV4.changeKmDataPublishStatus(changeDataPublishStatusReqDto);
            return ResultBean.success();
        }
        catch (Exception e) {
            log.error("changeKmDataPublishStatus exception:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/privateDeployApp"})
    public ResultBean privateDeployApp(@RequestParam String deployParamStr, @RequestParam(value="file") MultipartFile file) {
        DeployParamV3 deployParam = (DeployParamV3)JSONObject.parseObject((String)deployParamStr, DeployParamV3.class);
        deployParam.setCurrentUser(AthenaUserLocal.getUser());
        String application = deployParam.getCompileData().getString("application");
        String version = deployParam.getCompileData().getString("version");
        try {
            String fileId = this.deployService.privateUploadCompiledData(file, application, version);
            deployParam.getCompileData().put("compiledDataFileId", (Object)fileId);
            String deployNo = this.deployService.addPrivateDeployApp(deployParam);
            return ResultBean.success((Object)deployNo);
        }
        catch (Exception e) {
            log.error("addDeployPlan error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @PostMapping(value={"/privateSwitchApp"})
    public ResultBean privateSwitchApp(@RequestParam String deployParamStr) {
        DeployParamV3 deployParam = (DeployParamV3)JSONObject.parseObject((String)deployParamStr, DeployParamV3.class);
        deployParam.setCurrentUser(AthenaUserLocal.getUser());
        try {
            AddPlanResp addPlanResp = this.deployService.addPrivateSwitchPlan(deployParam);
            return ResultBean.success(null);
        }
        catch (Exception e) {
            log.error("addSwitchPlan error:", (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/privateQueryDeployLog"})
    public ResultBean<List<DeployLog>> privateQueryDeployLog(String type) {
        List res = this.deployService.privateQueryDeployLog(type);
        return ResultBean.success((Object)res);
    }

    @GetMapping(value={"/privateDeployDetailByApplication"})
    public ResultBean<List<DeployDetailV2>> privateDeployDetailByApplication(@RequestParam(value="deployNo") String deployNo, @RequestParam(value="application") String application) {
        List deployDetailV2s = this.deployService.queryDeployDetailByApplication(deployNo, application);
        return ResultBean.success((Object)deployDetailV2s);
    }

    @Operation(summary="\u83b7\u53d6\u5e94\u7528\u53d1\u5e03\u8fc7\u73af\u5883\u7684deployerService\u57df\u540d")
    @GetMapping(value={"/getAppAllDeployService"})
    public ResultBean<List<Env>> getAppAllDeployService(String appCode) {
        return ResultBean.success((Object)this.deployServiceV4.getDeployServiceDomain(appCode));
    }

    @GetMapping(value={"/privateEnv"})
    public ResultBean<Boolean> privateEnv() {
        return ResultBean.success((Object)this.privateEnv);
    }
}

