/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.controller;

import com.digiwin.athena.athenadeployer.config.GitLabConfig;
import com.digiwin.athena.athenadeployer.config.redis.RedisLock;
import com.digiwin.athena.athenadeployer.constant.Constant;
import com.digiwin.athena.athenadeployer.domain.ApplicationV2;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.service.AthenaDataService;
import com.digiwin.athena.athenadeployer.service.CompileService;
import com.digiwin.athena.athenadeployer.service.DeployerService;
import com.digiwin.athena.athenadeployer.service.DesignerDataService;
import com.digiwin.athena.athenadeployer.service.JGitService;
import com.digiwin.athena.athenadeployer.service.PublishAfterService;
import com.digiwin.athena.athenadeployer.utils.SafeFileUtils;
import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/deployer"})
public class DeployerController {
    @Generated
    private static final Logger log = LogManager.getLogger(DeployerController.class);
    @Autowired
    private GitLabConfig gitLabConfig;
    @Autowired
    private JGitService jGitService;
    @Autowired
    private DesignerDataService designerDataService;
    @Autowired
    private AthenaDataService athenaDataService;
    @Autowired
    private RedisLock redisLock;
    @Autowired
    private PublishAfterService publishAfterService;
    @Autowired
    private CompileService compileService;
    @Autowired
    private DeployerService deployerService;
    @Autowired(required=false)
    @Qualifier(value="designerMongoTemplate")
    private MongoTemplate designerMongoTemplate;

    @PostMapping(value={"compile"})
    public ResultBean<?> compile(@RequestBody ApplicationV2 application) {
        String compileVersion = this.compileService.compile(application.getApplication(), application.getBranch());
        return ResultBean.success((Object)compileVersion);
    }

    @GetMapping(value={"deploy"})
    public ResultBean<?> deploy(@RequestParam(value="application") String application, @RequestParam(value="compileVersion") String compileVersion, @RequestParam(value="deployVersion") String deployVersion) {
        return ResultBean.success();
    }

    @PostMapping(value={"cloneRemoteRepository"})
    public ResultBean<String> cloneRemoteRepository(@RequestBody ApplicationV2 application) {
        this.designerDataService.deleteDesignerData();
        String applicationUrl = (String)this.gitLabConfig.getApplication().get(application.getApplication());
        try {
            this.jGitService.cloneRemoteRepository(this.gitLabConfig.getUrl() + "/" + applicationUrl, application.getBranch(), Constant.DESIGNER_DATA_PATH + File.separator + application.getApplication());
        }
        catch (IOException | GitAPIException e) {
            log.error(e.getMessage(), e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"updateApplication"})
    public ResultBean<?> updateApplication(@RequestBody ApplicationV2 application) {
        String updateApplication = null;
        try {
            updateApplication = this.redisLock.tryLock("updateApplication" + application.getApplication(), 300000L);
            if (updateApplication != null) {
                log.info("=======\u62ff\u5230\u521d\u59cb\u5316\u79df\u6237\u7684\u9501updateApplication:{}=======", (Object)updateApplication);
                this.designerDataService.deleteDesignerData();
                String compileVersion = this.compileService.upZipPackage(application.getApplication());
                File[] files = SafeFileUtils.createFile((String)(Constant.DESIGNER_DATA_PATH + File.separator + application.getApplication())).listFiles();
                this.deployerService.deploy(application.getApplication(), files, compileVersion, application.getVersion());
                this.athenaDataService.modifyDifferenceData(application.getApplication(), application.getVersion());
                log.info("=======" + application.getApplication() + "\u66f4\u65b0\u5b8c\u6210\u5f00\u59cb\u540e\u7eed\u52a8\u4f5c=======");
                this.publishAfterService.createTenantEntityDependency(application.getApplication());
                this.publishAfterService.cacheReset();
                ResultBean resultBean = ResultBean.success();
                return resultBean;
            }
            log.info("=======\u6ca1\u6709\u62ff\u5230\u53d1\u5e03\u7684\u9501updateApplication" + application.getApplication() + "\uff0c\u5e94\u7528\u7684\u5176\u4ed6\u5b9e\u4f8b\u6b63\u5728\u521d\u59cb\u5316=======");
            ResultBean compileVersion = ResultBean.fail((Integer)-1, (String)"The current app is being published, please wait!");
            return compileVersion;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ResultBean resultBean = ResultBean.fail((Integer)-1, (String)"Application publishing exception, please contact the operation and maintenance personnel!");
            return resultBean;
        }
        finally {
            if (updateApplication != null) {
                log.info("\u91ca\u653e\u9501updateApplication\uff1a{}", (Object)updateApplication);
                this.redisLock.unlock("updateApplication" + application.getApplication(), updateApplication);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"updateApplication2"})
    public ResultBean<?> updateApplication2(@RequestBody ApplicationV2 application) {
        String updateApplication = null;
        try {
            updateApplication = this.redisLock.tryLock("updateApplication" + application.getApplication(), 300000L);
            if (updateApplication != null) {
                log.info("=======\u62ff\u5230\u521d\u59cb\u5316\u79df\u6237\u7684\u9501updateApplication:{}=======", (Object)updateApplication);
                this.designerDataService.deleteDesignerData();
                String applicationUrl = (String)this.gitLabConfig.getApplication().get(application.getApplication());
                try {
                    this.jGitService.cloneRemoteRepository(this.gitLabConfig.getUrl() + "/" + applicationUrl, application.getBranch(), Constant.DESIGNER_DATA_PATH + File.separator + application.getApplication());
                }
                catch (IOException | GitAPIException e) {
                    log.error(e.getMessage(), e);
                    ResultBean resultBean = ResultBean.fail((Integer)-1, (String)e.getMessage());
                    if (updateApplication != null) {
                        log.info("\u91ca\u653e\u9501updateApplication\uff1a{}", (Object)updateApplication);
                        this.redisLock.unlock("updateApplication" + application.getApplication(), updateApplication);
                    }
                    return resultBean;
                }
                this.athenaDataService.deleteTempAthenaData();
                this.designerDataService.compileDesignerData(application.getApplication());
                this.athenaDataService.publishAthenaData(application.getApplication(), application.getVersion());
                this.athenaDataService.modifyDifferenceData(application.getApplication(), application.getVersion());
                log.info("=======" + application.getApplication() + "\u66f4\u65b0\u5b8c\u6210\u5f00\u59cb\u540e\u7eed\u52a8\u4f5c=======");
                this.publishAfterService.createTenantEntityDependency(application.getApplication());
                this.publishAfterService.cacheReset();
                this.publishAfterService.dataMapGraphRebuild();
                ResultBean resultBean = ResultBean.success();
                return resultBean;
            }
            log.info("=======\u6ca1\u6709\u62ff\u5230\u53d1\u5e03\u7684\u9501updateApplication" + application.getApplication() + "\uff0c\u5e94\u7528\u7684\u5176\u4ed6\u5b9e\u4f8b\u6b63\u5728\u521d\u59cb\u5316=======");
            ResultBean applicationUrl = ResultBean.fail((Integer)-1, (String)"The current app is being published, please wait!");
            return applicationUrl;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ResultBean resultBean = ResultBean.fail((Integer)-1, (String)"Application publishing exception, please contact the operation and maintenance personnel!");
            return resultBean;
        }
        finally {
            if (updateApplication != null) {
                log.info("\u91ca\u653e\u9501updateApplication\uff1a{}", (Object)updateApplication);
                this.redisLock.unlock("updateApplication" + application.getApplication(), updateApplication);
            }
        }
    }

    @GetMapping(value={"taskRelease"})
    public ResultBean taskRelease(@RequestParam String version, @RequestParam String tmActivityId) {
        try {
            this.deployerService.taskRelease(version, tmActivityId);
            return ResultBean.success();
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)"Task release exception, please contact the operation and maintenance personnel!");
        }
    }

    @PostMapping(value={"systemParamSync"})
    public ResultBean systemParamSync() {
        try {
            this.deployerService.systemParamSync();
            return ResultBean.success();
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)"The synchronization of service orchestration system parameters is abnormal. Please contact the operation and maintenance personnel!");
        }
    }
}

