/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.controller;

import com.digiwin.athena.athenadeployer.domain.Env;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.service.EnvService;
import com.digiwin.athena.athenadeployer.service.ReleasePipeLineService;
import com.digiwin.athena.auth.annotation.DataAuth;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/env"})
@CrossOrigin
public class EnvController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvController.class);
    @Autowired
    private EnvService envService;
    @Autowired
    private ReleasePipeLineService releasePipeLineService;

    @GetMapping(value={"queryEnvs"})
    @DataAuth(resourceType="env", resourceId="Var:1||$tenantId")
    public ResultBean<?> queryEnvs(@RequestParam(value="operate") String operate, @RequestParam(value="application") String application) {
        List envs = this.envService.queryEnvs(operate);
        return ResultBean.success((Object)envs);
    }

    @GetMapping(value={"envByRegion"})
    public ResultBean<?> queryEnvByRegion(@RequestParam(required=false) String operate) {
        List envs = this.envService.queryEnvsWithoutAuth(operate);
        return ResultBean.success((Object)envs);
    }

    @GetMapping(value={"/queryWithAuth"})
    public ResultBean<?> queryWithAuth(String operate) {
        List envs = this.envService.queryWithAuth(operate);
        return ResultBean.success((Object)envs);
    }

    @GetMapping(value={"/queryEnvByServiceId"})
    public ResultBean<List<Env>> queryEnv(String serviceId) {
        return ResultBean.success((Object)this.envService.queryEnv(serviceId));
    }
}

