/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.controller;

import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.DeployExecutingInfo;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.DeployLogParam;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.TenantPipeLine;
import com.digiwin.athena.athenadeployer.service.ReleasePipeLineService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/releasePipeline"})
@Tag(name="\u53d1\u5e03\u6d41\u6c34\u7ebf", description="8F362CEA-33B6-ACE8-A51B-7AF0116B1FB7")
public class ReleasePipelineController {
    @Autowired
    private ReleasePipeLineService releasePipeLineService;

    @PostMapping(value={"/verifyCompileData"})
    public ResultBean verifyCompileData(@RequestBody DeployParamV3 deployParamV3) {
        this.releasePipeLineService.verifyCompileData(deployParamV3);
        return ResultBean.success();
    }

    @PostMapping(value={"/verifyPublishLog"})
    public ResultBean verifyPublishLog(@RequestBody DeployParamV3 deployParamV3) {
        this.releasePipeLineService.verifyPublishLog(deployParamV3);
        return ResultBean.success();
    }

    @PostMapping(value={"/queryDeployLogByEnv"})
    public ResultBean<?> queryDeployLogByEnv(@RequestBody DeployLogParam deployLogParam) {
        List deployLogResults = this.releasePipeLineService.queryDeployLogByEnv(deployLogParam);
        return ResultBean.success((Object)deployLogResults);
    }

    @GetMapping(value={"/queryLatestDeployInfo"})
    public ResultBean<?> queryLatestDeployInfo(@RequestParam(value="application") String application, @RequestParam(value="envServiceId") String envServiceId, @RequestParam(value="type") String type) {
        DeployExecutingInfo deployExecutingInfo = this.releasePipeLineService.queryDeployLog(application, envServiceId, "executing", type);
        return ResultBean.success((Object)deployExecutingInfo);
    }

    @GetMapping(value={"/queryAppTenantResult"})
    public ResultBean<?> queryAppTenantResult(@RequestParam(value="application") String application, @RequestParam(value="operate") String operate, @RequestParam(value="envServiceId") String envServiceId) {
        List appTenantResults = this.releasePipeLineService.queryAppTenantResult(application, envServiceId, operate);
        return ResultBean.success((Object)appTenantResults);
    }

    @GetMapping(value={"/queryTenantPipeline"})
    public ResultBean<?> queryTenantPipeline(@RequestParam(value="application") String application) {
        TenantPipeLine tenantPipeLine = this.releasePipeLineService.queryTenantPipelineByApplication(application);
        return ResultBean.success((Object)tenantPipeLine);
    }

    @GetMapping(value={"/queryTenantPipeline4IndexPage"})
    public ResultBean<?> queryTenantPipeline4IndexPage() {
        TenantPipeLine tenantPipeLine = this.releasePipeLineService.queryTenantPipeline4IndexPage();
        return ResultBean.success((Object)tenantPipeLine);
    }

    @PostMapping(value={"/queryTestEnvCompileCodeList"})
    public ResultBean<?> queryTestEnvCompileCodeList(@RequestParam(value="envServiceId") String envServiceId, @RequestBody List<String> applicationList) {
        List results = this.releasePipeLineService.queryTestEnvCompileCodeList(applicationList, envServiceId);
        return ResultBean.success((Object)results);
    }

    @GetMapping(value={"/queryAppListByEnvServiceId"})
    public ResultBean<?> queryAppListByEnvServiceId(@RequestParam String envServiceId, @RequestParam String operate) {
        List envApps = this.releasePipeLineService.queryAppListByEnvServiceId(envServiceId, operate);
        return ResultBean.success((Object)envApps);
    }

    @GetMapping(value={"/queryEnvsByOperate"})
    public ResultBean<?> queryEnvsByOperate(@RequestParam String operate) {
        List envs = this.releasePipeLineService.queryEnvsByOperate(operate);
        return ResultBean.success((Object)envs);
    }

    @GetMapping(value={"/queryAllNode"})
    public ResultBean<?> queryAllNode() {
        List nodes = this.releasePipeLineService.queryAllNode();
        return ResultBean.success((Object)nodes);
    }

    @GetMapping(value={"/tenant"})
    @Operation(summary="\u67e5\u8be2\u79df\u6237\u7ea7\u6d41\u6c34\u7ebf\uff0c\u5f53tenantId=SYSTEM\u65f6\u4e3a\u7cfb\u7edf\u7ea7")
    public ResultBean<TenantPipeLine> queryTenantPipeLine(@RequestParam String tenantId) {
        return ResultBean.success((Object)this.releasePipeLineService.getTenantPipeLineByTenantId(tenantId));
    }

    @PostMapping(value={"/tenant/save"})
    @Operation(summary="\u4fdd\u5b58\u6d41\u6c34\u7ebf")
    public ResultBean<TenantPipeLine> insertTenantPipeLine(@RequestBody TenantPipeLine tenantPipeLine) {
        return ResultBean.success((Object)this.releasePipeLineService.insert(tenantPipeLine));
    }

    @PostMapping(value={"/tenant/update"})
    @Operation(summary="\u66f4\u65b0\u6d41\u6c34\u7ebf")
    public ResultBean<TenantPipeLine> updateTenantPipeLine(@RequestBody TenantPipeLine tenantPipeLine) {
        return ResultBean.success((Object)this.releasePipeLineService.update(tenantPipeLine));
    }

    @DeleteMapping(value={"/tenant"})
    @Operation(summary="\u5220\u9664\u6d41\u6c34\u7ebf")
    public ResultBean<String> deleteTenantPipeLine(@RequestParam String tenantId) {
        this.releasePipeLineService.delete(tenantId);
        return ResultBean.success((Object)"\u5220\u9664\u6210\u529f\uff01");
    }
}

