/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.controller;

import com.digiwin.athena.athenadeployer.config.redis.RedisLock;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.dto.itda.ITDATenantDTO;
import com.digiwin.athena.athenadeployer.dto.itda.PublishITDADTO;
import com.digiwin.athena.athenadeployer.dto.tenant.TenantDTO;
import com.digiwin.athena.athenadeployer.service.IAMService;
import com.digiwin.athena.athenadeployer.service.PublishAfterService;
import com.digiwin.athena.athenadeployer.service.itda.ITDAService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ITDA"})
public class TIDAController {
    @Generated
    private static final Logger log = LogManager.getLogger(TIDAController.class);
    @Autowired
    private ITDAService itdaService;
    @Autowired
    private IAMService iamService;
    @Autowired
    private RedisLock redisLock;
    @Autowired
    private PublishAfterService publishAfterService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"publishITDA"})
    public ResultBean<?> publishITDA(@RequestBody @Validated PublishITDADTO publishITDADTO) {
        String publishITDALock = null;
        try {
            publishITDALock = this.redisLock.tryLock("publishITDALock" + publishITDADTO.getCode(), 300000L);
            if (publishITDALock != null) {
                log.info("=======\u62ff\u5230\u521d\u59cb\u5316\u79df\u6237\u7684\u9501publishITDALock:{}=======", (Object)publishITDALock);
                this.itdaService.addITDAPublishHistory(publishITDADTO.getCode(), publishITDADTO.getTenantId());
                log.info("===========\u5f00\u59cbpublishITDAAthenaData\u8fc7\u7a0b==========");
                this.itdaService.publishITDAAthenaData(publishITDADTO.getCode(), publishITDADTO.getTenantId());
                this.publishAfterService.cacheReset();
                this.publishAfterService.dataMapGraphRebuild();
                ResultBean resultBean = ResultBean.success();
                return resultBean;
            }
            log.info("=======\u6ca1\u6709\u62ff\u5230\u53d1\u5e03\u7684\u9501publishITDALock" + publishITDADTO.getCode() + "\uff0c\u5e94\u7528\u7684\u5176\u4ed6\u5b9e\u4f8b\u6b63\u5728\u521d\u59cb\u5316=======");
            ResultBean resultBean = ResultBean.fail((Integer)-1, (String)"The current project is being published, please wait!");
            return resultBean;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ResultBean resultBean = ResultBean.fail((Integer)-1, (String)"Project release exception, please contact the operation and maintenance personnel!");
            return resultBean;
        }
        finally {
            if (publishITDALock != null) {
                log.info("\u91ca\u653e\u9501publishITDALock\uff1a{}", (Object)publishITDALock);
                this.redisLock.unlock("publishITDALock" + publishITDADTO.getCode(), publishITDALock);
            }
        }
    }

    @GetMapping(value={"getITDATenant"})
    public ResultBean<?> getITDATenant(HttpServletRequest request, String code) {
        String token = request.getHeader("token");
        List tenants = this.iamService.tenantsByCustomer(token);
        List<TenantDTO> enterpriseTenants = tenants.stream().filter(tenant -> tenant.getEnterpriseType() != 2 && tenant.getEnterpriseType() != 3 && tenant.getEnterpriseType() != 4).collect(Collectors.toList());
        ArrayList itdaTenants = new ArrayList();
        List publishedTenantList = this.itdaService.getITDAPublishedTenantByCode(code);
        List openTenantList = this.itdaService.getITDAOpenTenantByCodeAndTenantList(code, publishedTenantList);
        enterpriseTenants.forEach(enterpriseTenant -> {
            ITDATenantDTO itdaTenantDTO = new ITDATenantDTO(enterpriseTenant);
            if (publishedTenantList.contains(itdaTenantDTO.getId())) {
                itdaTenantDTO.setPublished(true);
            }
            if (openTenantList.contains(itdaTenantDTO.getId())) {
                itdaTenantDTO.setState("enable");
            } else {
                itdaTenantDTO.setState("disable");
            }
            itdaTenants.add(itdaTenantDTO);
        });
        return ResultBean.success(itdaTenants);
    }

    @PostMapping(value={"updateITDATenantState"})
    public ResultBean<?> updateITDATenantState(@RequestBody @Validated PublishITDADTO publishITDADTO) {
        this.itdaService.updateITDATenantState(publishITDADTO);
        return ResultBean.success();
    }
}

