/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.TenantApplicationParam;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.tenant.TenantUserResult;
import com.digiwin.athena.athenadeployer.dto.deployer.Pagination;
import com.digiwin.athena.athenadeployer.dto.deployer.TenantAndEnvReq;
import com.digiwin.athena.athenadeployer.http.BackendApiHelper;
import com.digiwin.athena.athenadeployer.http.IamApiHelper;
import com.digiwin.athena.athenadeployer.service.TenantService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"})
@CrossOrigin
public class TenantController {
    @Autowired
    private TenantService tenantService;
    @Autowired
    private BackendApiHelper backendApiHelper;
    @Autowired
    private IamApiHelper iamApiHelper;

    @PostMapping(value={"/application"})
    public ResultBean<?> application(@RequestBody TenantApplicationParam tenantApplicationParam) {
        List maps = this.tenantService.queryTenantApplication(tenantApplicationParam);
        return ResultBean.success((Object)maps);
    }

    @GetMapping(value={"allTenant"})
    public ResultBean<?> allTenant(@RequestHeader(value="digi-middleware-auth-user") String token, @RequestParam(value="env") String env) {
        String tenantId = AthenaUserLocal.getUser().getTenantId();
        JSONObject jsonObject = this.backendApiHelper.allTenant(token, tenantId, env);
        if (jsonObject.getInteger("code") != null && 200 == jsonObject.getInteger("code")) {
            return ResultBean.success((Object)jsonObject.getJSONArray("data").toJavaList(JSONObject.class));
        }
        JSONArray data = new JSONArray();
        JSONObject supplementObject = new JSONObject();
        supplementObject.put("id", (Object)AthenaUserLocal.getUser().getTenantId());
        supplementObject.put("sid", (Object)AthenaUserLocal.getUser().getTenantSid());
        supplementObject.put("name", (Object)AthenaUserLocal.getUser().getTenantName());
        data.add((Object)supplementObject);
        return ResultBean.success((Object)data.toJavaList(JSONObject.class));
    }

    @GetMapping(value={"allUserInTenant"})
    public ResultBean<?> allUserInTenant(@RequestParam String tenantId, @RequestParam String env, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(defaultValue="1") Integer pageNum) {
        TenantUserResult tenantUserResult = this.backendApiHelper.allUserInTenant(tenantId, AthenaUserLocal.getUser().getToken(), pageSize, pageNum, env);
        return ResultBean.success((Object)tenantUserResult);
    }

    @GetMapping(value={"currentUserExistInTenant"})
    public ResultBean<?> currentUserExistInTenant(@RequestParam String tenantId, @RequestParam String env) {
        String userId = AthenaUserLocal.getUser().getUserId();
        try {
            boolean exist = this.backendApiHelper.currentUserExistInTenant(userId, tenantId, AthenaUserLocal.getUser().getToken(), env);
            return ResultBean.success((Object)exist);
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)"\u67e5\u8be2\u5f53\u524d\u7528\u6237\u662f\u5426\u5728\u6307\u5b9a\u79df\u6237\u7528\u6237\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    @PostMapping(value={"currentUserExistInTenantList"})
    public ResultBean<?> currentUserExistInTenantList(@RequestBody TenantAndEnvReq tenantAndEnvReq) {
        try {
            List currentUserExistInTenants = this.tenantService.queryCurrentUserExistInTenantList(tenantAndEnvReq);
            return ResultBean.success((Object)currentUserExistInTenants);
        }
        catch (Exception e) {
            return ResultBean.fail((Integer)-1, (String)"\u67e5\u8be2\u5f53\u524d\u7528\u6237\u662f\u5426\u5728\u79df\u6237\u7528\u6237\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    @GetMapping(value={"tenantVersion"})
    public ResultBean<?> queryTenantVersion(@RequestParam String tenantId, @RequestParam String envServiceId, @RequestParam Integer pageNum, @RequestParam(defaultValue="10") Integer pageSize) {
        if (StrUtil.isEmpty((CharSequence)envServiceId)) {
            return ResultBean.fail((Integer)-1, (String)"\u8bf7\u9009\u62e9\u4e91\u533a\uff01");
        }
        Pagination pagination = this.tenantService.queryTenantVersionByTenantId(tenantId, envServiceId, pageNum, pageSize);
        return ResultBean.success((Object)pagination);
    }

    @GetMapping(value={"appRelaTenantVersion"})
    public ResultBean<?> queryAppRelatenantVersion(@RequestParam String appCode, @RequestParam String env, @RequestParam Integer pageNum, @RequestParam(defaultValue="10") Integer pageSize) {
        if (StrUtil.isEmpty((CharSequence)appCode.trim())) {
            return ResultBean.fail((Integer)-1, (String)"\u8bf7\u8f93\u5165\u5e94\u7528\u4ee3\u53f7\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)env)) {
            return ResultBean.fail((Integer)-1, (String)"\u8bf7\u9009\u62e9\u73af\u5883\u4fe1\u606f\uff01");
        }
        Pagination pagination = this.tenantService.queryAppRelatenantVersion(appCode, env, pageNum, pageSize);
        return ResultBean.success((Object)pagination);
    }

    @GetMapping(value={"/{goodsCode}"})
    public ResultBean<?> getTenantByGoodsCode(@RequestHeader(value="token") String token, @PathVariable String goodsCode) {
        if (StrUtil.isEmpty((CharSequence)goodsCode)) {
            return ResultBean.fail((Integer)-1, (String)"\u8bf7\u8f93\u5165\u5e94\u7528id\uff01");
        }
        List tenantByGoodsCode = this.tenantService.getTenantByGoodsCode(token, goodsCode);
        return ResultBean.success((Object)tenantByGoodsCode);
    }

    @GetMapping(value={"/getIamIntegrationToken"})
    public ResultBean<String> getIamIntegrationToken(String tenantId) {
        return ResultBean.success((Object)this.iamApiHelper.getIamIntegrationToken(tenantId));
    }
}

