/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.controller;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployLogDao;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployTaskDao;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.domain.deploy.ParseCompileFileResult;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.digiwin.athena.athenadeployer.service.DeployServiceV4;
import com.digiwin.athena.athenadeployer.service.deployTask.AbstractDeployTaskNode;
import com.digiwin.athena.athenadeployer.service.deployTask.DeployTaskFactory;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/application"})
@RestController
public class TestController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private DeployTaskFactory deployTaskFactory;
    @Autowired
    private DeployServiceV4 deployServiceV4;
    private DeployLogDao deployLogDao;
    private DeployTaskDao deployTaskDao;

    @Autowired
    public void setDeployTaskDao(DeployTaskDao deployTaskDao) {
        this.deployTaskDao = deployTaskDao;
    }

    @Autowired
    public void setDeployLogDao(DeployLogDao deployLogDao) {
        this.deployLogDao = deployLogDao;
    }

    @GetMapping(value={"/testDeployTask"})
    public ResultBean<String> testDeployTask(String application, String type, String deployNo) {
        try {
            DeployTask deployTask = this.deployServiceV4.getTask(application, type, deployNo);
            AbstractDeployTaskNode deployNode = this.deployTaskFactory.getDeployNode(deployTask);
            deployNode.executeDeploy((Object)deployTask);
        }
        catch (Exception e) {
            log.error("testDeployTask error:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    @GetMapping(value={"/testSwitchTask"})
    public ResultBean<String> testSwitchTask(String application, String type, String deployNo) {
        try {
            DeployTask deployTask = this.deployServiceV4.getTask(application, type, deployNo);
            AbstractDeployTaskNode deployNode = this.deployTaskFactory.getDeployNode(deployTask);
            deployNode.executeSwitch((Object)deployTask);
        }
        catch (Exception e) {
            log.error("testSwitchTask error:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    @GetMapping(value={"/testCreateTask"})
    public ResultBean<String> testCreateTask(String application, String deployNo) {
        try {
            DeployLog deployLog = this.deployServiceV4.getDeployLog(application, deployNo);
            AbstractDeployTaskNode preDeployNode = this.deployTaskFactory.getDeployPreTaskNode();
            this.deployServiceV4.removeByDeployNoAndApplication(application, deployNo);
            if (EnvOperateEnum.PUBLISH.getOperate().equals(deployLog.getType())) {
                DeployParamV3 deployParam = deployLog.getDeployParam();
                ParseCompileFileResult parseCompileFileResult = this.deployServiceV4.parseFileData(deployNo, application, ((ApplicationData)deployParam.getApplicationDataList().get(0)).getCompileDataCode(), deployParam.getCompileData());
                this.deployTaskFactory.generateNewDeployTask(deployParam, parseCompileFileResult);
            } else {
                this.deployTaskFactory.generateNewSwitchTask(deployLog.getDeployParam());
            }
        }
        catch (Exception e) {
            log.error("testCreateTask error:" + e.getMessage(), (Throwable)e);
            return ResultBean.fail((Integer)-1, (String)e.getMessage());
        }
        return ResultBean.success();
    }

    @GetMapping(value={"/testAddDeployPlan"})
    public ResultBean<String> testAddDeployPlan() {
        String detailLog = "{\n    \"version\": \"1.0\",\n    \"application\": \"UC412e09bf-474\",\n    \"user\": {\n        \"sid\": \"622410015851072\",\n        \"userId\": \"diaoyh@digiwin.com\",\n        \"userName\": \"\u5201\u5b87\u822a\",\n        \"tenantSid\": 466712390951488,\n        \"tenantId\": \"athenaPaaSDesigner\",\n        \"tenantName\": \"\u914d\u7f6e\u8a2d\u8a08\u5668\u6e2c\u8a66\u79df\u6236\",\n        \"token\": \"5869a961-44b6-430c-91f5-0d4f5beea650\",\n        \"locale\": \"zh_CN\"\n    },\n    \"deployTenant\": \"athenaPaaSDesigner\",\n    \"type\": \"publish\",\n    \"allowCustomPublish\": true,\n    \"compileData\": {\n        \"code\": \"b524d517ccc046f0896ebf603669e7dd\",\n        \"versionNum\": [\n            \"0\",\n            \"0\",\n            \"0\",\n            \"2411131829\"\n        ],\n        \"allowCustomPublish\": true,\n        \"publishMode\": \"new\",\n        \"description\": \"20241113182947-\u5f00\u53d1\u5206\u652f\u7f16\u8bd1\",\n        \"compiledDataFileId\": \"b66398ec-6e28-41cf-93e6-aa45ff9a753e\",\n        \"branch\": \"develop\",\n        \"version\": \"0.0.0.2411131829_alpha\",\n        \"application\": \"A20240109084537-athenaPaaSDesigner\",\n        \"designDataFileId\": \"cff762a9-385e-4595-ae00-015243e0539e\",\n        \"appType\": 1,\n        \"versionLetter\": \"alpha\",\n        \"tenantId\": \"athenaPaaSDesigner\",\n        \"time\": \"2024-11-13 18:30:43\"\n    },\n    \"result\": \"fail\",\n    \"deployParam\": {\n        \n        \"applicationDataList\": [\n            {\n                \"application\": \"UC412e09bf-474\",\n                \"applicationInfoDto\": {\n    \"code\": \"UC412e09bf-474\",\n    \"name\": \"dyh-app2ab\",\n    \"description\": \"dyh-app2b\",\n    \"paramApi\": [],\n    \"tenantId\": \"athenaPaaSDesigner\",\n    \"appType\": 1,\n    \"iconName\": \"10.png\",\n    \"iconBgcolor\": \"#0189FF\",\n    \"commonApp\": false,\n    \"deleteOrder\": 0,\n    \"appTypes\": [\n        1\n    ],\n    \"gitProjectId\": \"\",\n    \"gitUrl\": \"\",\n    \"abandon\": 0,\n    \"individual\": true,\n    \"sourceApplicationCode\": \"A20240109084537-athenaPaaSDesigner\",\n    \"individualAll\": false,\n    \"belongTenantInfo\": {\n        \"tenantId\": \"string\",\n        \"tenantSid\": 0,\n        \"customId\": \"string\",\n        \"serviceId\": \"string\",\n        \"tenantName\": \"string\",\n        \"customerTenant\": true\n    },\n    \"useTenantInfos\": [\n        {\n            \"tenantId\": \"athenaPaaSDesigner\",\n            \"tenantSid\": 466712390951488,\n            \"customId\": \"01042\",\n            \"serviceId\": \"AliTest\",\n            \"serviceName\": \"\u5927\u9646PAAS\u533a\",\n            \"tenantName\": \"\u914d\u7f6e\u8a2d\u8a08\u5668\u6e2c\u8a66\u79df\u6236\",\n            \"customerTenant\": false\n        }\n    ],\n    \"lang\": {\n        \"description\": {\n            \"zh_CN\": \"dyh-app2b\",\n            \"zh_TW\": \"dyh-app2b\",\n            \"en_US\": \"dyh-app2b\"\n        }\n    }\n},\n                \"compileDataCode\": \"b524d517ccc046f0896ebf603669e7dd\"\n            }\n        ],\n        \"tenantUsers\": [\n            {\n                \"tenantId\": \"athenaPaaSDesigner\",\n                \"tenantSid\": 466712390951488,\n                \"option\": 1,\n                \"tenantName\": \"\u914d\u7f6e\u8a2d\u8a08\u5668\u6e2c\u8a66\u79df\u6236\"\n            }\n        ],\n        \"env\": \"AliTest-TEST\",\n        \"envServiceId\": \"AliTest\",\n        \"syncEsp\": false,\n        \"currentUser\": {\n            \"sid\": 622410015851072,\n            \"userId\": \"diaoyh@digiwin.com\",\n            \"userName\": \"\u5201\u5b87\u822a\",\n            \"tenantSid\": 466712390951488,\n            \"tenantId\": \"athenaPaaSDesigner\",\n            \"tenantName\": \"\u914d\u7f6e\u8a2d\u8a08\u5668\u6e2c\u8a66\u79df\u6236\",\n            \"token\": \"5869a961-44b6-430c-91f5-0d4f5beea650\",\n            \"locale\": \"zh_CN\"\n        },\n        \"publishMode\": \"new\"\n    }\n}";
        DeployLog deployLog = (DeployLog)JSONObject.parseObject((String)detailLog, DeployLog.class);
        String deployNo = IdUtil.fastSimpleUUID();
        deployLog.setDeployNo(deployNo);
        deployLog.getDeployParam().setId(deployNo);
        deployLog.setDate(new Date());
        this.deployLogDao.insert(deployLog);
        return ResultBean.success();
    }
}

