/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.dao.mongo;

import com.digiwin.athena.athenadeployer.domain.application.Application;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class ApplicationDao {
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;

    public List<Application> selectByApplicationListAndLatestEnv(Collection<String> applicationList, String env) {
        Criteria criteria = Criteria.where((String)"application").in(applicationList).and("latestEnv").is((Object)env);
        return this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public void updateStatueByApplicationAndLatestEnv(String application, String latestEnv, Integer status) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("latestEnv").is((Object)latestEnv);
        Update update = new Update();
        update.set("status", (Object)status);
        update.set("editDate", (Object)new Date());
        this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)criteria), (UpdateDefinition)update, "application");
    }

    public Application selectByApplicationAndLatestEnv(String application, String env) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("latestEnv").is((Object)env);
        return (Application)this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), Application.class);
    }

    public void insert(Application application) {
        this.mongoTemplate.insert((Object)application);
    }

    public void save(Application application) {
        this.mongoTemplate.save((Object)application);
    }

    public void remove(String application) {
        Criteria criteria = Criteria.where((String)"code").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, Application.class);
    }
}

