/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.dao.mongo;

import com.digiwin.athena.athenadeployer.domain.AssetDefinitionRecord;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class AssetDefinitionRecordDao {
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;

    public void deleteByApplicationAndEnv(String application, String env) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("env").is((Object)env);
        this.mongoTemplate.remove(new Query((CriteriaDefinition)criteria), AssetDefinitionRecord.class);
    }

    public Collection<String> selectByAssetIdAndEnv(List<String> assetIds, String env) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds).and("env").is((Object)env);
        return this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), AssetDefinitionRecord.class).stream().map(AssetDefinitionRecord::getAssetId).collect(Collectors.toSet());
    }

    public void insertAll(List<AssetDefinitionRecord> assetDefinitionRecordList) {
        this.mongoTemplate.insertAll(assetDefinitionRecordList);
    }
}

