/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.dao.mongo;

import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DeployDetailV2Dao {
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;

    public void insertAll(List<DeployDetailV2> detailList) {
        this.mongoTemplate.insertAll(detailList);
    }

    public void insert(DeployDetailV2 detail) {
        this.mongoTemplate.insert((Object)detail);
    }

    public DeployDetailV2 selectOneByApplicationAndDeployNoAndContent(String application, String deployNo, String content) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo).and("content").is((Object)content);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"time"})).limit(1);
        return (DeployDetailV2)this.mongoTemplate.findOne(query, DeployDetailV2.class);
    }

    public void deleteByDeployNo(String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, DeployDetailV2.class);
    }

    public List<DeployDetailV2> selectByApplicationAndDeployNoOrderAscTime(String deployNo, String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"time"})).limit(1);
        return this.mongoTemplate.find(query, DeployDetailV2.class);
    }

    public void removeByLtTime(Date date) {
        Criteria criteria = Criteria.where((String)"time").lte((Object)date);
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, DeployDetailV2.class);
    }
}

