/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.dao.mongo;

import com.digiwin.athena.athenadeployer.domain.DeployLog;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class DeployLogDao {
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;

    public DeployLog findLastPublishLog(String type, String env, String application) {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date"});
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"type").is((Object)type).and("deployParam.env").is((Object)env).and("application").is((Object)application));
        query.with(sort);
        query.limit(1);
        DeployLog deployLog = (DeployLog)this.mongoTemplate.findOne(query, DeployLog.class, "deployLog");
        return deployLog;
    }

    public List<DeployLog> selectByTypeAndResult(String type, String result) {
        Criteria criteria = Criteria.where((String)"type").is((Object)type).and("result").is((Object)result);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, DeployLog.class);
    }

    public List<DeployLog> selectByIds(List<String> ids) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        return this.mongoTemplate.find(query, DeployLog.class);
    }

    public void updateResultByIds(List<String> ids, String result) {
        Criteria criteria = Criteria.where((String)"_id").in(ids);
        Update update = Update.update((String)"result", (Object)result).set("date", (Object)new Date());
        this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)criteria), (UpdateDefinition)update, DeployLog.class);
    }

    public List<DeployLog> selectByIdsAndResult(List<String> ids, String result) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(ids).and("result").is((Object)result));
        return this.mongoTemplate.find(query, DeployLog.class);
    }

    public List<String> selectApplicationByApplicationAndStatusAndEnvAndType(Collection<String> applicationList, List<String> status, String env, EnvOperateEnum type) {
        Criteria criteria = Criteria.where((String)"result").in(status).and("application").in(applicationList).and("deployParam.env").is((Object)env).and("type").is((Object)type.getOperate());
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("application");
        return this.mongoTemplate.find(query, DeployLog.class).stream().map(DeployLog::getApplication).collect(Collectors.toList());
    }

    public void insert(DeployLog deployLog) {
        this.mongoTemplate.insert((Object)deployLog);
    }

    public List<DeployLog> selectByResult(String result) {
        Criteria criteria = Criteria.where((String)"result").is((Object)result);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"date"}));
        return this.mongoTemplate.find(query, DeployLog.class);
    }

    public DeployLog selectByApplicationAndDeployNo(String application, String deployNo) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo);
        Query query = new Query((CriteriaDefinition)criteria);
        return (DeployLog)this.mongoTemplate.findOne(query, DeployLog.class);
    }

    public void save(DeployLog deployLog) {
        this.mongoTemplate.save((Object)deployLog);
    }

    public DeployLog selectRecentOneByDeployParamEnvAndTypeAndApplicationAndResult(String application, String deployDbMapEnv) {
        Criteria criteria = Criteria.where((String)"deployParam.env").is((Object)deployDbMapEnv).and("type").is((Object)EnvOperateEnum.PUBLISH.getOperate()).and("application").is((Object)application).and("result").is((Object)"success");
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date"}));
        query.limit(1);
        return (DeployLog)this.mongoTemplate.findOne(query, DeployLog.class);
    }

    public void updateProcessByApplicationAndId(String application, String deployNo, BigDecimal progress) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo));
        Update update = new Update();
        update.set("process", (Object)progress);
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, DeployLog.class);
    }

    public List<DeployLog> selectByResultsAndDeployMode(List<String> resultList, String modeType) {
        Criteria criteria = Criteria.where((String)"result").in(resultList).and("deployParam.publishMode").is((Object)modeType);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, DeployLog.class);
    }

    public List<DeployLog> selectByTypeAndResultAndOldPublishMode(String type, String result) {
        Criteria criteria = Criteria.where((String)"type").is((Object)type).and("result").is((Object)result).and("deployParam.publishMode").ne((Object)"new");
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, DeployLog.class);
    }

    public List<String> getDeployByApplication(String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("result").is((Object)"success").and("type").is((Object)"publish");
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("deployParam.env");
        List result = this.mongoTemplate.findDistinct(query, "deployParam.env", DeployLog.class, String.class);
        return result;
    }

    public DeployLog getDeployByApplicationLimit(String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("result").is((Object)"success").and("type").is((Object)"publish");
        Query query = new Query((CriteriaDefinition)criteria).limit(1);
        return (DeployLog)this.mongoTemplate.findOne(query, DeployLog.class);
    }

    public DeployLog getDeployByApplicationFormalZone(String application, List<String> zoneList) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("result").is((Object)"success").and("type").is((Object)"publish").and("deployParam.env").in(zoneList);
        Query query = new Query((CriteriaDefinition)criteria).limit(1);
        return (DeployLog)this.mongoTemplate.findOne(query, DeployLog.class);
    }

    public void deleteDeployRecordByApplication(String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, DeployLog.class);
    }

    public List<DeployLog> selectRecentByType(String type, Integer limit) {
        Criteria criteria = Criteria.where((String)"type").is((Object)type);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("application");
        fields.include("deployNo");
        fields.include("result");
        fields.include("deployTenant");
        fields.include("date");
        query.limit(limit.intValue());
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoTemplate.find(query, DeployLog.class);
    }

    public Collection<String> selectDeployServiceIdByApplication(String appCode) {
        Criteria criteria = Criteria.where((String)"application").is((Object)appCode);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("deployParam.envServiceId");
        List deployLogs = this.mongoTemplate.find(query, DeployLog.class);
        return deployLogs.stream().filter(d -> d.getDeployParam() != null).map(d -> d.getDeployParam().getEnvServiceId()).collect(Collectors.toSet());
    }

    public List<DeployLog> selectByApplicationsAndEnv(Collection<String> individualApps, String env) {
        Criteria criteria = Criteria.where((String)"application").in(individualApps).and("deployParam.env").is((Object)env);
        return this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), DeployLog.class);
    }
}

