/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.dao.mongo;

import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamRecord;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DeployParamRecordDao {
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;

    public void insert(DeployParamRecord deployParamRecord) {
        this.mongoTemplate.insert((Object)deployParamRecord);
    }

    public void removeByApplicationAndEnvAndType(String appCode, String env, String type) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)appCode).and("env").is((Object)env).and("type").is((Object)type));
        this.mongoTemplate.remove(query, DeployParamRecord.class);
    }

    public List<DeployParamRecord> selectByApplicationAndEnvAndType(String application, String env, String type) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("env").is((Object)env).and("type").is((Object)type);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, DeployParamRecord.class);
    }

    public List<DeployParamRecord> selectByApplicationAndEnvAndTypeAndStatus(String application, String env, String type, String status) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("env").is((Object)env).and("type").is((Object)type).and("status").is((Object)status);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, DeployParamRecord.class);
    }

    public void save(DeployParamRecord deployParamRecords) {
        this.mongoTemplate.save((Object)deployParamRecords);
    }

    public void removeByApplicationAndEnvAndTypeList(String appCode, String env, List<String> typeList) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)appCode).and("env").is((Object)env).and("type").in(typeList));
        this.mongoTemplate.remove(query, DeployParamRecord.class);
    }

    public void removeByApplication(String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, DeployParamRecord.class);
    }

    public DeployParamRecord selectOneByApplicationAndEnvAndType(String application, String env, String type) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("env").is((Object)env).and("type").is((Object)type));
        return (DeployParamRecord)this.mongoTemplate.findOne(query, DeployParamRecord.class);
    }
}

