/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.dao.mongo;

import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployServiceInfo;
import com.digiwin.athena.athenadeployer.domain.deploy.pipline.FriendlyLink;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class DeployServiceInfoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployServiceInfoDao.class);
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;

    public DeployServiceInfo insert(DeployServiceInfo deployServiceInfo) {
        String userId = AthenaUserLocal.getUser().getUserId();
        deployServiceInfo.setCreateBy(userId).setCreateDate(new Date()).setEditBy(userId).setEditDate(new Date());
        deployServiceInfo.setObjectId(null);
        return (DeployServiceInfo)this.mongoTemplate.insert((Object)deployServiceInfo);
    }

    public List<DeployServiceInfo> queryAllDeployServiceInfo() {
        return this.mongoTemplate.find(new Query(), DeployServiceInfo.class);
    }

    public DeployServiceInfo queryDeployServiceInfoByServiceId(String serviceId) {
        Criteria criteria = Criteria.where((String)"serviceId").is((Object)serviceId);
        return (DeployServiceInfo)this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), DeployServiceInfo.class);
    }

    public Map<String, List<FriendlyLink>> queryAllDeployServiceIdAndFriendlyLinkList() {
        List deployServiceInfos = this.mongoTemplate.find(new Query(), DeployServiceInfo.class);
        return deployServiceInfos.stream().collect(Collectors.toMap(DeployServiceInfo::getServiceId, DeployServiceInfo::getFriendlyLinkList));
    }

    public List<DeployServiceInfo> queryBriefDeployServiceInfo() {
        Query query = new Query();
        query.fields().include("serviceId").include("serviceName").include("friendlyLinkList").include("lang").include("sameArea");
        return this.mongoTemplate.find(query, DeployServiceInfo.class);
    }

    public List<DeployServiceInfo> querySameAreaDeployServiceInfo() {
        Criteria criteria = Criteria.where((String)"sameArea").is((Object)true);
        return this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), DeployServiceInfo.class);
    }

    public DeployServiceInfo update(DeployServiceInfo deployServiceInfo) {
        String userId = AthenaUserLocal.getUser().getUserId();
        deployServiceInfo.setEditBy(userId).setEditDate(new Date());
        return (DeployServiceInfo)this.mongoTemplate.save((Object)deployServiceInfo);
    }

    public void updateSameAreaByServiceId(String serviceId, Boolean sameArea) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"serviceId").is((Object)serviceId));
        Update update = new Update();
        update.set("sameArea", (Object)sameArea);
        update.set("editBy", (Object)AthenaUserLocal.getUser().getUserId());
        update.set("editDate", (Object)new Date());
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, "deployServiceInfo");
    }

    public void delete(String serviceId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"serviceId").is((Object)serviceId));
        this.mongoTemplate.remove(query, DeployServiceInfo.class);
    }

    public DeployServiceInfo getSameAreaInfo() {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"sameArea").is((Object)true));
        return (DeployServiceInfo)this.mongoTemplate.findOne(query, DeployServiceInfo.class);
    }
}

