/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.dao.mongo;

import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.DeployTaskTypeEnum;
import com.digiwin.athena.athenadeployer.service.deployTask.enumerate.SwitchTaskTypeEnum;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DeployTaskDao {
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;

    public void batchInsert(List<DeployTask> deployTasks) {
        this.mongoTemplate.insertAll(deployTasks);
    }

    public Long selectCountByApplicationAndDeployNo(String application, String deployNo) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoTemplate.count(query, DeployTask.class);
    }

    public DeployTask selectFirstOneByApplicationAndDeployNoAndStatus(String application, String deployNo, List<String> statusList) {
        Criteria criteria = Criteria.where((String)"status").in(statusList).and("application").is((Object)application).and("deployNo").is((Object)deployNo);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"order"}));
        query.limit(1);
        return (DeployTask)this.mongoTemplate.findOne(query, DeployTask.class);
    }

    public void removeByDeployNoAndApplication(String application, String deployNo) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo);
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, DeployTask.class);
    }

    public void save(DeployTask task) {
        this.mongoTemplate.save((Object)task);
    }

    public Long selectCountByApplicationAndDeployNoAndStatus(String application, String deployNo, List<String> statusList) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo).and("status").in(statusList);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoTemplate.count(query, DeployTask.class);
    }

    public DeployTask selectLastPublishByApplicationAndTypeAndEnv(String application, DeployTaskTypeEnum deployType, String env) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("type").is((Object)deployType.getType()).and("env").is((Object)env);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"}));
        query.limit(1);
        return (DeployTask)this.mongoTemplate.findOne(query, DeployTask.class);
    }

    public DeployTask selectLastOneByApplicationAndDeployNo(String application, String deployNo) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"order"}));
        query.limit(1);
        return (DeployTask)this.mongoTemplate.findOne(query, DeployTask.class);
    }

    public DeployTask selectDeployDataPublishTaskByApplicationAndDeployNo(String application, String deployLogId) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployLogId).and("type").is((Object)DeployTaskTypeEnum.KM_DATA_PUBLISH.getType());
        return (DeployTask)this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), DeployTask.class);
    }

    public DeployTask selectSwitchDataPublishTaskByApplicationAndDeployNo(String application, String deployLogId) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployLogId).and("type").is((Object)SwitchTaskTypeEnum.KM_DATA_SWITCH.getType());
        return (DeployTask)this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), DeployTask.class);
    }

    public void insert(DeployTask task) {
        this.mongoTemplate.insert((Object)task);
    }

    public DeployTask selectByApplicationAndDeployNoAndType(String application, String deployNo, String type) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo).and("type").is((Object)type);
        return (DeployTask)this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), DeployTask.class);
    }

    public void removeByApplication(String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, DeployTask.class);
    }

    public List<DeployTask> selectByApplicationAndDeployNoAscOrder(String deployNo, String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"order"}));
        return this.mongoTemplate.find(query, DeployTask.class);
    }

    public List<DeployTask> selectBetweenCreateDate(Date begin, Date end, Pageable pageRequest) {
        Criteria criteria = Criteria.where((String)"createDate").gte((Object)begin).lte((Object)end);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(pageRequest);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoTemplate.find(query, DeployTask.class);
    }

    public void removeByLtCreateDate(Date createDate) {
        Criteria criteria = Criteria.where((String)"createDate").lte((Object)createDate);
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, DeployTask.class);
    }

    public List<DeployTask> selectByStatus(String status) {
        Criteria criteria = Criteria.where((String)"status").is((Object)status);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, DeployTask.class);
    }
}

