/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.dao.mongo;

import com.digiwin.athena.athenadeployer.domain.deploy.MulVersion;
import jakarta.annotation.Resource;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class MulVersionDao {
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;

    public MulVersion selectByApplicationAndAdpVersion(String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        return (MulVersion)this.mongoTemplate.findOne(query, MulVersion.class);
    }

    public void insert(MulVersion mulVersion) {
        this.mongoTemplate.insert((Object)mulVersion);
    }

    public void updateAdpVersion(MulVersion mulVersion) {
        Criteria criteria = Criteria.where((String)"application").is((Object)mulVersion.getApplication());
        Update update = new Update();
        update.set("adpVersion", (Object)mulVersion.getAdpVersion());
        this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)criteria), (UpdateDefinition)update, "mulVersion");
    }
}

