/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.domain;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.application.ApplicationConfig;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV3;
import com.digiwin.athena.athenadeployer.enums.EnvOperateEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.springframework.data.annotation.Id;

public class DeployLog {
    public static final String PUBLISH_LOG_TYPE = "publish";
    public static final String SWITCH_LOG_TYPE = "switch";
    @Id
    private String id;
    private String version;
    private String application;
    private List<String> tenantIdList;
    private AthenaUser user;
    private String deployTenant;
    private String type;
    private Boolean allowCustomPublish;
    private JSONObject compileData;
    private String deployNo;
    private String result;
    private String applicationName;
    private JSONObject applicationNameLang;
    @JsonFormat(locale="zh", timezone="Asia/Shanghai", pattern="yyyy-MM-dd HH:mm:ss")
    private Date date;
    private String envName;
    private DeployParamV3 deployParam;
    private BigDecimal process;
    private ApplicationConfig applicationConfig;
    private Boolean individual = false;

    public static DeployLog create(String application, JSONObject compiledData, String deployNo, String result, DeployParamV3 deployerParam, EnvOperateEnum operateEnum, ApplicationConfig applicationConfig) {
        DeployLog deployLog = new DeployLog();
        deployLog.setApplication(application).setVersion(operateEnum.getVersion()).setUser(AthenaUserLocal.getUser()).setType(operateEnum.getOperate()).setCompileData(compiledData).setDeployNo(deployNo).setResult(result).setAllowCustomPublish(compiledData.getBoolean("allowCustomPublish")).setDeployTenant(AthenaUserLocal.getUser().getTenantId()).setDate(new Date()).setDeployParam(deployerParam).setApplicationConfig(applicationConfig);
        return deployLog;
    }

    @Generated
    public DeployLog() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public List<String> getTenantIdList() {
        return this.tenantIdList;
    }

    @Generated
    public AthenaUser getUser() {
        return this.user;
    }

    @Generated
    public String getDeployTenant() {
        return this.deployTenant;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Boolean getAllowCustomPublish() {
        return this.allowCustomPublish;
    }

    @Generated
    public JSONObject getCompileData() {
        return this.compileData;
    }

    @Generated
    public String getDeployNo() {
        return this.deployNo;
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public JSONObject getApplicationNameLang() {
        return this.applicationNameLang;
    }

    @Generated
    public Date getDate() {
        return this.date;
    }

    @Generated
    public String getEnvName() {
        return this.envName;
    }

    @Generated
    public DeployParamV3 getDeployParam() {
        return this.deployParam;
    }

    @Generated
    public BigDecimal getProcess() {
        return this.process;
    }

    @Generated
    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    @Generated
    public Boolean getIndividual() {
        return this.individual;
    }

    @Generated
    public DeployLog setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public DeployLog setVersion(String version) {
        this.version = version;
        return this;
    }

    @Generated
    public DeployLog setApplication(String application) {
        this.application = application;
        return this;
    }

    @Generated
    public DeployLog setTenantIdList(List<String> tenantIdList) {
        this.tenantIdList = tenantIdList;
        return this;
    }

    @Generated
    public DeployLog setUser(AthenaUser user) {
        this.user = user;
        return this;
    }

    @Generated
    public DeployLog setDeployTenant(String deployTenant) {
        this.deployTenant = deployTenant;
        return this;
    }

    @Generated
    public DeployLog setType(String type) {
        this.type = type;
        return this;
    }

    @Generated
    public DeployLog setAllowCustomPublish(Boolean allowCustomPublish) {
        this.allowCustomPublish = allowCustomPublish;
        return this;
    }

    @Generated
    public DeployLog setCompileData(JSONObject compileData) {
        this.compileData = compileData;
        return this;
    }

    @Generated
    public DeployLog setDeployNo(String deployNo) {
        this.deployNo = deployNo;
        return this;
    }

    @Generated
    public DeployLog setResult(String result) {
        this.result = result;
        return this;
    }

    @Generated
    public DeployLog setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    @Generated
    public DeployLog setApplicationNameLang(JSONObject applicationNameLang) {
        this.applicationNameLang = applicationNameLang;
        return this;
    }

    @JsonFormat(locale="zh", timezone="Asia/Shanghai", pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public DeployLog setDate(Date date) {
        this.date = date;
        return this;
    }

    @Generated
    public DeployLog setEnvName(String envName) {
        this.envName = envName;
        return this;
    }

    @Generated
    public DeployLog setDeployParam(DeployParamV3 deployParam) {
        this.deployParam = deployParam;
        return this;
    }

    @Generated
    public DeployLog setProcess(BigDecimal process) {
        this.process = process;
        return this;
    }

    @Generated
    public DeployLog setApplicationConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
        return this;
    }

    @Generated
    public DeployLog setIndividual(Boolean individual) {
        this.individual = individual;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployLog)) {
            return false;
        }
        DeployLog other = (DeployLog)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$allowCustomPublish = this.getAllowCustomPublish();
        Boolean other$allowCustomPublish = other.getAllowCustomPublish();
        if (this$allowCustomPublish == null ? other$allowCustomPublish != null : !((Object)this$allowCustomPublish).equals(other$allowCustomPublish)) {
            return false;
        }
        Boolean this$individual = this.getIndividual();
        Boolean other$individual = other.getIndividual();
        if (this$individual == null ? other$individual != null : !((Object)this$individual).equals(other$individual)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        List this$tenantIdList = this.getTenantIdList();
        List other$tenantIdList = other.getTenantIdList();
        if (this$tenantIdList == null ? other$tenantIdList != null : !((Object)this$tenantIdList).equals(other$tenantIdList)) {
            return false;
        }
        AthenaUser this$user = this.getUser();
        AthenaUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$deployTenant = this.getDeployTenant();
        String other$deployTenant = other.getDeployTenant();
        if (this$deployTenant == null ? other$deployTenant != null : !this$deployTenant.equals(other$deployTenant)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        JSONObject this$compileData = this.getCompileData();
        JSONObject other$compileData = other.getCompileData();
        if (this$compileData == null ? other$compileData != null : !this$compileData.equals(other$compileData)) {
            return false;
        }
        String this$deployNo = this.getDeployNo();
        String other$deployNo = other.getDeployNo();
        if (this$deployNo == null ? other$deployNo != null : !this$deployNo.equals(other$deployNo)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        JSONObject this$applicationNameLang = this.getApplicationNameLang();
        JSONObject other$applicationNameLang = other.getApplicationNameLang();
        if (this$applicationNameLang == null ? other$applicationNameLang != null : !this$applicationNameLang.equals(other$applicationNameLang)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$envName = this.getEnvName();
        String other$envName = other.getEnvName();
        if (this$envName == null ? other$envName != null : !this$envName.equals(other$envName)) {
            return false;
        }
        DeployParamV3 this$deployParam = this.getDeployParam();
        DeployParamV3 other$deployParam = other.getDeployParam();
        if (this$deployParam == null ? other$deployParam != null : !this$deployParam.equals(other$deployParam)) {
            return false;
        }
        BigDecimal this$process = this.getProcess();
        BigDecimal other$process = other.getProcess();
        if (this$process == null ? other$process != null : !((Object)this$process).equals(other$process)) {
            return false;
        }
        ApplicationConfig this$applicationConfig = this.getApplicationConfig();
        ApplicationConfig other$applicationConfig = other.getApplicationConfig();
        return !(this$applicationConfig == null ? other$applicationConfig != null : !this$applicationConfig.equals(other$applicationConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeployLog;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowCustomPublish = this.getAllowCustomPublish();
        result = result * 59 + ($allowCustomPublish == null ? 43 : ((Object)$allowCustomPublish).hashCode());
        Boolean $individual = this.getIndividual();
        result = result * 59 + ($individual == null ? 43 : ((Object)$individual).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        List $tenantIdList = this.getTenantIdList();
        result = result * 59 + ($tenantIdList == null ? 43 : ((Object)$tenantIdList).hashCode());
        AthenaUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $deployTenant = this.getDeployTenant();
        result = result * 59 + ($deployTenant == null ? 43 : $deployTenant.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        JSONObject $compileData = this.getCompileData();
        result = result * 59 + ($compileData == null ? 43 : $compileData.hashCode());
        String $deployNo = this.getDeployNo();
        result = result * 59 + ($deployNo == null ? 43 : $deployNo.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        JSONObject $applicationNameLang = this.getApplicationNameLang();
        result = result * 59 + ($applicationNameLang == null ? 43 : $applicationNameLang.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $envName = this.getEnvName();
        result = result * 59 + ($envName == null ? 43 : $envName.hashCode());
        DeployParamV3 $deployParam = this.getDeployParam();
        result = result * 59 + ($deployParam == null ? 43 : $deployParam.hashCode());
        BigDecimal $process = this.getProcess();
        result = result * 59 + ($process == null ? 43 : ((Object)$process).hashCode());
        ApplicationConfig $applicationConfig = this.getApplicationConfig();
        result = result * 59 + ($applicationConfig == null ? 43 : $applicationConfig.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeployLog(id=" + this.getId() + ", version=" + this.getVersion() + ", application=" + this.getApplication() + ", tenantIdList=" + String.valueOf(this.getTenantIdList()) + ", user=" + String.valueOf(this.getUser()) + ", deployTenant=" + this.getDeployTenant() + ", type=" + this.getType() + ", allowCustomPublish=" + this.getAllowCustomPublish() + ", compileData=" + String.valueOf(this.getCompileData()) + ", deployNo=" + this.getDeployNo() + ", result=" + this.getResult() + ", applicationName=" + this.getApplicationName() + ", applicationNameLang=" + String.valueOf(this.getApplicationNameLang()) + ", date=" + String.valueOf(this.getDate()) + ", envName=" + this.getEnvName() + ", deployParam=" + String.valueOf(this.getDeployParam()) + ", process=" + String.valueOf(this.getProcess()) + ", applicationConfig=" + String.valueOf(this.getApplicationConfig()) + ", individual=" + this.getIndividual() + ")";
    }
}

