/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.http;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.athenadeployer.config.ModuleConfig;
import com.digiwin.athena.athenadeployer.constant.PreLoadData;
import com.digiwin.athena.athenadeployer.domain.ApplicationData;
import com.digiwin.athena.athenadeployer.domain.AthenaUser;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.Cql;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.dataView.DataViewViewInfo;
import com.digiwin.athena.athenadeployer.domain.dataView.ViewInfo;
import com.digiwin.athena.athenadeployer.domain.deploy.AdTemplatePublishParam;
import com.digiwin.athena.athenadeployer.domain.deploy.Application2CommonRelationParam;
import com.digiwin.athena.athenadeployer.domain.deploy.ApplicationCopyParam;
import com.digiwin.athena.athenadeployer.domain.deploy.CleanMongoParam;
import com.digiwin.athena.athenadeployer.domain.deploy.CleanNeo4jParam;
import com.digiwin.athena.athenadeployer.domain.deploy.CreateApplicationRelationParam;
import com.digiwin.athena.athenadeployer.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployParamV2;
import com.digiwin.athena.athenadeployer.domain.deploy.ExecuteBsonParam;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.domain.deploy.IamAddPolicyParam;
import com.digiwin.athena.athenadeployer.domain.deploy.IamAssignmentAuthorizeParam;
import com.digiwin.athena.athenadeployer.domain.deploy.KmDeploySwitchParam;
import com.digiwin.athena.athenadeployer.domain.deploy.LcdpPublishParam;
import com.digiwin.athena.athenadeployer.domain.deploy.PublishDataEntryAndModelDataParam;
import com.digiwin.athena.athenadeployer.domain.deploy.PublishSyncDataParam;
import com.digiwin.athena.athenadeployer.domain.deploy.Relation;
import com.digiwin.athena.athenadeployer.domain.deploy.Tenant2NodeRelationParam;
import com.digiwin.athena.athenadeployer.domain.deploy.WriteData2DbParam;
import com.digiwin.athena.athenadeployer.domain.tenant.TenantUserResult;
import com.digiwin.athena.athenadeployer.dto.deployer.KmDeployCleanApp;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.service.deployTask.MessageCenterTask;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class BackendApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackendApiHelper.class);
    @Value(value="${designer.domain}")
    private String designerDomain;
    @Value(value="${access.timeout:120000}")
    private Integer timeoutNum;
    @Resource(name="httpRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private PreLoadData preLoadData;
    @Resource
    private DesignerApiHelper designerApiHelper;

    public String initEnv(String env) {
        return this.moduleConfig.getDeployerService().getDomain();
    }

    public JSONObject deploy(String application, String compileVersion, String currentVersion, String deployVersion, Boolean copyOtherApplication, AthenaUser currentUser, String env) {
        String backendDomain = this.initEnv(env);
        String deployApiUrl = backendDomain + "/athena-deployer-service/deploy";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("application", application);
        param.put("compileVersion", compileVersion);
        param.put("currentVersion", currentVersion);
        param.put("deployVersion", deployVersion);
        param.put("copyOtherApplication", copyOtherApplication);
        param.put("currentUser", currentUser);
        String response = ((HttpRequest)HttpUtil.createPost((String)deployApiUrl).body(JSON.toJSONString(param)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        return responseObj;
    }

    public void monitorChange(List<TenantUser> tenantUsers, String application, String env, String changeType, String beginOrEnd, String version) {
        String backendDomain = this.initEnv(env);
        String deployApiUrl = backendDomain + "/athena-deployer-service/km/monitorChange";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appCode", application);
        param.put("version", version);
        param.put("type", changeType);
        param.put("objectType", "monitorRule");
        param.put("timeOn", beginOrEnd);
        for (TenantUser tenantUser : tenantUsers) {
            param.put("tenantId", tenantUser.getTenantId());
            ((HttpRequest)HttpUtil.createPost((String)deployApiUrl).body(JSON.toJSONString(param)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        }
    }

    public JSONObject addApplicationVersion(String deployVersion, String currentVersion, String env) {
        String backendDomain = this.initEnv(env);
        Object addApplicationVersionUrl = backendDomain + "/athena-deployer-service/deploy/addApplicationVersion?deployVersion={}&currentVersion={}";
        addApplicationVersionUrl = StrUtil.format((CharSequence)addApplicationVersionUrl, (Object[])new Object[]{deployVersion, currentVersion});
        String response = ((HttpRequest)HttpUtil.createGet((String)addApplicationVersionUrl).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        return responseObj;
    }

    public JSONObject writeData2Db(WriteData2DbParam writeData2DbParam, String env) {
        String backendDomain = this.initEnv(env);
        String writeData2DbApiUrl = backendDomain + "/athena-deployer-service/deploy/writeData2Db";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("application", writeData2DbParam.getApplication());
        param.put("compileVersion", writeData2DbParam.getCompileVersion());
        param.put("currentVersion", writeData2DbParam.getCurrentVersion());
        param.put("deployVersion", writeData2DbParam.getDeployVersion());
        param.put("currentUser", writeData2DbParam.getCurrentUser());
        param.put("compiledData", writeData2DbParam.getCompiledData());
        param.put("tenantUsers", writeData2DbParam.getTenantUsers());
        param.put("appToken", writeData2DbParam.getAppToken());
        param.put("pageDesignList", writeData2DbParam.getPageDesignList());
        param.put("env", env);
        String response = ((HttpRequest)HttpUtil.createPost((String)writeData2DbApiUrl).body(JSON.toJSONString(param)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        return responseObj;
    }

    public JSONObject addReportPolicy(WriteData2DbParam writeData2DbParam, String env) {
        String backendDomain = this.initEnv(env);
        String writeData2DbApiUrl = backendDomain + "/athena-deployer-service/deploy/addReportPolicy";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("application", writeData2DbParam.getApplication());
        param.put("compileVersion", writeData2DbParam.getCompileVersion());
        param.put("currentVersion", writeData2DbParam.getCurrentVersion());
        param.put("deployVersion", writeData2DbParam.getDeployVersion());
        param.put("currentUser", writeData2DbParam.getCurrentUser());
        param.put("compiledData", writeData2DbParam.getCompiledData());
        param.put("tenantUsers", writeData2DbParam.getTenantUsers());
        param.put("appToken", writeData2DbParam.getAppToken());
        param.put("pageDesignList", writeData2DbParam.getPageDesignList());
        param.put("env", env);
        String response = ((HttpRequest)HttpUtil.createPost((String)writeData2DbApiUrl).body(JSON.toJSONString(param)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        return responseObj;
    }

    public JSONObject updateDataVersion(String oldVersion, String newVersion, String env) {
        String backendDomain = this.initEnv(env);
        Object updateDataVersionApiUrl = backendDomain + "/athena-deployer-service/deploy/updateDataVersion?oldVersion={}&newVersion={}";
        updateDataVersionApiUrl = StrUtil.format((CharSequence)updateDataVersionApiUrl, (Object[])new Object[]{oldVersion, newVersion});
        String response = ((HttpRequest)HttpUtil.createGet((String)updateDataVersionApiUrl).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        return responseObj;
    }

    public JSONObject switchVersion(List<String> tenantIdList, String application, String version, String env, Boolean commonApp) {
        String backendDomain = this.initEnv(env);
        String switchVersionApiUrl = backendDomain + "/athena-deployer-service/deploy/switchVersion";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantIdList", tenantIdList);
        param.put("version", version);
        param.put("application", application);
        param.put("commonApp", commonApp);
        String response = ((HttpRequest)HttpUtil.createPost((String)switchVersionApiUrl).body(JSON.toJSONString(param)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj;
    }

    public void copyApplication(ApplicationCopyParam applicationCopyParam, String env) {
        String backendDomain = this.initEnv(env);
        String copyApiUrl = backendDomain + "/athena-deployer-service/application/copy";
        String response = ((HttpRequest)HttpUtil.createPost((String)copyApiUrl).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)applicationCopyParam)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public JSONObject updateApplicationVersion(String application, String oldVersion, String newVersion, String env) {
        String backendDomain = this.initEnv(env);
        String updateDataVersionApiUrl = backendDomain + "/athena-deployer-service/application/updateVersion";
        JSONObject param = new JSONObject();
        param.put("applicationList", (Object)ListUtil.toList((Object[])new String[]{application}));
        param.put("oldVersion", (Object)oldVersion);
        param.put("newVersion", (Object)newVersion);
        String response = ((HttpRequest)HttpUtil.createPost((String)updateDataVersionApiUrl).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)param)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj;
    }

    public List<Cql> getUpdateAppDataVersionCqlList(String application, String oldVersion, String newVersion, List<String> tenantIdList, String env, List<JSONObject> publishDbMongoData) {
        String backendDomain = this.initEnv(env);
        String updateDataVersionApiUrl = backendDomain + "/athena-deployer-service/application/getUpdateVersionCqlList";
        JSONObject param = new JSONObject();
        param.put("application", (Object)application);
        param.put("oldVersion", (Object)oldVersion);
        param.put("newVersion", (Object)newVersion);
        param.put("tenantIdList", tenantIdList);
        param.put("publishDbMongoData", publishDbMongoData);
        String response = ((HttpRequest)HttpUtil.createPost((String)updateDataVersionApiUrl).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)param)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        List cqlList = responseObj.getJSONArray("data").toJavaList(Cql.class);
        return cqlList;
    }

    public JSONObject updateCommonVersion(String oldVersion, String newVersion, String env) {
        String backendDomain = this.initEnv(env);
        String updateDataVersionApiUrl = backendDomain + "/athena-deployer-service/commonData/updateVersion";
        JSONObject param = new JSONObject();
        param.put("applicationList", (Object)ListUtil.toList((Object[])new String[]{"common", "espCommon"}));
        param.put("oldVersion", (Object)oldVersion);
        param.put("newVersion", (Object)newVersion);
        String response = ((HttpRequest)HttpUtil.createPost((String)updateDataVersionApiUrl).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)param)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj;
    }

    public List<Cql> getUpdateCommonDataVersionCqlList(String oldVersion, String newVersion, String env) {
        String backendDomain = this.initEnv(env);
        String updateDataVersionApiUrl = backendDomain + "/athena-deployer-service/commonData/getUpdateVersionCqlList";
        JSONObject param = new JSONObject();
        param.put("applicationList", (Object)ListUtil.toList((Object[])new String[]{"common", "espCommon"}));
        param.put("oldVersion", (Object)oldVersion);
        param.put("newVersion", (Object)newVersion);
        String response = ((HttpRequest)HttpUtil.createPost((String)updateDataVersionApiUrl).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)param)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        List cqlList = responseObj.getJSONArray("data").toJavaList(Cql.class);
        return cqlList;
    }

    public List<Relation> findApplication2CommonRelations(Application2CommonRelationParam findApplication2CommonParam, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/commonData/findApplication2CommonRelations";
        String response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)findApplication2CommonParam)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        List application2CommonRelations = responseObj.getJSONArray("data").toJavaList(Relation.class);
        return application2CommonRelations;
    }

    public List<Relation> findSpecialApplication2CommonRelations(Application2CommonRelationParam findApplication2CommonParam, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/commonData/findSpecialApplication2CommonRelations";
        String response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)findApplication2CommonParam)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        List application2CommonRelations = responseObj.getJSONArray("data").toJavaList(Relation.class);
        return application2CommonRelations;
    }

    public void deleteApplication2CommonRelations(Application2CommonRelationParam application2CommonRelationParam, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/commonData/deleteApplication2CommonRelations";
        String response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)application2CommonRelationParam)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void deleteSpecialApplication2CommonRelations(Application2CommonRelationParam application2CommonRelationParam, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/commonData/deleteSpecialApplication2CommonRelations";
        String response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)application2CommonRelationParam)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void createApplication2CommonRelation(CreateApplicationRelationParam createApplicationRelationParam, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/application/createApplication2CommonRelation";
        String response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)createApplicationRelationParam)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void createAllTenantEntityAndCommonRelation(List<String> tenantIdList, String application, String version, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/createAllTenantEntityAndCommonRelation";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantIdList", tenantIdList);
        param.put("version", version);
        param.put("application", application);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(param)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public List<Cql> getCqlByRelation(CreateApplicationRelationParam createApplicationRelationParam, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/application/getCqlByRelation";
        String response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)createApplicationRelationParam)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        List cqlList = responseObj.getJSONArray("data").toJavaList(Cql.class);
        return cqlList;
    }

    public void transExecute(List<Cql> cqlList, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/executeCqlTrans";
        String response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString(cqlList)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void createTenantAndApplicationRelation(Tenant2NodeRelationParam tenant2NodeRelationParam, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/createTenantAndApplicationRelation";
        String response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)tenant2NodeRelationParam)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void createAllAuthTenantAndApplicationRelation(Tenant2NodeRelationParam tenant2NodeRelationParam, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/createAllAuthTenantAndApplicationRelation";
        String response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)tenant2NodeRelationParam)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public List<String> getAuthAppTenantIdList(Tenant2NodeRelationParam tenant2NodeRelationParam, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/getAuthAppTenantIdList";
        String response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)tenant2NodeRelationParam)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        List authAppTenantIdList = responseObj.getJSONArray("data").toJavaList(String.class);
        return authAppTenantIdList;
    }

    public void createTenantAndCommonRelation(Tenant2NodeRelationParam tenant2NodeRelationParam, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/createTenantAndCommonRelation";
        String response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)tenant2NodeRelationParam)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void createAllTenantAndCommonRelation(String version, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/createAllTenantAndCommonRelation/" + version;
        String response = ((HttpRequest)HttpUtil.createGet((String)url).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public JSONObject authUser(DeployParamV2 deployParamV2, String token, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String authApiUrl = backendDomain + "/athena-deployer-service/tenant/authTenantUser";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("digi-middleware-auth-user", token);
        try {
            List applicationDataList = deployParamV2.getApplicationDataList();
            for (ApplicationData applicationData : applicationDataList) {
                applicationData.setAppId(applicationData.getApplication());
            }
            response = ((HttpRequest)HttpUtil.createPost((String)authApiUrl).body(JSON.toJSONString((Object)deployParamV2)).addHeaders(header)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/tenant/authTenantUser \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj;
    }

    public void updateGmcMoudle(GmcUpdateParam gmcUpdateParam) {
        String response;
        String env = gmcUpdateParam.getEnv();
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/updateGmcMoudle";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("digi-middleware-auth-user", gmcUpdateParam.getToken());
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(header)).body(JSON.toJSONString((Object)gmcUpdateParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/tenant/updateGmcMoudle \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void updateCommonGmcMoudle(GmcUpdateParam gmcUpdateParam) {
        String response;
        String env = gmcUpdateParam.getEnv();
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/updateCommonGmcModule";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("digi-middleware-auth-user", gmcUpdateParam.getToken());
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(header)).body(JSON.toJSONString((Object)gmcUpdateParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/tenant/updateGmcMoudle \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public JSONObject allTenant(String token, String tenantId, String env) {
        String backendDomain = this.initEnv(env);
        String allTenantApiUrl = backendDomain + "/athena-deployer-service/tenant/allTenant?tenantId=" + tenantId;
        log.info("allTenantApiUrl:{}", (Object)allTenantApiUrl);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("digi-middleware-auth-user", token);
        String response = ((HttpRequest)HttpUtil.createGet((String)allTenantApiUrl).addHeaders(header)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        return responseObj;
    }

    public TenantUserResult allUserInTenant(String tenantId, String token, Integer pageSize, Integer pageNum, String env) {
        String backendDomain = this.initEnv(env);
        Object allUserApiUrl = backendDomain + "/athena-deployer-service/tenant/allUserInTenant?tenantId={}&pageSize={}&pageNum={}";
        allUserApiUrl = StrUtil.format((CharSequence)allUserApiUrl, (Object[])new Object[]{tenantId, pageSize, pageNum});
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("digi-middleware-auth-user", token);
        String response = ((HttpRequest)HttpUtil.createGet((String)allUserApiUrl).addHeaders(header)).timeout(this.timeoutNum.intValue()).execute().body();
        return (TenantUserResult)JSON.parseObject((String)response, TenantUserResult.class);
    }

    public boolean currentUserExistInTenant(String userId, String tenantId, String token, String env) {
        String backendDomain = this.initEnv(env);
        Object userExistApiUrl = backendDomain + "/athena-deployer-service/tenant/currentUserExistInTenant?userId={}&tenantId={}";
        userExistApiUrl = StrUtil.format((CharSequence)userExistApiUrl, (Object[])new Object[]{userId, tenantId});
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("digi-middleware-auth-user", token);
        try {
            String response = ((HttpRequest)HttpUtil.createGet((String)userExistApiUrl).addHeaders(header)).timeout(this.timeoutNum.intValue()).execute().body();
            return Boolean.parseBoolean(response);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u662f\u5426\u5728\u6307\u5b9a\u79df\u6237\u7528\u6237\u5217\u8868\u5931\u8d25:", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public void parseResponse(JSONObject res) {
        Integer code = res.getInteger("code");
        if (code == null || code != 0) {
            throw new BusinessException(JSON.toJSONString((Object)res));
        }
    }

    public void tbbStatementPublish(JSONObject jsonObject, String branch, String token) {
        String env = jsonObject.getString("env");
        String backendDomain = this.initEnv(env);
        String tbbInnerToken = this.getTbbToken(token, branch);
        jsonObject.put("tbbInnerToken", (Object)tbbInnerToken);
        jsonObject.put("branch", (Object)branch);
        ModuleConfig.Module tbb = this.moduleConfig.getTbb();
        if (null != tbb && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tbb.getDomain()})) {
            jsonObject.put("tbb_uri", (Object)tbb.getDomain());
        }
        assert (tbb != null);
        log.info("getTbbToken:{},tbb_uri:{}", (Object)tbbInnerToken, (Object)tbb.getDomain());
        String tbbStatementPublishApiUrl = backendDomain + "/athena-deployer-service/deploy/tbbStatementPublish";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("digi-middleware-auth-user", token);
        String response = ((HttpRequest)HttpUtil.createPost((String)tbbStatementPublishApiUrl).addHeaders(header)).body(jsonObject.toJSONString()).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void abiStatementPublish(JSONObject jsonObject, String token, String env) {
        String backendDomain = this.initEnv(env);
        String abiInnerToken = this.getAbiToken(token);
        log.info("getAbiToken:" + abiInnerToken);
        jsonObject.put("abiInnerToken", (Object)abiInnerToken);
        String abiStatementPublishApiUrl = backendDomain + "/athena-deployer-service/deploy/abiStatementPublish";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("digi-middleware-auth-user", token);
        String response = ((HttpRequest)HttpUtil.createPost((String)abiStatementPublishApiUrl).addHeaders(header)).body(jsonObject.toJSONString()).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void kmCacheReset(String env, String tenantId) {
        String backendDomain = this.initEnv(env);
        String allTenantApiUrl = backendDomain + "/athena-deployer-service/deploy/kmCacheReset/" + tenantId;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        String response = ((HttpRequest)HttpUtil.createGet((String)allTenantApiUrl).addHeaders(header)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void kmUpdateAppComponentList(String env, String appCode, String version, String tenantId) {
        String backendDomain = this.initEnv(env);
        String allTenantApiUrl = backendDomain + "/athena-deployer-service/deploy/kmUpdateAppComponentList/" + appCode + "/" + tenantId + "/" + version;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        String response = ((HttpRequest)HttpUtil.createGet((String)allTenantApiUrl).addHeaders(header)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void atmcCacheReset(String env) {
        String backendDomain = this.initEnv(env);
        String allTenantApiUrl = backendDomain + "/athena-deployer-service/deploy/atmcCacheReset";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        String response = ((HttpRequest)HttpUtil.createGet((String)allTenantApiUrl).addHeaders(header)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void syncEspMetaData(String deployVersion, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/commonData/syncEspMetaData?deployVersion=" + deployVersion;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        String response = ((HttpRequest)HttpUtil.createGet((String)url).addHeaders(header)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public String getIsvCode(String tenantId, String env) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/iam/getIsvCode?tenantId=" + tenantId;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        String response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(header)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.getString("data");
    }

    public JSONObject customPublish(CustomPublishParam customPublishParam) {
        String backendDomain = this.initEnv(customPublishParam.getEnv());
        String writeData2DbApiUrl = backendDomain + "/athena-deployer-service/deploy/customPublish";
        String response = ((HttpRequest)HttpUtil.createPost((String)writeData2DbApiUrl).body(JSON.toJSONString((Object)customPublishParam)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj;
    }

    public void lcdpPublish(LcdpPublishParam lcdpPublishParam) {
        String response;
        String env = lcdpPublishParam.getEnv();
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/lcdp/publish";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)lcdpPublishParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/lcdp/publish \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void adTemplatePublish(AdTemplatePublishParam adTemplatePublishParam) {
        String response;
        String env = adTemplatePublishParam.getEnv();
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/adTemplate/publishV2";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)adTemplatePublishParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/adTemplate/publish \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void iamAddPolicy(IamAddPolicyParam iamAddPolicyParam) {
        String response;
        String env = iamAddPolicyParam.getEnv();
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/iam/iamAddPolicy";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)iamAddPolicyParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/iam/iamAddPolicy \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void commonIamAddPolicy(IamAddPolicyParam iamAddPolicyParam) {
        String response;
        String env = iamAddPolicyParam.getEnv();
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/iam/commonIamAddPolicy";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)iamAddPolicyParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/iam/iamAddPolicy \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void syncAbi(String env, List<String> resIds, String application, String token, String tenantId) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/statement/syncAbi?env=" + env + "&application=" + application + "&token=" + token + "&tenantId=" + tenantId;
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString(resIds)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/statement/syncAbi \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void iamAssignmentAuthorize(IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam) {
        String response;
        String env = iamAssignmentAuthorizeParam.getEnv();
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/iam/iamAssignmentAuthorize";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)iamAssignmentAuthorizeParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/iam/iamAssignmentAuthorize \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void commonIamAssignmentAuthorize(IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam) {
        String response;
        String env = iamAssignmentAuthorizeParam.getEnv();
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/iam/commonIamAssignmentAuthorize";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)iamAssignmentAuthorizeParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/iam/iamAssignmentAuthorize \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void tbbAuthorize(LcdpPublishParam lcdpPublishParam) {
        String response;
        String env = lcdpPublishParam.getEnv();
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/lcdp/tbbAuthorize";
        try {
            lcdpPublishParam.setEnv(null);
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)lcdpPublishParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/lcdp/tbbAuthorize \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void executeCql(List<Cql> cqlList, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/executeCqlTrans";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString(cqlList)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/deploy/executeCqlTrans \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void executeBson(ExecuteBsonParam executeBsonParam, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/executeBson";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)executeBsonParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/deploy/executeBson \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void cleanMongoData(CleanMongoParam cleanMongoParam, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/cleanMongoData";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)cleanMongoParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/deploy/cleanMongoData \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void cleanNeo4jData(CleanNeo4jParam cleanNeo4jParam, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/cleanNeo4jData";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)cleanNeo4jParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/deploy/cleanNeo4jData \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void modifyDifferenceData(String application, String version, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        Object url = backendDomain + "/athena-deployer-service/deploy/modifyDifferenceData?application={}&version={}";
        url = StrUtil.format((CharSequence)url, (Object[])new Object[]{application, version});
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/deploy/modifyDifferenceData \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void publishModel(String env, JSONObject param) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/pageDesign/publishModel";
        param.put("designerDomain", (Object)this.designerDomain);
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/pageDesign/publishModel \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void deleteModel(String env, JSONObject param) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/pageDesign/deleteModel";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)param)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/pageDesign/deleteModel \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public JSONArray publishActionMetaData(String env, JSONObject param) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/pageDesign/publishActionMetaData";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)param)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/pageDesign/publishActionMetaData \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        JSONArray apiBaseInfos = responseObj.getJSONArray("data");
        return apiBaseInfos;
    }

    public void deleteActionMetaData(String env, JSONObject param) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/pageDesign/deleteActionMetaData";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)param)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/pageDesign/deleteActionMetaData \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public JSONObject queryApiVersionAndStatus(String env, JSONObject param) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/apimgmt/queryApiVersionAndStatus";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)param)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/pageDesign/queryApiVersionAndStatus \u63a5\u53e3\u8d85\u65f6");
        }
        if (StringUtils.isBlank((CharSequence)response)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        JSONObject dataObject = responseObj.getJSONObject("data");
        return dataObject;
    }

    public void deleteApiMetaData(String env, JSONObject param) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/pageDesign/deleteApiMetaData";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)param)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/pageDesign/deleteApiMetaData \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void updateEspActionEnumKey(String env, JSONObject espActionEnumKeyObj) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/action/updateEspActionEnumKey";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)espActionEnumKeyObj)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/action/updateEspActionEnumKey \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void publishScDispatcherTemplate(AdTemplatePublishParam adTemplatePublishParam) {
        String response;
        String backendDomain = this.initEnv(adTemplatePublishParam.getEnv());
        String url = backendDomain + "/athena-deployer-service/adTemplate/publishScDispatcherTemplateV2";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)adTemplatePublishParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/adTemplate/publishScDispatcherTemplate \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void disableTemplateAllVersion(AdTemplatePublishParam adTemplatePublishParam) {
        String response;
        String backendDomain = this.initEnv(adTemplatePublishParam.getEnv());
        String url = backendDomain + "/athena-deployer-service/adTemplate/disableTemplateAllVersionV2";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)adTemplatePublishParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/adTemplate/disableTemplateAllVersion \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public ResultBean<String> incrementSwitchEspAction(String env, String id) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/action/incrementEspActionInSwitch/" + id;
        try {
            HttpResponse httpResponse = ((HttpRequest)HttpUtil.createGet((String)url).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute();
            if (200 != httpResponse.getStatus()) {
                throw new RuntimeException("/athena-deployer-service/action/incrementEspActionInSwitch \u63a5\u53e3\u5931\u8d25:" + httpResponse.body());
            }
            response = ((HttpRequest)HttpUtil.createGet((String)url).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/action/incrementEspActionInSwitch \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        Integer code = responseObj.getInteger("code");
        if (code.equals(-2)) {
            throw new BusinessException(JSON.toJSONString((Object)responseObj));
        }
        if (code.equals(-1)) {
            return ResultBean.fail((Integer)-1, (String)JSON.toJSONString((Object)responseObj));
        }
        return ResultBean.success();
    }

    public void modifyTenantRelaWithNotMatchAppDataInSwitch(String env, String application, List<String> tenantIdList, Boolean commonApp) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/modifyTenantRelaWithNotMatchAppDataInSwitch";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantIds", tenantIdList);
        param.put("application", application);
        param.put("commonApp", commonApp);
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString(param)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/tenant/modifyTenantRelaWithNotMatchAppDataInSwitch \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void modifyTenantRelaWithNotMatchAppDataInPublish(String env, String application, List<String> tenantIdList) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/modifyTenantRelaWithNotMatchAppDataInPublish";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantIds", tenantIdList);
        param.put("application", application);
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString(param)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/tenant/modifyTenantRelaWithNotMatchAppDataInPublish \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void modifyTenantConfig(String env, List<String> tenantIdList, String tenantVersion) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/modifyTenantConfig";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantIds", tenantIdList);
        param.put("tenantVersion", tenantVersion);
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString(param)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/tenant/modifyTenantConfig \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void publishKitAssign(String env, List<JSONObject> kitAssigns, String token, String tenantId) {
        String backendDomain = this.initEnv(env);
        String compileAndSaveSets = backendDomain + "/athena-deployer-service/deploy/compileAndSaveSets";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("token", token);
        JSONObject body = new JSONObject();
        body.put("sets", kitAssigns);
        body.put("tenantId", (Object)tenantId);
        String response = ((HttpRequest)HttpUtil.createPost((String)compileAndSaveSets).addHeaders(header)).body(JSON.toJSONString((Object)body)).timeout(this.timeoutNum.intValue()).execute().body();
        log.info("publish to km success response:" + response);
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void publishModuleRecord(String targetTenantId, String serviceCode, String env, String application, String code, String operateType, String token, JSONObject modelSchema) {
        String backendDomain = this.initEnv(env);
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("application", application);
        request.put("sourceType", operateType);
        request.put("code", code);
        request.put("targetTenantId", targetTenantId);
        request.put("designerDomain", this.designerDomain);
        request.put("serviceCode", serviceCode);
        if (modelSchema != null) {
            request.put("modelSchema", (String)modelSchema);
        }
        Map headers = this.getHeaders(token);
        String apiName = "/athena-deployer-service/modulePublish/record";
        ((HttpRequest)HttpRequest.post((String)(backendDomain + apiName)).addHeaders(headers)).body(JSON.toJSONString(request)).timeout(this.timeoutNum.intValue()).execute().body();
    }

    private Map<String, String> getHeaders(String token) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", token);
        return headers;
    }

    public boolean checkIsNeedPublish(String targetTenantId, String serviceCode, String application, String code, Date editDate, String env, String token, String operateType, JSONObject modelSchema) {
        String backendDomain = this.initEnv(env);
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("application", application);
        request.put("code", code);
        request.put("targetTenantId", targetTenantId);
        request.put("designerDomain", this.designerDomain);
        request.put("editDate", editDate);
        request.put("serviceCode", serviceCode);
        request.put("operateType", operateType);
        if (modelSchema != null) {
            request.put("modelSchema", modelSchema);
        }
        Map headers = this.getHeaders(token);
        String apiName = "/athena-deployer-service/modulePublish/checkIsNeedPublish";
        String response = ((HttpRequest)HttpRequest.post((String)(backendDomain + apiName)).addHeaders(headers)).body(JSON.toJSONString(request)).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.getBoolean("data");
    }

    public String deployAppDataByKm(String env, KmDeploySwitchParam kmDeploySwitchParam) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/deployAppDataByKm";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)kmDeploySwitchParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/deploy/deployAppDataByKm \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.getString("data");
    }

    public String switchAppDataByKm(String env, KmDeploySwitchParam kmDeploySwitchParam) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/switchAppDataByKm";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)kmDeploySwitchParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/deploy/switchAppDataByKm \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.getString("data");
    }

    public Object processLogsByKm(String env, KmDeploySwitchParam kmDeploySwitchParam) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/processLogsByKm";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)kmDeploySwitchParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/deploy/processLogsByKm \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.get((Object)"data");
    }

    public void customDataViewPublish(CustomPublishParam customPublishParam) {
        String backendDomain = this.initEnv(customPublishParam.getEnv());
        String writeData2DbApiUrl = backendDomain + "/athena-deployer-service/deploy/customDataViewPublish";
        String response = ((HttpRequest)HttpUtil.createPost((String)writeData2DbApiUrl).body(JSON.toJSONString((Object)customPublishParam)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void syncDataViewToDapAndTbb(CustomPublishParam customPublishParam, List<JSONObject> dataViewList, String branch) {
        log.info("begin syncdataViewToDap");
        HashMap<String, List> dataViewMap = new HashMap<String, List>();
        String appToken = "";
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        for (JSONObject jSONObject : dataViewList) {
            JSONObject dataViewJsonObject = jSONObject.getJSONObject("dataView");
            appToken = jSONObject.getString("appToken");
            String type = dataViewJsonObject.getString("type");
            String dataViewCode = jSONObject.getString("code");
            if (StringUtils.isNotBlank((CharSequence)type) && type.equals("api")) continue;
            String productCode = dataViewJsonObject.getString("productCode");
            this.designerApiHelper.syncTbbNeedBranch(customPublishParam.getApplication(), "view", dataViewCode, productCode, currentUser.getToken(), branch);
            if (dataViewMap.containsKey(productCode)) {
                List jsonObjects = (List)dataViewMap.get(productCode);
                jsonObjects.add(dataViewJsonObject);
                dataViewMap.put(productCode, jsonObjects);
                continue;
            }
            ArrayList<JSONObject> dataViewObjectList = new ArrayList<JSONObject>();
            dataViewObjectList.add(dataViewJsonObject);
            dataViewMap.put(productCode, dataViewObjectList);
        }
        for (Map.Entry entry : dataViewMap.entrySet()) {
            String serviceCode = (String)entry.getKey();
            List dataViewJsonObjectList = (List)entry.getValue();
            PublishSyncDataParam publishSyncDataParam = new PublishSyncDataParam();
            HashMap<String, Object> dataViewApiRequestMap = new HashMap<String, Object>();
            dataViewApiRequestMap.put("publishFlag", "batch");
            dataViewApiRequestMap.put("application", customPublishParam.getApplication());
            ArrayList<ViewInfo> viewInfos = new ArrayList<ViewInfo>();
            for (JSONObject dataViewJSONObject : dataViewJsonObjectList) {
                ViewInfo viewInfo = new ViewInfo();
                viewInfo.setCode(dataViewJSONObject.getString("code"));
                viewInfo.setApplication(dataViewJSONObject.getString("application"));
                viewInfo.setModelId(dataViewJSONObject.getString("modelId"));
                DataViewViewInfo dataViewViewInfo = new DataViewViewInfo();
                dataViewViewInfo.setCode(dataViewJSONObject.getString("code"));
                dataViewViewInfo.setOrderList((Object)dataViewJSONObject.getJSONArray("orderList"));
                dataViewViewInfo.setQueryConditions((Object)dataViewJSONObject.getJSONArray("queryConditions"));
                dataViewViewInfo.setReturnFields((Object)dataViewJSONObject.getJSONObject("returnFields"));
                dataViewViewInfo.setTables((Object)dataViewJSONObject.getJSONArray("tables"));
                viewInfo.setDataView(dataViewViewInfo);
                viewInfos.add(viewInfo);
            }
            dataViewApiRequestMap.put("viewInfos", viewInfos);
            publishSyncDataParam.setDataViewMap(dataViewApiRequestMap);
            publishSyncDataParam.setServiceCode(serviceCode);
            publishSyncDataParam.setAppToken(appToken);
            publishSyncDataParam.setTenantId(customPublishParam.getCurrentUser().getTenantId());
            try {
                this.customDataViewDapPublish(publishSyncDataParam, customPublishParam);
            }
            catch (Exception exception) {
                log.error("sysc dataView have exception ={}", (Object)exception.getMessage());
            }
        }
    }

    public void customDataViewDapPublish(PublishSyncDataParam publishSyncDataParam, CustomPublishParam customPublishParam) {
        String backendDomain = this.initEnv(customPublishParam.getEnv());
        String writeData2DbApiUrl = backendDomain + "/athena-deployer-service/publish/sync/syncDataViewToLcdpDataView";
        String response = ((HttpRequest)HttpUtil.createPost((String)writeData2DbApiUrl).body(JSON.toJSONString((Object)publishSyncDataParam)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void customProcessPublish(CustomPublishParam customPublishParam) {
        String backendDomain = this.initEnv(customPublishParam.getEnv());
        String writeData2DbApiUrl = backendDomain + "/athena-deployer-service/deploy/customProcessPublish";
        String response = ((HttpRequest)HttpUtil.createPost((String)writeData2DbApiUrl).body(JSON.toJSONString((Object)customPublishParam)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public Object queryTenantVersion(String tenantId, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/tenantVersion/" + tenantId;
        try {
            response = ((HttpRequest)HttpUtil.createGet((String)url).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/tenant/tenantVersion \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.get((Object)"data");
    }

    public Object queryAppRelatenantVersion(String appCode, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/appRelatenantVersion/" + appCode;
        try {
            response = ((HttpRequest)HttpUtil.createGet((String)url).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/tenant/appRelatenantVersion \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.get((Object)"data");
    }

    public Object queryCurTenantVersion(List<String> tenantIdList, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/curTenantVersion";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString(tenantIdList)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/tenant/curTenantVersion \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.get((Object)"data");
    }

    public void mergeRelationBetweenTenantAndAppInVersionChange(List<String> tenantIdList, String env, String application, String targetVersion, Object tenantVersionMap) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/mergeRelationBetweenTenantAndAppInVersionChange";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("application", application);
        body.put("tenantIds", tenantIdList);
        body.put("targetVersion", targetVersion);
        body.put("tenantVersionMap", tenantVersionMap);
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString(body)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/tenant/mergeRelationBetweenTenantAndAppInVersionChange \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public List<Relation> findApp2OtherAppRelations(Application2CommonRelationParam findApplication2CommonParam, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/commonData/findApp2OtherAppRelations";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)findApplication2CommonParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/commonData/findApp2OtherAppRelations \u63a5\u53e3\u8d85\u65f6");
        }
        try {
            JSONObject responseObj = JSON.parseObject((String)response);
            this.parseResponse(responseObj);
            List application2CommonRelations = responseObj.getJSONArray("data").toJavaList(Relation.class);
            return application2CommonRelations;
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u6790findApp2OtherAppRelations\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u6709\u8bef\uff0c\u8fd4\u56de\u6570\u636e\uff1a" + response);
        }
    }

    public List<Relation> findSpecialApp2OtherCommonAppRelations(Application2CommonRelationParam findApplication2CommonParam, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/commonData/findSpecialApp2OtherCommonAppRelations";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)findApplication2CommonParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/commonData/findSpecialApp2OtherCommonAppRelations \u63a5\u53e3\u8d85\u65f6");
        }
        try {
            JSONObject responseObj = JSON.parseObject((String)response);
            this.parseResponse(responseObj);
            List application2CommonRelations = responseObj.getJSONArray("data").toJavaList(Relation.class);
            return application2CommonRelations;
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u6790findSpecialApp2OtherCommonAppRelations\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u6709\u8bef\uff0c\u8fd4\u56de\u6570\u636e\uff1a" + response);
        }
    }

    public void mergeCommonAppRelaWithVirtualTenant(String application, String appVersion, String tenantVersion, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/mergeCommonAppRelaWithVirtualTenant";
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("application", application);
        body.put("appVersion", appVersion);
        body.put("tenantVersion", tenantVersion);
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString(body)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/deploy/mergeCommonAppRelaWithVirtualTenant \u63a5\u53e3\u8d85\u65f6");
        }
        try {
            JSONObject responseObj = JSON.parseObject((String)response);
            this.parseResponse(responseObj);
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u6790mergeCommonAppRelaWithVirtualTenant\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u6709\u8bef\uff0c\u8fd4\u56de\u6570\u636e\uff1a" + response);
        }
    }

    public void deleteCommonAppRelaWithVirtualTenant(String application, String appVersion, String tenantVersion, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/deleteCommonAppRelaWithVirtualTenant";
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("application", application);
        body.put("appVersion", appVersion);
        body.put("tenantVersion", tenantVersion);
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString(body)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/deploy/deleteCommonAppRelaWithVirtualTenant \u63a5\u53e3\u8d85\u65f6");
        }
        try {
            JSONObject responseObj = JSON.parseObject((String)response);
            this.parseResponse(responseObj);
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u6790deleteCommonAppRelaWithVirtualTenant\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u6709\u8bef\uff0c\u8fd4\u56de\u6570\u636e\uff1a" + response);
        }
    }

    public void deleteCommonApp2OtherAppRelations(Application2CommonRelationParam findApplication2CommonParam, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/commonData/deleteCommonApp2OtherAppRelations";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)findApplication2CommonParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/commonData/deleteCommonApp2OtherAppRelations \u63a5\u53e3\u8d85\u65f6");
        }
        try {
            JSONObject responseObj = JSON.parseObject((String)response);
            this.parseResponse(responseObj);
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u6790deleteCommonApp2OtherAppRelations\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u6709\u8bef\uff0c\u8fd4\u56de\u6570\u636e\uff1a" + response);
        }
    }

    public void deleteSpecialApp2CommonAppRelations(Application2CommonRelationParam findApplication2CommonParam, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/commonData/deleteSpecialApp2CommonAppRelations";
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)findApplication2CommonParam)).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/commonData/deleteSpecialApp2CommonAppRelations \u63a5\u53e3\u8d85\u65f6");
        }
        try {
            JSONObject responseObj = JSON.parseObject((String)response);
            this.parseResponse(responseObj);
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u6790deleteSpecialApp2CommonAppRelations\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u6709\u8bef\uff0c\u8fd4\u56de\u6570\u636e\uff1a" + response);
        }
    }

    public void customEventPublish(CustomPublishParam customPublishParam) {
        String backendDomain = this.initEnv(customPublishParam.getEnv());
        String writeData2DbApiUrl = backendDomain + "/athena-deployer-service/deploy/customEventPublish";
        String response = ((HttpRequest)HttpUtil.createPost((String)writeData2DbApiUrl).body(JSON.toJSONString((Object)customPublishParam)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void testKgRouterKey(String env, String routerKey) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/testKgRouterKey?routerKey=" + routerKey;
        String response = ((HttpRequest)HttpUtil.createGet((String)url).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public String getAbiToken(String token) {
        String url = this.designerDomain + "/athena-designer/activityConfigs/getAbiInnerToken";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("digi-middleware-auth-user", token);
        HttpEntity mapHttpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, mapHttpEntity, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            throw new BusinessException("/restful/standard/tbb-system/permission/getInnerToken Http\u8bf7\u6c42\u5f02\u5e38:" + (String)response.getBody());
        }
        ResultBean resultDto = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (!ResultBean.SUCCESS_CODE.equals(resultDto.getCode())) {
            throw new BusinessException("/restful/standard/tbb-system/permission/getInnerToken \u7ed3\u679c\u5f02\u5e38:" + (String)response.getBody());
        }
        return (String)resultDto.getData();
    }

    public String getTbbToken(String token, String branch) {
        String url = this.designerDomain + "/athena-designer/activityConfigs/getTbbInnerToken";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("digi-middleware-auth-user", token);
        if (StrUtil.isBlank((CharSequence)branch)) {
            branch = "develop";
        }
        httpHeaders.add("branch", branch);
        HttpEntity mapHttpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, mapHttpEntity, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            throw new BusinessException("/athena-designer/activityConfigs/getTbbInnerToken Http\u8bf7\u6c42\u5f02\u5e38:" + (String)response.getBody());
        }
        ResultBean resultDto = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (!ResultBean.SUCCESS_CODE.equals(resultDto.getCode())) {
            throw new BusinessException("/athena-designer/activityConfigs/getTbbInnerToken \u7ed3\u679c\u5f02\u5e38:" + (String)response.getBody());
        }
        return (String)resultDto.getData();
    }

    public void syncPushData(String appId, String env, List<TenantUser> tenantUsers, String currTenantId, String version) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/syncPushData";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("appCodes", ListUtil.toList((Object[])new String[]{appId}));
        body.put("version", version);
        body.put("tenantId", tenantUsers.get(0).getTenantId());
        body.put("currTenantId", currTenantId);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(body)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void pushSynonym(String application, String env, List<TenantUser> tenantUsers, String tenantId, String version, List<JSONObject> synonymList) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/pushSynonym";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("appCode", application);
        body.put("version", version);
        body.put("tenantUsers", tenantUsers);
        body.put("currTenantId", tenantId);
        body.put("synonyms", synonymList);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(body)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void syncBackUri(String application, String appType, String env) {
        String backendDomain = this.initEnv(env);
        Object addApplicationVersionUrl = backendDomain + "/athena-deployer-service/deploy/syncBackUri?application={}&appType={}";
        addApplicationVersionUrl = StrUtil.format((CharSequence)addApplicationVersionUrl, (Object[])new Object[]{application, appType});
        String response = ((HttpRequest)HttpUtil.createGet((String)addApplicationVersionUrl).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void pushStandardParams(String application, String env, List<TenantUser> tenantUsers, String tenantId, String version, List<JSONObject> standardParamsList) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/pushStandardParams";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("appCode", application);
        body.put("version", version);
        body.put("tenantUsers", tenantUsers);
        body.put("currTenantId", tenantId);
        body.put("standardParams", standardParamsList);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(body)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void executeMechanismCompile(String env, String application, List<String> mechanismCodes) {
        String backendDomain = this.initEnv(env);
        String tenantId = AthenaUserLocal.getUser().getTenantId();
        String url = backendDomain + "/athena-deployer-service/km/applyMechanisms/" + tenantId;
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        JSONObject body = new JSONObject();
        body.put("mechanismCodes", mechanismCodes);
        body.put("application", (Object)application);
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        log.info("km applyMechanisms request:{}", (Object)httpEntity);
        ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, ResultBean.class, new Object[0]);
        log.info("km applyMechanisms response:{}", (Object)exchange);
        if (((ResultBean)exchange.getBody()).getCode() != 0) {
            throw new BusinessException("km applyMechanisms error:" + ((ResultBean)exchange.getBody()).getMsg());
        }
    }

    public void customDataEntryAndModelDapPublish(PublishDataEntryAndModelDataParam publishDataEntryAndModelDataParam, String env) {
        String backendDomain = this.initEnv(env);
        String writeData2DbApiUrl = backendDomain + "/athena-deployer-service/publish/sync/syncActivityAndModelToLcdp";
        ((HttpRequest)HttpUtil.createPost((String)writeData2DbApiUrl).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)publishDataEntryAndModelDataParam)).execute().body();
    }

    public void judgeModelDrivenEvnVersion(PublishDataEntryAndModelDataParam publishDataEntryAndModelDataParam, String env) {
        String backendDomain = this.initEnv(env);
        String writeData2DbApiUrl = backendDomain + "/athena-deployer-service/publish/sync/judgeModelDrivenEvnVersion";
        String response = ((HttpRequest)HttpUtil.createPost((String)writeData2DbApiUrl).header("Content-Type", "application/json")).body(JSON.toJSONString((Object)publishDataEntryAndModelDataParam)).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        log.info("judgeModelDrivenEvnVersion" + JSON.toJSONString((Object)responseObj));
        Integer code = responseObj.getInteger("code");
        if (code == null || code != 0) {
            throw new BusinessException(responseObj.getString("msg"));
        }
    }

    public void deployCleanApp(KmDeployCleanApp kmDeployCleanApp, String env) {
        String backendDomain = this.initEnv(env);
        String deployApiUrl = backendDomain + "/athena-deployer-service/km/deployCleanApp";
        String response = ((HttpRequest)HttpUtil.createPost((String)deployApiUrl).body(JSON.toJSONString((Object)kmDeployCleanApp)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        log.info("/athena-deployer-service/km/deployCleanApp response is -->{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        if (responseObj.getInteger("code") != 0) {
            throw new BusinessException("\u8c03\u7528/athena-deployer-service/km/deployCleanApp\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + response);
        }
    }

    public void deleteAppModel(JSONObject jsonObject, String env) {
        String backendDomain = this.initEnv(env);
        String deployApiUrl = backendDomain + "/athena-deployer-service/pageDesign/deleteAppModel";
        String response = ((HttpRequest)HttpUtil.createPost((String)deployApiUrl).body(JSON.toJSONString((Object)jsonObject)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        log.info("/athena-deployer-service/km/deployCleanApp response is -->{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        if (responseObj.getInteger("code") != 0) {
            throw new BusinessException("\u8c03\u7528/athena-deployer-service/km/deployCleanApp\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + response);
        }
    }

    public Object queryTenantVersionBySameCustomId(String tenantId, String env) {
        String response;
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/tenant/sameCustomIdTenantVersion/" + tenantId;
        try {
            response = ((HttpRequest)HttpUtil.createGet((String)url).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        }
        catch (IORuntimeException e) {
            throw new BusinessException("/athena-deployer-service/tenant/sameCustomIdTenantVersion \u63a5\u53e3\u8d85\u65f6");
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
        return responseObj.get((Object)"data");
    }

    public void pushSynonymToAI(String application, String env, List<TenantUser> tenantUsers, String tenantId, String version, List<JSONObject> synonymList) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/pushSynonymToAI";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("appCode", application);
        body.put("version", version);
        body.put("tenantUsers", tenantUsers);
        body.put("currTenantId", tenantId);
        body.put("synonyms", synonymList);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(body)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void syncVariableData(String application, String env, List<TenantUser> tenantUsers, String tenantId) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/syncVariableData";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("appCodes", ListUtil.toList((Object[])new String[]{application}));
        body.put("tenantUsers", tenantUsers);
        body.put("currTenantId", tenantId);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(body)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void messageCenterPublishDap(String env, MessageCenterTask.MessageCenterPublishData messageCenterPublishData) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/publish/sync/syncMessageCenterToDap";
        log.info("\u8bf7\u6c42 /athena-deployer-service/publish/sync/syncMessageCenterToDap \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)messageCenterPublishData));
        String response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString((Object)messageCenterPublishData)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        log.info("/athena-deployer-service/publish/sync/syncMessageCenterToDap response is -->{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        if (responseObj.getInteger("code") != 0) {
            throw new BusinessException("\u8c03\u7528/athena-deployer-service/publish/sync/syncMessageCenterToDap\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + response);
        }
    }

    public void pushNounKnowledge(String application, String env, List<TenantUser> tenantUsers, String tenantId, String version, List<JSONObject> nounKnowledgeList) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/pushNounKnowledge";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("appCode", application);
        body.put("version", version);
        body.put("tenantUsers", tenantUsers);
        body.put("currTenantId", tenantId);
        body.put("nounKnowledge", nounKnowledgeList);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(body)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void pushHabitKnowledge(String application, String env, List<TenantUser> tenantUsers, String tenantId, String version, List<JSONObject> habitKnowledgeList) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/pushHabitKnowledge";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("appCode", application);
        body.put("version", version);
        body.put("tenantUsers", tenantUsers);
        body.put("currTenantId", tenantId);
        body.put("habitKnowledge", habitKnowledgeList);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(body)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }

    public void assistantPublish(String application, String env, String appName, String userId, String version) {
        String backendDomain = this.initEnv(env);
        String url = backendDomain + "/athena-deployer-service/deploy/assistantPublish";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("eventType", "assistant.published");
        body.put("eventId", UUID.randomUUID());
        JSONObject event = new JSONObject();
        event.put("userId", (Object)userId);
        event.put("assistantId", (Object)application);
        event.put("assistantName", (Object)appName);
        event.put("version", (Object)version);
        body.put("event", ListUtil.toList((Object[])new JSONObject[]{event}));
        String response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(body)).header("Content-Type", "application/json")).timeout(this.timeoutNum.intValue()).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj);
    }
}

