/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.http;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.domain.ApplicationPO;
import com.digiwin.athena.athenadeployer.domain.AssistantProjectModelPO;
import com.digiwin.athena.athenadeployer.domain.AssistantProjectPO;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.CollectionPKPO;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.compile.CompileParam;
import com.digiwin.athena.athenadeployer.http.designer.dto.SecurityTaskDto;
import com.digiwin.athena.athenadeployer.utils.CurThreadInfoUtils;
import com.digiwin.athena.auth.metadata.domain.ResourceRole;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"privateEnv"}, havingValue="false", matchIfMissing=true)
public class DesignerApiHelper {
    @Value(value="${designer.domain}")
    private String designerDomain;

    public JSONObject queryCompileVersion(String application) {
        String deployApiUrl = this.designerDomain + "/athena-designer/expose/queryCompileVersion?application=" + application;
        String response = ((HttpRequest)HttpUtil.createGet((String)deployApiUrl).header("Content-Type", "application/json")).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        return responseObj;
    }

    public String compile(CompileParam compileParam, String token) {
        String url = this.designerDomain + "/athena-designer/application/compile";
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).addHeaders(headers)).body(JSON.toJSONString((Object)compileParam)).execute().body();
        this.parseResponse(response);
        JSONObject responseObj = JSON.parseObject((String)response);
        return responseObj.getString("data");
    }

    public List<JSONObject> queryCompiledDataList(String application, String token) {
        String apiName = "/athena-designer/expose/queryCompiledDataList?application={}";
        apiName = StrUtil.format((CharSequence)apiName, (Object[])new Object[]{application});
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)HttpRequest.get((String)(this.designerDomain + apiName)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getJSONArray("data").toJavaList(JSONObject.class);
    }

    public List<JSONObject> queryCompiledDataByApplications(List<String> applications, String token) {
        String apiName = "/athena-designer/expose/queryCompiledDataByApplications";
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)HttpRequest.post((String)(this.designerDomain + apiName)).addHeaders(headers)).body(JSON.toJSONString(applications)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getJSONArray("data").toJavaList(JSONObject.class);
    }

    public List<JSONObject> queryPageDesignList(String application, String token) {
        String apiName = "/athena-designer/pageDesign/queryByApplication?application={}";
        apiName = StrUtil.format((CharSequence)apiName, (Object[])new Object[]{application});
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)HttpRequest.get((String)(this.designerDomain + apiName)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getJSONArray("data").toJavaList(JSONObject.class);
    }

    public JSONObject queryCompiledDataByCode(String code, String token) {
        String apiName = "/athena-designer/expose/queryCompiledDataByCode?code={}";
        apiName = StrUtil.format((CharSequence)apiName, (Object[])new Object[]{code});
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)HttpRequest.get((String)(this.designerDomain + apiName)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getJSONObject("data");
    }

    public ApplicationPO getApplicationByCode(String application, String token) {
        String apiName = "/athena-designer/expose/getApplicationByCode?application={}";
        apiName = StrUtil.format((CharSequence)apiName, (Object[])new Object[]{application});
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)HttpRequest.get((String)(this.designerDomain + apiName)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return (ApplicationPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject.getJSONObject("data")), ApplicationPO.class);
    }

    public AssistantProjectPO getProjectByAssistantCode(String assistantCode, String token) {
        String apiName = "/athena-designer/expose/getProjectByAssistantCode?assistantCode={}";
        apiName = StrUtil.format((CharSequence)apiName, (Object[])new Object[]{assistantCode});
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)HttpRequest.get((String)(this.designerDomain + apiName)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return Objects.isNull(jsonObject.getJSONObject("data")) ? null : (AssistantProjectPO)jsonObject.getJSONObject("data").toJavaObject(AssistantProjectPO.class);
    }

    public List<CollectionPKPO> queryAllCollectionPk(String token) {
        String apiName = "/athena-designer/expose/queryAllCollectionPk";
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)HttpRequest.get((String)(this.designerDomain + apiName)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getJSONArray("data").toJavaList(CollectionPKPO.class);
    }

    public JSONObject queryNeo4jNodeKeyJson(String token) {
        String apiName = "/athena-designer/expose/queryNeo4jNodeKeyJson";
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)HttpRequest.get((String)(this.designerDomain + apiName)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getJSONObject("data");
    }

    public JSONObject updatePageDesignModelPulishState(String code, String serviceCode, String token, String branch) {
        String apiName = "/athena-designer/expose/updatePageDesignModelPulishState/{}/{}";
        apiName = StrUtil.format((CharSequence)apiName, (Object[])new Object[]{code, serviceCode});
        Map headers = this.getHeaders(token);
        headers.put("branch", branch);
        String response = ((HttpRequest)HttpRequest.get((String)(this.designerDomain + apiName)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getJSONObject("data");
    }

    public List<ResourceRole> queryResourceRole(String resourceType) {
        String apiName = "/athena-designer/auth/queryResourceRoleUser?resourceType={}";
        apiName = StrUtil.format((CharSequence)apiName, (Object[])new Object[]{resourceType});
        Map headers = this.getHeaders(AthenaUserLocal.getUser().getToken());
        String response = ((HttpRequest)HttpRequest.get((String)(this.designerDomain + apiName)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getJSONArray("data").toJavaList(ResourceRole.class);
    }

    public List<JSONObject> allAppInTenant() {
        String apiName = "/athena-designer/application/allAppInTenant";
        Map headers = this.getHeaders(AthenaUserLocal.getUser().getToken());
        headers.put("individualCase", CurThreadInfoUtils.getIndividualCase().toString());
        String response = ((HttpRequest)HttpRequest.get((String)(this.designerDomain + apiName)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getJSONArray("data").toJavaList(JSONObject.class);
    }

    public List<JSONObject> queryApplicationByCodes(List<String> appCodes) {
        String apiName = "/athena-designer/application/queryByCodes";
        Map headers = this.getHeaders(AthenaUserLocal.getUser().getToken());
        String response = ((HttpRequest)HttpRequest.post((String)(this.designerDomain + apiName)).body(JSON.toJSONString(appCodes)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getJSONArray("data").toJavaList(JSONObject.class);
    }

    private JSONObject parseResponse(String response) {
        JSONObject jsonObject = JSON.parseObject((String)response);
        Integer code = jsonObject.getInteger("code");
        if (code == null || code != 0) {
            throw new BusinessException(JSON.toJSONString((Object)jsonObject));
        }
        return jsonObject;
    }

    private Map<String, String> getHeaders(String token) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", token);
        return headers;
    }

    public JSONObject deleteAbandonModel(List<String> modelCodes, String serviceCode, String token) {
        String apiName = "/athena-designer/modelDriver/modelAssign/deleteAbandonModel";
        Map headers = this.getHeaders(token);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("serviceCode", serviceCode);
        body.put("modelCodes", modelCodes);
        String response = ((HttpRequest)HttpRequest.post((String)(this.designerDomain + apiName)).addHeaders(headers)).body(JSON.toJSONString(body)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getJSONObject("data");
    }

    public void syncTbb(String modelCode, String serviceCode, String token) {
        String apiName = "/athena-designer/tbb/syncTbb";
        Map headers = this.getHeaders(token);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("serviceCode", serviceCode);
        body.put("code", modelCode);
        ((HttpRequest)HttpRequest.post((String)(this.designerDomain + apiName)).addHeaders(headers)).body(JSON.toJSONString(body)).execute().body();
    }

    public ResultBean addSecurityTask(SecurityTaskDto securityTaskDto, String token) {
        String url = this.designerDomain + "/athena-designer/securityAudit/addSecurityAuditTask";
        Map headers = this.getHeaders(token);
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)url).addHeaders(headers)).body(JSON.toJSONString((Object)securityTaskDto)).execute();
        if (200 != response.getStatus()) {
            throw new BusinessException("addSecurityAuditTask fail:" + response.body());
        }
        return (ResultBean)JSON.parseObject((String)response.body(), ResultBean.class);
    }

    public AssistantProjectModelPO getModel(String projectCode, String token) {
        String apiName = "/athena-designer/expose/getModelsByProjectCode?projectCode={}";
        apiName = StrUtil.format((CharSequence)apiName, (Object[])new Object[]{projectCode});
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)HttpRequest.get((String)(this.designerDomain + apiName)).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return Objects.isNull(jsonObject.getJSONObject("data")) ? null : (AssistantProjectModelPO)jsonObject.getJSONObject("data").toJavaObject(AssistantProjectModelPO.class);
    }

    public ResultBean updateProject(AssistantProjectPO assistantProjectPO, String token) {
        String url = this.designerDomain + "/athena-designer/expose/updateProject";
        Map headers = this.getHeaders(token);
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)url).addHeaders(headers)).body(JSON.toJSONString((Object)assistantProjectPO)).execute();
        if (200 != response.getStatus()) {
            throw new BusinessException("updateProject fail:" + response.body());
        }
        return (ResultBean)JSON.parseObject((String)response.body(), ResultBean.class);
    }

    public ResultBean nluCrossAreaDeploy(JSONObject crossAreaDeployInfo, String token) {
        String url = this.designerDomain + "/athena-designer/expose/nluCroessAreaDeploy";
        Map headers = this.getHeaders(token);
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)url).addHeaders(headers)).body(JSON.toJSONString((Object)crossAreaDeployInfo)).execute();
        if (200 != response.getStatus()) {
            throw new BusinessException("nluCrossAreaDeploy fail:" + response.body());
        }
        return (ResultBean)JSON.parseObject((String)response.body(), ResultBean.class);
    }

    public ResultBean esCrossAreaDeploy(JSONObject crossAreaDeployInfo, String token) {
        String url = this.designerDomain + "/athena-designer/expose/esCroessAreaDeploy";
        Map headers = this.getHeaders(token);
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)url).addHeaders(headers)).body(JSON.toJSONString((Object)crossAreaDeployInfo)).execute();
        if (200 != response.getStatus()) {
            throw new BusinessException("esCrossAreaDeploy fail:" + response.body());
        }
        return (ResultBean)JSON.parseObject((String)response.body(), ResultBean.class);
    }

    public void syncTbbNeedBranch(String application, String type, String modelCode, String serviceCode, String token, String branch) {
        String apiName = "/athena-designer/tbb/syncTbb";
        Map headers = this.getHeaders(token);
        headers.put("branch", branch);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("type", type);
        body.put("serviceCode", serviceCode);
        body.put("code", modelCode);
        body.put("application", application);
        ((HttpRequest)HttpRequest.post((String)(this.designerDomain + apiName)).addHeaders(headers)).body(JSON.toJSONString(body)).execute().body();
    }

    public void upsertDeleteApiFlag(List<String> apiNames, String token) {
        String deleteApiUrl = this.designerDomain + "/athena-designer/api/upsertDeleteApiFlag";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("apiName", apiNames);
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)HttpUtil.createPost((String)deleteApiUrl).addHeaders(headers)).body(JSON.toJSONString((Object)jsonObject)).execute().body();
        this.parseResponse(response);
    }

    public String queryTenantTeamId(String token) {
        String url = this.designerDomain + "/athena-designer/user/tenantTeamId";
        Map headers = this.getHeaders(token);
        String response = ((HttpRequest)HttpRequest.get((String)url).addHeaders(headers)).execute().body();
        JSONObject jsonObject = this.parseResponse(response);
        return jsonObject.getString("data");
    }
}

