/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.http.asa;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.constant.PreLoadData;
import com.digiwin.athena.athenadeployer.dao.mongo.DeployDetailV2Dao;
import com.digiwin.athena.athenadeployer.domain.AthenaUserLocal;
import com.digiwin.athena.athenadeployer.domain.TenantUser;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployDetailV2;
import com.digiwin.athena.athenadeployer.domain.deploy.DeployTask;
import com.digiwin.athena.athenadeployer.http.DesignerApiHelper;
import com.digiwin.athena.athenadeployer.http.asa.AsaDeployerServiceApiHelper;
import com.digiwin.athena.athenadeployer.http.sse.SSEClient;
import com.digiwin.athena.athenadeployer.http.sse.SSEListener;
import com.digiwin.athena.athenadeployer.http.sse.SSEMsgHandler;
import com.digiwin.athena.athenadeployer.service.DmcService;
import com.digiwin.athena.athenadeployer.utils.CurThreadInfoUtils;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;

@Component
public class AsaDeployerServiceApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsaDeployerServiceApiHelper.class);
    private static final Integer MODEL_TYPE_NLU = 2;
    private static final Integer MODEL_TYPE_ES = 3;
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private DeployDetailV2Dao deployDetailV2Dao;
    @Autowired
    private PreLoadData preLoadData;
    @Autowired
    private DmcService dmcService;
    @Resource
    private DesignerApiHelper designerApiHelper;
    @Resource(name="deployerMongoTemplate")
    private MongoTemplate deployerMongoTemplate;

    private String initEnv(String env) {
        Map envUrl = this.preLoadData.getEnvUrl();
        return (String)envUrl.get(env + "-asa_deploy_service");
    }

    public void deploy(String application, JSONObject compiledData, List<TenantUser> tenantUsers, JSONArray tenantIdList, String env, String deployNo, String currentEnv, JSONObject modelInfo) {
        boolean crossDeploySuccess;
        String destEnv = env.split("-")[0];
        String asaDeployerServiceDomain = this.initEnv(env);
        if (!currentEnv.equalsIgnoreCase(destEnv) && !(crossDeploySuccess = this.crossDeploy(application, env, deployNo, modelInfo, destEnv))) {
            return;
        }
        String deployApiUrl = asaDeployerServiceDomain + (asaDeployerServiceDomain.contains("km-deployer-service") ? "/km-deployer-service/asaDeploy" : "/asa-deployer-service/deploy");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("application", application);
        param.put("compiledData", compiledData);
        param.put("tenantUsers", tenantUsers);
        param.put("tenantIdList", tenantIdList);
        param.put("currentUser", AthenaUserLocal.getUser());
        param.put("deployNo", deployNo);
        param.put("currentEnv", currentEnv);
        param.put("env", destEnv);
        param.put("modelInfo", modelInfo);
        try {
            AsaSSEMsgHandler msgHandler = new AsaSSEMsgHandler(this);
            msgHandler.setApplication(application);
            msgHandler.setDeployNo(deployNo);
            msgHandler.setCompiledData(compiledData);
            msgHandler.setIamToken(AthenaUserLocal.getUser().getToken());
            msgHandler.setEnv(env);
            msgHandler.setCloseShareFile(true);
            msgHandler.setDmcService(this.dmcService);
            SSEListener sseListener = new SSEListener((SSEMsgHandler)msgHandler);
            SSEClient.executeAsaSSE((String)deployApiUrl, (String)AthenaUserLocal.getUser().getToken(), (SSEListener)sseListener, (String)JSON.toJSONString(param), (String)AthenaUserLocal.getUser().getTenantId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean crossDeploy(String application, String env, String deployNo, JSONObject modelInfo, String destEnv) {
        if (modelInfo != null && !modelInfo.isEmpty()) {
            boolean nluDeploySucc;
            List modelTypes = (List)modelInfo.getObject("modelTypes", List.class);
            String deployMode = "test";
            if (modelTypes.contains(MODEL_TYPE_NLU) && !(nluDeploySucc = this.crossDeployNlu(application, env, deployNo, modelInfo, destEnv, deployMode))) {
                return nluDeploySucc;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean crossDeployNlu(String application, String env, String deployNo, JSONObject modelInfo, String destEnv, String deployMode) {
        String prodModelCode;
        JSONObject assistantAiProject;
        DeployDetailV2 deployDetailV2 = new DeployDetailV2().setDeployNo(deployNo).setTime(new Date()).setApplication(application).setContent("\u5c0f\u6a21\u578b\u8de8\u533a\u90e8\u7f72");
        String modelCode = modelInfo.getString("modelCode");
        JSONObject assistant = this.queryAssistant(application, "2.0", env);
        if (assistant != null && (assistantAiProject = assistant.getJSONObject("aiProject")) != null && modelCode.equals(prodModelCode = assistantAiProject.getString("modelCode"))) {
            deployMode = "test&prod";
        }
        String logStatus = "success";
        JSONObject crossAreaDeployInfo = new JSONObject();
        crossAreaDeployInfo.put("projectCode", (Object)application);
        crossAreaDeployInfo.put("modelCode", (Object)modelCode);
        crossAreaDeployInfo.put("deployArea", (Object)destEnv);
        crossAreaDeployInfo.put("deployMode", (Object)deployMode);
        try {
            this.designerApiHelper.nluCrossAreaDeploy(crossAreaDeployInfo, AthenaUserLocal.getUser().getToken());
            deployDetailV2.setResult(logStatus);
        }
        catch (Exception e) {
            log.error("cross area deploy failed", (Throwable)e);
            logStatus = "fail";
            deployDetailV2.setResult(logStatus).setErrorStack((Object)e.getStackTrace()).setErrorMessage(e.getMessage());
            this.updateDeployLogResult(application, deployNo, logStatus);
            boolean bl = false;
            return bl;
        }
        finally {
            this.insertDeployDetail(deployDetailV2);
        }
        return true;
    }

    private void updateDeployLogResult(String application, String deployNo, String result) {
        Update update = new Update();
        update.set("result", (Object)result);
        this.mongoTemplate.upsert(new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("deployNo").is((Object)deployNo)), (UpdateDefinition)update, "deployLog");
    }

    private void insertDeployDetail(DeployDetailV2 deployDetailV2) {
        DeployTask deployTaskInfo = CurThreadInfoUtils.getDeployTaskInfo();
        if (deployTaskInfo != null) {
            deployDetailV2.setTaskType(deployTaskInfo.getType());
        }
        this.deployDetailV2Dao.insert(deployDetailV2);
    }

    public void switchVersion(String application, List<TenantUser> tenantUsers, JSONArray tenantIdList, String env, String deployNo, JSONObject neo4jNodeKeyJson) {
        String asaDeployerServiceDomain;
        String deployApiUrl = asaDeployerServiceDomain + ((asaDeployerServiceDomain = this.initEnv(env)).contains("km-deployer-service") ? "/km-deployer-service/asaDeploy/switchVersion" : "/asa-deployer-service/deploy/switchVersion");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantIdList", tenantIdList);
        param.put("tenantUsers", tenantUsers);
        param.put("application", application);
        param.put("currentUser", AthenaUserLocal.getUser());
        param.put("deployNo", deployNo);
        param.put("neo4jNodeKeyJson", neo4jNodeKeyJson);
        param.put("env", env.split("-")[0]);
        try {
            AsaSSEMsgHandler msgHandler = new AsaSSEMsgHandler(this);
            msgHandler.setApplication(application);
            msgHandler.setDeployNo(deployNo);
            msgHandler.setIamToken(AthenaUserLocal.getUser().getToken());
            msgHandler.setEnv(env);
            SSEListener sseListener = new SSEListener((SSEMsgHandler)msgHandler);
            SSEClient.executeAsaSSE((String)deployApiUrl, (String)AthenaUserLocal.getUser().getToken(), (SSEListener)sseListener, (String)JSON.toJSONString(param), (String)AthenaUserLocal.getUser().getTenantId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject queryAssistant(String application, String version, String env) {
        String asaDeployerServiceDomain;
        String queryAssistantApiUrl = asaDeployerServiceDomain + ((asaDeployerServiceDomain = this.initEnv(env)).contains("km-deployer-service") ? "/km-deployer-service/assistant/queryAssistant" : "/asa-deployer-service/assistant/queryAssistant");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("assistantCode", application);
        param.put("version", version);
        String response = ((HttpRequest)HttpUtil.createPost((String)queryAssistantApiUrl).body(JSON.toJSONString(param)).header("Content-Type", "application/json")).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        return responseObj;
    }
}

