/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.http.deployService;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.athenadeployer.constant.PreLoadData;
import com.digiwin.athena.athenadeployer.domain.base.BusinessException;
import com.digiwin.athena.athenadeployer.domain.base.ResultBean;
import com.digiwin.athena.athenadeployer.domain.deploy.CommonParadigmDeployParam;
import com.digiwin.athena.athenadeployer.domain.deploy.GmcUpdateParam;
import com.digiwin.athena.athenadeployer.dto.deployer.ChangeDataPublishStatusReqDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.DataPublishStatusReqDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.DeletePermissionReqDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.DeployAppReqDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.DeployAppResDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.EspActionIdSwitchResDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.SwitchAppReqDto;
import com.digiwin.athena.athenadeployer.http.deployService.dto.TenantVersionUpdateReqDto;
import com.digiwin.athena.athenadeployer.service.deployTask.SyncMobileDesignCodeTask;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
@ConditionalOnProperty(name={"privateEnv"}, havingValue="false", matchIfMissing=true)
public class DeployServiceApiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployServiceApiHelper.class);
    @Resource(name="httpRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private PreLoadData preLoadData;

    public List<EspActionIdSwitchResDto> assignSwitchEspAction(String env, String id, String actionIds) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/action/assignSwitchEspAction?id=%s&actionIds=%s";
        try {
            ResponseEntity response = this.restTemplate.getForEntity(String.format(url, id, actionIds), String.class, new Object[0]);
            if (HttpStatus.OK != response.getStatusCode()) {
                throw new BusinessException("http statue:" + response.getStatusCode().value());
            }
            String body = (String)response.getBody();
            ResultBean resultBean = (ResultBean)JSONObject.parseObject((String)body, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            if (!resultBean.getCode().equals(0)) {
                throw new BusinessException(String.format("assignSwitchEspAction ResultBean statue:%s msg:%s", resultBean.getCode(), resultBean.getMsg()));
            }
            return (List)resultBean.getData();
        }
        catch (Exception e) {
            throw new BusinessException("assignSwitchEspAction http \u8bf7\u6c42\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    public DeployAppResDto deployApp(String env, DeployAppReqDto deployAppReqDto) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/deploy/deployApp";
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)deployAppReqDto, (MultiValueMap)httpHeaders);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            if (HttpStatus.OK != response.getStatusCode()) {
                throw new BusinessException("/athena-deployer-service/deploy/deployApp \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCode().value());
            }
            ResultBean resultBean = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            if (!resultBean.getCode().equals(0)) {
                throw new BusinessException(String.format("deployApp ResultBean statue:%s msg:%s", resultBean.getCode(), resultBean.getMsg()));
            }
            return (DeployAppResDto)resultBean.getData();
        }
        catch (Exception e) {
            throw new BusinessException("/athena-deployer-service/deploy/deployApp http \u8bf7\u6c42\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    public DeployAppResDto switchApp(String env, SwitchAppReqDto switchAppReqDto) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/deploy/switchApp";
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)switchAppReqDto, (MultiValueMap)httpHeaders);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            if (HttpStatus.OK != response.getStatusCode()) {
                throw new BusinessException("/athena-deployer-service/deploy/switchApp \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCode().value());
            }
            ResultBean resultBean = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            if (!resultBean.getCode().equals(0)) {
                throw new BusinessException(String.format("deployApp ResultBean statue:%s msg:%s", resultBean.getCode(), resultBean.getMsg()));
            }
            return (DeployAppResDto)resultBean.getData();
        }
        catch (Exception e) {
            throw new BusinessException("/athena-deployer-service/deploy/switchApp http \u8bf7\u6c42\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    public List<EspActionIdSwitchResDto> kmAssignSwitchEspAction(String env, String token, String id, String actionIds) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/action/kmAssignSwitchEspAction?id=" + id + "&actionIds=" + actionIds;
        log.info("kmAssignSwitchEspAction url" + url);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("token", token);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
            if (HttpStatus.OK != response.getStatusCode()) {
                throw new BusinessException("http statue:" + response.getStatusCode().value());
            }
            String body = (String)response.getBody();
            ResultBean resultBean = (ResultBean)JSONObject.parseObject((String)body, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            if (!resultBean.getCode().equals(0)) {
                throw new BusinessException(String.format("assignSwitchEspAction ResultBean statue:%s msg:%s", resultBean.getCode(), resultBean.getMsg()));
            }
            return (List)resultBean.getData();
        }
        catch (Exception e) {
            throw new BusinessException("assignSwitchEspAction http \u8bf7\u6c42\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    public void updateVersion(String env, TenantVersionUpdateReqDto tenantVersionUpdateReqDto) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        log.info("==================" + JSONObject.toJSONString((Object)this.preLoadData));
        log.info("==================" + env);
        String url = backendDomain + "/athena-deployer-service/deploy/updateVersion";
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)tenantVersionUpdateReqDto, (MultiValueMap)httpHeaders);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            if (HttpStatus.OK != response.getStatusCode()) {
                throw new BusinessException("/athena-deployer-service/deploy/updateVersion \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCode().value());
            }
            ResultBean resultBean = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            if (!resultBean.getCode().equals(0)) {
                throw new BusinessException(String.format("deployApp ResultBean statue:%s msg:%s", resultBean.getCode(), resultBean.getMsg()));
            }
        }
        catch (Exception e) {
            throw new BusinessException("/athena-deployer-service/deploy/updateVersion http \u8bf7\u6c42\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    public void iamCleanTenant(String env, String application, String tenantId) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/iam/iamCleanTenant";
        HttpHeaders httpHeaders = new HttpHeaders();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appId", application);
        param.put("tenantId", tenantId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)httpHeaders);
        ResponseEntity response = null;
        try {
            response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            log.error("/athena-deployer-service/iam/iamCleanTenant exception:" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("/athena-deployer-service/iam/iamCleanTenant exception:" + e.getMessage());
        }
        ResultBean resultBean = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), ResultBean.class);
        if (!resultBean.getCode().equals(0)) {
            throw new RuntimeException("/athena-deployer-service/iam/iamCleanTenant" + resultBean.getMsg());
        }
    }

    public void iamModuleSupplement(String env, String application, List<JSONObject> dynamicModuleInfo) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/iam/iamModuleSupplement";
        HttpHeaders httpHeaders = new HttpHeaders();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appCode", application);
        param.put("moduleParam", dynamicModuleInfo);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)httpHeaders);
        ResponseEntity response = null;
        try {
            response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            log.error("/athena-deployer-service/iam/iamModuleSupplement exception:" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("/athena-deployer-service/iam/iamModuleSupplement exception:" + e.getMessage());
        }
        ResultBean resultBean = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), ResultBean.class);
        if (!resultBean.getCode().equals(0)) {
            throw new RuntimeException("/athena-deployer-service/iam/iamModuleSupplement" + resultBean.getMsg());
        }
    }

    public void createGmcCommodity(String env, JSONObject application) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/gmc/createGmcCommodity";
        HttpHeaders httpHeaders = new HttpHeaders();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appCode", application.get((Object)"code"));
        param.put("appName", application.get((Object)"name"));
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)httpHeaders);
        ResponseEntity response = null;
        try {
            response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            log.error("/athena-deployer-service/gmc/createGmcCommodity exception:" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("/athena-deployer-service/gmc/createGmcCommodity exception:" + e.getMessage());
        }
        ResultBean resultBean = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), ResultBean.class);
        if (!resultBean.getCode().equals(0)) {
            throw new RuntimeException("/athena-deployer-service/gmc/createGmcCommodity" + resultBean.getMsg());
        }
    }

    public void gmcModuleSupplement(String env, GmcUpdateParam gmcUpdateParam) {
        String response;
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/tenant/gmcModuleSupplement";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("digi-middleware-auth-user", gmcUpdateParam.getToken());
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(header)).body(JSON.toJSONString((Object)gmcUpdateParam)).execute().body();
        }
        catch (Exception e) {
            throw new BusinessException("/athena-deployer-service/tenant/gmcModuleSupplement \u8bbf\u95ee\u62a5\u9519\uff0c\u62a5\u9519\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj, "/athena-deployer-service/tenant/gmcModuleSupplement");
    }

    public void parseResponse(JSONObject res, String url) {
        Integer code = res.getInteger("code");
        if (code == null || code != 0) {
            log.error(url + "\u8bbf\u95ee\u62a5\u9519\uff0c\u8fd4\u56de\u4fe1\u606f:" + JSON.toJSONString((Object)res));
            throw new BusinessException(JSON.toJSONString((Object)res));
        }
    }

    public void syncTenantAthenaDesigner(String env, JSONObject param) {
        String response;
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/atdp/syncAppData";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(header)).body(JSON.toJSONString((Object)param)).execute().body();
        }
        catch (Exception e) {
            throw new BusinessException("/athena-deployer-service/atdp/syncAppData \u8bbf\u95ee\u62a5\u9519\uff0c\u62a5\u9519\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj, "/athena-deployer-service/atdp/syncAppData");
    }

    public void deployCleanTenantApp(String application, String env) {
        String response;
        String deployDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String deployApiUrl = deployDomain + "/athena-deployer-service/atdp/deployCleanTenantApp";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("application", (Object)application);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)deployApiUrl).body(JSON.toJSONString((Object)jsonObject)).addHeaders(header)).execute().body();
        }
        catch (Exception e) {
            throw new BusinessException("/athena-deployer-service/atdp/deployCleanTenantApp \u8bbf\u95ee\u62a5\u9519\uff0c\u62a5\u9519\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        log.info("/athena-deployer-service/atdp/deployCleanTenantApp response is -->{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        this.parseResponse(responseObj, "/athena-deployer-service/atdp/deployCleanTenantApp");
    }

    public void commonParadigmDeployApp(String env, CommonParadigmDeployParam deployParam) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/paradigm/deploy/commonParadigmDeploy";
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)deployParam, (MultiValueMap)httpHeaders);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            if (HttpStatus.OK != response.getStatusCode()) {
                throw new BusinessException("/athena-deployer-service/paradigm/deploy/commonParadigmDeploy \u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCode().value());
            }
            ResultBean resultBean = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            if (!resultBean.getCode().equals(0)) {
                throw new BusinessException(String.format("commonParadigmDeploy ResultBean statue:%s msg:%s", resultBean.getCode(), resultBean.getMsg()));
            }
        }
        catch (Exception e) {
            throw new BusinessException("/athena-deployer-service/paradigm/deploy/commonParadigmDeploy http \u8bf7\u6c42\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    public JSONObject getGmcGoodInfo(String env, String appCode) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/gmc/gmcGoodInfo/" + appCode;
        ResponseEntity response = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        if (!HttpStatus.OK.equals((Object)response.getStatusCode())) {
            log.error("\u67e5\u8be2gmc\u5546\u54c1\u4fe1\u606f-aadcs\u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue() + " responseEntity:" + String.valueOf(response));
            throw new BusinessException("\u67e5\u8be2gmc\u5546\u54c1\u4fe1\u606f-aadcs\u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue());
        }
        ResultBean res = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (!res.getCode().equals(0)) {
            throw new BusinessException("getGmcGoodInfo:" + res.getMsg());
        }
        return (JSONObject)res.getData();
    }

    public List<JSONObject> getIamPublicActions(String env, String appCode) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/iam/iamPublicActions/" + appCode;
        ResponseEntity response = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        if (!HttpStatus.OK.equals((Object)response.getStatusCode())) {
            log.error("\u67e5\u8be2IAM\u516c\u5171\u4f5c\u4e1a-aadcs\u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue() + " responseEntity:" + String.valueOf(response));
            throw new BusinessException("\u67e5\u8be2IAM\u516c\u5171\u4f5c\u4e1a-aadcs\u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue());
        }
        JSONObject res = JSONObject.parseObject((String)((String)response.getBody()));
        if (!res.getInteger("code").equals(0)) {
            throw new BusinessException("getIamPublicActions\u62a5\u9519:" + String.valueOf(res));
        }
        return JSON.parseArray((String)res.getString("data"), JSONObject.class);
    }

    public void mobilePublish(String env, SyncMobileDesignCodeTask.MobileSyncInfoDto mobileSyncInfoDto) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/mobileDesign/publish";
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)mobileSyncInfoDto, (MultiValueMap)httpHeaders);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            JSONObject jsonObject = JSONObject.parseObject((String)((String)response.getBody()));
            if (!"0".equals(jsonObject.getString("code"))) {
                log.error("/athena-deployer-service/mobile/publish,\u8bf7\u6c42\u5f02\u5e38:" + jsonObject.getString("msg"));
                throw new RuntimeException(jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            log.error("/athena-deployer-service/mobile/publish,\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("/athena-deployer-service/mobile/publish,\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public Boolean iamBatchDeletePermissions(String env, DeletePermissionReqDto deletePermissionReqDto) {
        HttpHeaders httpHeaders;
        HttpEntity httpEntity;
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/iam/iamBatchDeletePermissions";
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)(httpEntity = new HttpEntity((Object)deletePermissionReqDto, (MultiValueMap)(httpHeaders = new HttpHeaders()))), String.class, new Object[0]);
        ResultBean resultDto = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), ResultBean.class);
        if (!resultDto.getCode().equals(0)) {
            log.error(String.format("iamBatchDeletePermissions \u5931\u8d25:%s", response.getBody()));
            throw new RuntimeException("\u6279\u91cf\u5220\u9664\u9f0e\u6377\u4e91\u6743\u9650\u5931\u8d25\uff0c" + resultDto.getMsg());
        }
        return true;
    }

    public List<ChangeDataPublishStatusReqDto> checkKmTaskStatus(String env, List<DataPublishStatusReqDto> dataPublishStatusReqDtos) {
        HttpHeaders httpHeaders;
        HttpEntity httpEntity;
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/deploy/checkKmTaskStatus";
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)(httpEntity = new HttpEntity(dataPublishStatusReqDtos, (MultiValueMap)(httpHeaders = new HttpHeaders()))), String.class, new Object[0]);
        ResultBean resultDto = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (!resultDto.getCode().equals(0)) {
            log.error(String.format("checkKmTaskStatus \u5931\u8d25:%s", response.getBody()));
            throw new RuntimeException("\u83b7\u53d6km\u53d1\u5e03\u4efb\u52a1\u72b6\u6001\u5931\u8d25\uff0c" + resultDto.getMsg());
        }
        return (List)resultDto.getData();
    }

    public String getIntegrationToken(String env, String tenantId) {
        String backendDomain = (String)this.preLoadData.getEnvUrl().get(env + "-deploy_service");
        String url = backendDomain + "/athena-deployer-service/tenant/getIntegrationToken?tenantId=" + tenantId;
        log.info("getIntegrationTokenBySpecifyEnv url:" + url);
        ResponseEntity response = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        if (!HttpStatus.OK.equals((Object)response.getStatusCode())) {
            log.error("Http\u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue() + " responseEntity:" + String.valueOf(response));
            throw new BusinessException("Http\u8bf7\u6c42\u5f02\u5e38:" + response.getStatusCodeValue());
        }
        ResultBean res = (ResultBean)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (!res.getCode().equals(0)) {
            throw new BusinessException(String.format("TenantId: %s \u83b7\u53d6\u96c6\u6210token\u5931\u8d25", tenantId));
        }
        return (String)res.getData();
    }
}

