/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.interceptor;

import com.digiwin.athena.athenadeployer.utils.CurThreadInfoUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class CurThreadInterceptor
implements HandlerInterceptor {
    public static final Set<String> INDIVIDUAL_CASE_WHITE_URLS = new HashSet();
    public static final List<Pattern> INDIVIDUAL_CASE_WHITE_PATTERN_URLS = new ArrayList();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String requestURI = request.getRequestURI();
        String individualCase = request.getHeader("individualCase");
        if (!StringUtils.isEmpty((CharSequence)individualCase)) {
            Boolean individualCaseWhiteFlag = false;
            for (Pattern pattern : INDIVIDUAL_CASE_WHITE_PATTERN_URLS) {
                Matcher matcher = pattern.matcher(requestURI);
                individualCaseWhiteFlag = individualCaseWhiteFlag != false && matcher.matches();
            }
            if (!INDIVIDUAL_CASE_WHITE_URLS.contains(requestURI) && !individualCaseWhiteFlag.booleanValue()) {
                if (!StringUtils.isEmpty((CharSequence)individualCase)) {
                    CurThreadInfoUtils.setIndividualCase((Boolean)new Boolean(individualCase));
                }
            } else {
                CurThreadInfoUtils.setIndividualCase((Boolean)false);
            }
        } else {
            CurThreadInfoUtils.setIndividualCase((Boolean)false);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        CurThreadInfoUtils.removeIndividualCase();
    }
}

