/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.neo4j;

import com.digiwin.athena.athenadeployer.config.neo4j.Neo4jManager;
import com.digiwin.athena.athenadeployer.domain.Cql;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class CqlMapper {
    public static Cql updateTenantVersion(List<String> tenantIdList, String version) {
        String cql = "match (tenant:TenantEntity) where tenant.tenantId in $tenantId set tenant.version = $version";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantId", tenantIdList);
        param.put("version", version);
        return new Cql().setCql(cql).setParams(param);
    }

    public static Cql deleteTenantOldRelation(List<String> tenantIdList) {
        String cql = "match (tenant:TenantEntity)-[oldRelation]-(node) where tenant.tenantId in $tenantId and not any(label in labels(node) WHERE label in ['AppEntity']) delete oldRelation";
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("tenantId", tenantIdList);
        return new Cql().setCql(cql).setParams(param);
    }

    public static Cql mergeTenantAppRelation(List<String> tenantIdList) {
        String cql = "match(t:TenantEntity) where t.tenantId in $tenantId match(app:AppEntity) merge (t)-[:USE]->(app)";
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("tenantId", tenantIdList);
        return new Cql().setCql(cql).setParams(param);
    }

    public static Cql queryTenantAppList(String tenantId) {
        String cql = "match (tenant:TenantEntity)-[:USE]-(app:AppEntity) where tenant.tenantId=$tenantId return tenant.tenantId as tenantId,tenant.version as version,app.code as appCode,app.namespace as appNamespace";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        return new Cql().setCql(cql).setParams(param);
    }

    public static List<Cql> mergeTenantAndCommonActionRelation(String tenantId) {
        String cqlStr1 = "match (te:TenantEntity{tenantId:$tenantId}) match (commonAction:Action) where commonAction.nameSpace in['espCommon','common'] and commonAction.version=te.version and commonAction.tenantId is null merge (te)-[:ACTION]->(commonAction)";
        String cqlStr2 = "match (te:TenantEntity{tenantId:$tenantId}) match (commonAction:Action) where commonAction.nameSpace in['espCommon','common'] and commonAction.version=te.version and commonAction.tenantId=te.tenantId merge (te)-[:ACTION]->(commonAction)";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        Cql cql1 = new Cql().setCql(cqlStr1).setParams(param);
        Cql cql2 = new Cql().setCql(cqlStr2).setParams(param);
        return Lists.newArrayList((Object[])new Cql[]{cql1, cql2});
    }

    public static Cql mergeTenantAndCommonTaskRelation(String tenantId) {
        String cql = "match (te:TenantEntity{tenantId:$tenantId}) match (commonTask:Task) where commonTask.nameSpace ='common' and commonTask.version=te.version merge (te)-[:TASK]->(commonTask)";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        return new Cql().setCql(cql).setParams(param);
    }

    public static Cql mergeTenantAndCommonActivityRelation(String tenantId) {
        String cql = "match (te:TenantEntity{tenantId:$tenantId}) match (commonActivity:Activity) where commonActivity.nameSpace ='common' and commonActivity.version=te.version merge (te)-[:ACTIVITY]->(commonActivity)";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        return new Cql().setCql(cql).setParams(param);
    }

    public static Cql mergeTenantAndTaskExcludeTenantTask(String application, String tenantId) {
        List tenantTaskCodeList = CqlMapper.getTenantTaskCodeList((String)application, (String)tenantId);
        String cql = "match (te:TenantEntity{tenantId:$tenantId}) match(task:Task) where task.nameSpace = $nameSpace and task.version=te.version and not task.code in $tenantTaskCodeList merge (te)-[:TASK]->(task)";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantTaskCodeList", tenantTaskCodeList);
        param.put("tenantId", tenantId);
        param.put("nameSpace", application);
        return new Cql().setCql(cql).setParams(param);
    }

    public static List<String> getTenantTaskCodeList(String application, String tenantId) {
        String cql = "match (n:Task) where n.tenantId = $tenantId and n.nameSpace = $application return n.code as code";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("application", application);
        List maps = Neo4jManager.getNeo4jManager().ExecuteQuery(cql, param);
        ArrayList<String> taskCodeList = new ArrayList<String>();
        for (Map map : maps) {
            taskCodeList.add(String.valueOf(map.get("code")));
        }
        return taskCodeList;
    }

    public static List<Cql> mergeTenantAndActivityExcludeTenantActivity(String application, String tenantId) {
        List tenantActivityCodeList = CqlMapper.getTenantActivityCodeList((String)application, (String)tenantId);
        String cqlStr1 = "match (te:TenantEntity{tenantId:$tenantId}) match(activity:Activity) where activity.nameSpace = $nameSpace and activity.version=te.version and activity.inclusionTenant is null and not activity.code in $tenantActivityCodeList merge (te)-[:ACTIVITY]->(activity)";
        String cqlStr2 = "match (te:TenantEntity{tenantId:$tenantId}) match(activity:Activity) where activity.nameSpace = $nameSpace and activity.version=te.version and activity.inclusionTenant is not null and te.tenantId in activity.inclusionTenant and not activity.code in $tenantActivityCodeList merge (te)-[:ACTIVITY]->(activity)";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantActivityCodeList", tenantActivityCodeList);
        param.put("tenantId", tenantId);
        param.put("nameSpace", application);
        Cql cql1 = new Cql().setCql(cqlStr1).setParams(param);
        Cql cql2 = new Cql().setCql(cqlStr2).setParams(param);
        return Lists.newArrayList((Object[])new Cql[]{cql1, cql2});
    }

    private static List<String> getTenantActivityCodeList(String application, String tenantId) {
        String cql = "match (n:Activity) where n.tenantId = $tenantId and n.nameSpace = $nameSpace return n.code as code";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("nameSpace", application);
        List maps = Neo4jManager.getNeo4jManager().ExecuteQuery(cql, param);
        ArrayList<String> activityCodeList = new ArrayList<String>();
        for (Map map : maps) {
            activityCodeList.add(String.valueOf(map.get("code")));
        }
        return activityCodeList;
    }

    public static List<Cql> mergeTenantAndActivityExcludeTenantMonitorRule(String application, String tenantId) {
        List tenantMonitorRuleCodeList = CqlMapper.getTenantMonitorRuleCodeList((String)application, (String)tenantId);
        String cqlStr1 = "match(t:TenantEntity) where t.tenantId=$tenantId match(monitorRule:MonitorRule) where monitorRule.athena_namespace=$applicationCode and monitorRule.inclusionTenant is null and not monitorRule.code in $tenantMonitorRuleCodeList merge (t)-[:USE]->(monitorRule)";
        String cqlStr2 = "match(t:TenantEntity) where t.tenantId=$tenantId match(monitorRule:MonitorRule) where monitorRule.athena_namespace=$applicationCode and monitorRule.inclusionTenant is not null and t.tenantId in monitorRule.inclusionTenant and not monitorRule.code in $tenantMonitorRuleCodeList merge (t)-[:USE]->(monitorRule)";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantMonitorRuleCodeList", tenantMonitorRuleCodeList);
        param.put("tenantId", tenantId);
        param.put("nameSpace", application);
        Cql cql1 = new Cql().setCql(cqlStr1).setParams(param);
        Cql cql2 = new Cql().setCql(cqlStr2).setParams(param);
        return Lists.newArrayList((Object[])new Cql[]{cql1, cql2});
    }

    private static List<String> getTenantMonitorRuleCodeList(String application, String tenantId) {
        String cql = "match (n:MonitorRule) where n.tenantId = $tenantId and n.nameSpace = $nameSpace return n.code as code";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("nameSpace", application);
        List maps = Neo4jManager.getNeo4jManager().ExecuteQuery(cql, param);
        ArrayList<String> activityCodeList = new ArrayList<String>();
        for (Map map : maps) {
            activityCodeList.add(String.valueOf(map.get("code")));
        }
        return activityCodeList;
    }

    public static Cql mergeTenantAndMechanismExcludeTenantMechanism(String application, String tenantId) {
        List tenantMechanismKeyList = CqlMapper.getTenantMechanismKeyList((String)application, (String)tenantId);
        String cql = "match (te:TenantEntity{tenantId:$tenantId}) match(me:Mechanism) where me.nameSpace = $nameSpace and me.version=te.version and not me.key in $tenantMechanismKeyList merge (te)-[:MECHANISM]->(me)";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantMechanismKeyList", tenantMechanismKeyList);
        param.put("tenantId", tenantId);
        param.put("nameSpace", application);
        return new Cql().setCql(cql).setParams(param);
    }

    public static List<String> getTenantMechanismKeyList(String application, String tenantId) {
        String cql = "match (n:Mechanism) where n.tenantId = $tenantId and n.nameSpace = $application return n.key as code";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("application", application);
        List maps = Neo4jManager.getNeo4jManager().ExecuteQuery(cql, param);
        ArrayList<String> mechanismCodeList = new ArrayList<String>();
        for (Map map : maps) {
            mechanismCodeList.add(String.valueOf(map.get("code")));
        }
        return mechanismCodeList;
    }

    public static Cql mergeTenantAndActionExcludeTenantAction(String application, String tenantId) {
        List tenantActionIdList = CqlMapper.getTenantActionIdList((String)application, (String)tenantId);
        String cql = "match (te:TenantEntity{tenantId:$tenantId}) match(action:Action) where action.nameSpace = $nameSpace and action.version=te.version and not action.actionId in $tenantActionIdList merge (te)-[:ACTION]->(action)";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantActionIdList", tenantActionIdList);
        param.put("tenantId", tenantId);
        param.put("nameSpace", application);
        return new Cql().setCql(cql).setParams(param);
    }

    public static List<String> getTenantActionIdList(String application, String tenantId) {
        String cql = "match (n:Action) where n.tenantId = $tenantId and n.nameSpace = $nameSpace return n.actionId as code";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("nameSpace", application);
        List maps = Neo4jManager.getNeo4jManager().ExecuteQuery(cql, param);
        ArrayList<String> actionIdList = new ArrayList<String>();
        for (Map map : maps) {
            actionIdList.add(String.valueOf(map.get("code")));
        }
        return actionIdList;
    }
}

