/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athenadeployer.neo4j;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athenadeployer.utils.FlatMapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.types.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Neo4j {
    @Autowired
    private Session session;

    public List<JSONObject> execute(String cypherSql) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        Result query = this.session.run(cypherSql, new HashMap());
        List records = query.list();
        for (Record record : records) {
            JSONObject jsonObject;
            Value value = record.get("n");
            if (TypeConstructor.NODE.name().equals(value.type().name())) {
                Node node = value.asNode();
                Map properties = node.asMap();
                jsonObject = new JSONObject();
                for (Map.Entry entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    Object propertyValue = entry.getValue();
                    jsonObject.put(key, propertyValue);
                }
                result.add(jsonObject);
                continue;
            }
            Map properties = BeanUtil.beanToMap((Object)record, (String[])new String[0]);
            Map flatten = FlatMapUtil.flatten((Map)properties);
            jsonObject = new JSONObject();
            properties.forEach((k, v) -> jsonObject.put(k, v));
            result.add(jsonObject);
        }
        return result;
    }
}

